/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.AsyncState;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.AsyncContexts;
import com.navercorp.pinpoint.profiler.context.AsyncScopeUtils;
import com.navercorp.pinpoint.profiler.context.Reference;
import com.navercorp.pinpoint.profiler.context.id.LocalTraceRoot;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DisableAsyncContext
implements AsyncContext {
    private static final Logger logger = LogManager.getLogger(DisableAsyncContext.class);
    private final AsyncContexts.Local local;
    private final LocalTraceRoot traceRoot;
    @Nullable
    private final AsyncState asyncState;

    DisableAsyncContext(AsyncContexts.Local local, LocalTraceRoot traceRoot, @Nullable AsyncState asyncState) {
        this.local = Objects.requireNonNull(local, "local");
        this.traceRoot = Objects.requireNonNull(traceRoot, "traceRoot");
        this.asyncState = asyncState;
    }

    public Trace continueAsyncTraceObject() {
        Reference<Trace> reference = this.local.binder().get();
        Trace nestedTrace = reference.get();
        if (nestedTrace != null) {
            return nestedTrace;
        }
        return this.newAsyncContextTrace(reference);
    }

    private Trace newAsyncContextTrace(Reference<Trace> reference) {
        Trace asyncTrace = this.local.asyncTraceContext().continueDisableAsyncContextTraceObject(this.traceRoot);
        this.bind(reference, asyncTrace);
        if (logger.isDebugEnabled()) {
            logger.debug("asyncTraceContext.continueDisableAsyncContextTraceObject() AsyncTrace:{}", (Object)asyncTrace);
        }
        if (AsyncScopeUtils.nested(asyncTrace, "##ASYNC_TRACE_SCOPE")) {
            return null;
        }
        return asyncTrace;
    }

    private void bind(Reference<Trace> reference, Trace asyncTrace) {
        Assert.state((reference.get() == null ? 1 : 0) != 0, (String)"traceReference is  null");
        reference.set(asyncTrace);
    }

    public Trace currentAsyncTraceObject() {
        Reference<Trace> reference = this.local.binder().get();
        return reference.get();
    }

    public void close() {
        this.local.binder().remove();
    }

    public boolean finish() {
        AsyncState copy = this.asyncState;
        if (copy != null) {
            copy.finish();
            return true;
        }
        return false;
    }

    public String toString() {
        return "DisableAsyncContext{traceRoot=" + this.traceRoot + ", asyncState=" + this.asyncState + '}';
    }
}

