/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.message.ShareGroupHeartbeatResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;

public class ShareGroupHeartbeatResponse
extends AbstractResponse {
    private final ShareGroupHeartbeatResponseData data;

    public ShareGroupHeartbeatResponse(ShareGroupHeartbeatResponseData data) {
        super(ApiKeys.SHARE_GROUP_HEARTBEAT);
        this.data = data;
    }

    @Override
    public ShareGroupHeartbeatResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return Collections.singletonMap(Errors.forCode(this.data.errorCode()), 1);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public static ShareGroupHeartbeatResponse parse(ByteBuffer buffer, short version) {
        return new ShareGroupHeartbeatResponse(new ShareGroupHeartbeatResponseData(new ByteBufferAccessor(buffer), version));
    }
}

