/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.canal.source.table;

import java.sql.Connection;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.eventmesh.common.AbstractComponent;
import org.apache.eventmesh.common.config.connector.rdb.JdbcConfig;
import org.apache.eventmesh.common.config.connector.rdb.canal.CanalMySQLType;
import org.apache.eventmesh.common.config.connector.rdb.canal.RdbDBDefinition;
import org.apache.eventmesh.common.config.connector.rdb.canal.RdbTableDefinition;
import org.apache.eventmesh.common.config.connector.rdb.canal.mysql.MySQLColumnDef;
import org.apache.eventmesh.common.config.connector.rdb.canal.mysql.MySQLTableDef;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.connector.canal.SqlUtils;
import org.apache.eventmesh.connector.canal.source.table.RdbSimpleTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdbTableMgr
extends AbstractComponent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RdbTableMgr.class);
    private final JdbcConfig config;
    private final Map<RdbSimpleTable, RdbTableDefinition> tables = new HashMap<RdbSimpleTable, RdbTableDefinition>();
    private final DataSource dataSource;

    public RdbTableMgr(JdbcConfig config, DataSource dataSource) {
        this.config = config;
        this.dataSource = dataSource;
    }

    public RdbTableDefinition getTable(String schema, String tableName) {
        return this.getTable(new RdbSimpleTable(schema, tableName));
    }

    public RdbTableDefinition getTable(RdbSimpleTable table) {
        return this.tables.get((Object)table);
    }

    protected void run() {
        if (this.config != null && this.config.getDatabases() != null) {
            for (RdbDBDefinition db : this.config.getDatabases()) {
                if (db.getTables() == null) {
                    log.warn("init db [{}] position, but it's tables are null", (Object)db.getSchemaName());
                    continue;
                }
                for (RdbTableDefinition table : db.getTables()) {
                    try {
                        MySQLTableDef mysqlTable = new MySQLTableDef();
                        mysqlTable.setSchemaName(db.getSchemaName());
                        mysqlTable.setTableName(table.getTableName());
                        List<String> tables = Collections.singletonList(table.getTableName());
                        Map<String, List<String>> primaryKeys = this.queryTablePrimaryKey(db.getSchemaName(), tables);
                        Map<String, List<MySQLColumnDef>> columns = this.queryColumns(db.getSchemaName(), tables);
                        if (primaryKeys == null || primaryKeys.isEmpty() || primaryKeys.get(table.getTableName()) == null) {
                            log.warn("init db [{}] table [{}] info, and primary keys are empty", (Object)db.getSchemaName(), (Object)table.getTableName());
                        } else {
                            mysqlTable.setPrimaryKeys(primaryKeys.get(table.getTableName()));
                        }
                        if (columns == null || columns.isEmpty() || columns.get(table.getTableName()) == null) {
                            log.warn("init db [{}] table [{}] info, and columns are empty", (Object)db.getSchemaName(), (Object)table.getTableName());
                            throw new EventMeshException("db [{}] table [{}] columns are empty");
                        }
                        LinkedHashMap cols = new LinkedHashMap();
                        columns.get(table.getTableName()).forEach(x -> cols.put(x.getName(), x));
                        mysqlTable.setColumnDefinitions(cols);
                        this.tables.put(new RdbSimpleTable(db.getSchemaName(), table.getTableName()), (RdbTableDefinition)mysqlTable);
                    }
                    catch (SQLException e) {
                        log.error("init rdb table schema [{}] table [{}] fail", new Object[]{db.getSchemaName(), table.getTableName(), e});
                        throw new EventMeshException((Throwable)e);
                    }
                }
            }
        }
    }

    private Map<String, List<String>> queryTablePrimaryKey(String schema, List<String> tables) throws SQLException {
        LinkedHashMap<String, List<String>> primaryKeys = new LinkedHashMap<String, List<String>>();
        String prepareTables = SqlUtils.genPrepareSqlOfInClause(tables.size());
        String sql = "select L.TABLE_NAME,L.COLUMN_NAME,R.CONSTRAINT_TYPE from INFORMATION_SCHEMA.KEY_COLUMN_USAGE L left join INFORMATION_SCHEMA.TABLE_CONSTRAINTS R on L.TABLE_SCHEMA = R.TABLE_SCHEMA and L.TABLE_NAME = R.TABLE_NAME and L.CONSTRAINT_CATALOG = R.CONSTRAINT_CATALOG and L.CONSTRAINT_SCHEMA = R.CONSTRAINT_SCHEMA and L.CONSTRAINT_NAME = R.CONSTRAINT_NAME where L.TABLE_SCHEMA = ? and L.TABLE_NAME in " + prepareTables + " and R.CONSTRAINT_TYPE IN ('PRIMARY KEY') order by L.ORDINAL_POSITION asc";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement statement = conn.prepareStatement(sql);){
            statement.setString(1, schema);
            SqlUtils.setInClauseParameters(statement, 2, tables);
            try (ResultSet rs = statement.executeQuery();){
                if (rs == null) {
                    Map<String, List<String>> map = null;
                    return map;
                }
                while (rs.next()) {
                    String tableName = rs.getString("TABLE_NAME");
                    String colName = rs.getString("COLUMN_NAME");
                    primaryKeys.compute(tableName, (k, v) -> {
                        if (v == null) {
                            v = new LinkedList<String>();
                        }
                        v.add(colName);
                        return v;
                    });
                }
            }
        }
        return primaryKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<MySQLColumnDef>> queryColumns(String schema, List<String> tables) throws SQLException {
        String prepareTables = SqlUtils.genPrepareSqlOfInClause(tables.size());
        String sql = "select TABLE_SCHEMA,TABLE_NAME,COLUMN_NAME,IS_NULLABLE,DATA_TYPE,CHARACTER_MAXIMUM_LENGTH,CHARACTER_OCTET_LENGTH,NUMERIC_SCALE,NUMERIC_PRECISION,DATETIME_PRECISION,CHARACTER_SET_NAME,COLLATION_NAME,COLUMN_TYPE,COLUMN_DEFAULT,COLUMN_COMMENT,ORDINAL_POSITION,EXTRA from INFORMATION_SCHEMA.COLUMNS where TABLE_SCHEMA = ? and TABLE_NAME in " + prepareTables + " order by ORDINAL_POSITION asc";
        LinkedHashMap<String, List<MySQLColumnDef>> cols = new LinkedHashMap<String, List<MySQLColumnDef>>();
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            conn = this.dataSource.getConnection();
            statement = conn.prepareStatement(sql);
            statement.setString(1, schema);
            SqlUtils.setInClauseParameters(statement, 2, tables);
            rs = statement.executeQuery();
            if (rs == null) {
                Map<String, List<MySQLColumnDef>> map = null;
                return map;
            }
            while (rs.next()) {
                String dataType = rs.getString("DATA_TYPE");
                JDBCType jdbcType = SqlUtils.toJDBCType(dataType);
                MySQLColumnDef col = new MySQLColumnDef();
                col.setJdbcType(jdbcType);
                col.setType(CanalMySQLType.valueOfCode((String)dataType));
                String colName = rs.getString("COLUMN_NAME");
                col.setName(colName);
                String tableName = rs.getString("TABLE_NAME");
                cols.compute(tableName, (k, v) -> {
                    if (v == null) {
                        v = new LinkedList<MySQLColumnDef>();
                    }
                    v.add(col);
                    return v;
                });
            }
        }
        catch (SQLException e) {
            log.error("init rdb table schema [{}] tables fail", (Object)schema, (Object)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    log.error("close result set fail", (Throwable)e);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    log.error("close prepare statement fail", (Throwable)e);
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    log.error("close db connection fail", (Throwable)e);
                }
            }
        }
        return cols;
    }

    protected void shutdown() throws Exception {
    }
}

