/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.recursive.comparison;

import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.stream.Stream;
import org.assertj.core.api.recursive.comparison.FieldLocation;
import org.assertj.core.internal.RecursiveHelper;
import org.assertj.core.util.Arrays;

public final class DualValue {
    static final Class<?>[] DEFAULT_ORDERED_COLLECTION_TYPES = Arrays.array(List.class, SortedSet.class, LinkedHashSet.class);
    final FieldLocation fieldLocation;
    final Object actual;
    final Object expected;
    private final int hashCode;

    public DualValue(List<String> path, Object actual, Object expected) {
        this(new FieldLocation(path), actual, expected);
    }

    static DualValue rootDualValue(Object actual, Object expected) {
        return new DualValue(FieldLocation.rootFieldLocation(), actual, expected);
    }

    public DualValue(FieldLocation fieldLocation, Object actualFieldValue, Object expectedFieldValue) {
        this.fieldLocation = Objects.requireNonNull(fieldLocation, "fieldLocation must not be null");
        this.actual = actualFieldValue;
        this.expected = expectedFieldValue;
        this.hashCode = this.computeHashCode();
    }

    private int computeHashCode() {
        return System.identityHashCode(this.actual) + System.identityHashCode(this.expected) + this.fieldLocation.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof DualValue)) {
            return false;
        }
        DualValue that = (DualValue)other;
        return this.actual == that.actual && this.expected == that.expected && this.fieldLocation.equals(that.fieldLocation);
    }

    public boolean sameValues(DualValue dualValue) {
        return this.actual == dualValue.actual && this.expected == dualValue.expected;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return String.format("DualValue [fieldLocation=%s, actual=%s, expected=%s]", this.fieldLocation, this.actual, this.expected);
    }

    public List<String> getDecomposedPath() {
        return Collections.unmodifiableList(this.fieldLocation.getDecomposedPath());
    }

    public String getConcatenatedPath() {
        return this.fieldLocation.getPathToUseInRules();
    }

    public String getFieldName() {
        return this.fieldLocation.getFieldName();
    }

    public boolean isActualJavaType() {
        return DualValue.isJavaType(this.actual);
    }

    public boolean isExpectedJavaType() {
        return DualValue.isJavaType(this.expected);
    }

    public boolean hasSomeJavaTypeValue() {
        return this.isActualJavaType() || this.isExpectedJavaType();
    }

    private static boolean isJavaType(Object o) {
        if (o == null) {
            return false;
        }
        String className = o.getClass().getName();
        return className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("sun.") || className.startsWith("com.sun.");
    }

    public boolean isExpectedFieldAnArray() {
        return Arrays.isArray(this.expected);
    }

    public boolean isActualFieldAnArray() {
        return Arrays.isArray(this.actual);
    }

    public boolean isActualFieldAnOptional() {
        return this.actual instanceof Optional;
    }

    public boolean isActualFieldAnOptionalInt() {
        return this.actual instanceof OptionalInt;
    }

    public boolean isActualFieldAnOptionalLong() {
        return this.actual instanceof OptionalLong;
    }

    public boolean isActualFieldAnOptionalDouble() {
        return this.actual instanceof OptionalDouble;
    }

    public boolean isActualFieldAnEmptyOptionalOfAnyType() {
        return this.isActualFieldAnEmptyOptional() || this.isActualFieldAnEmptyOptionalInt() || this.isActualFieldAnEmptyOptionalLong() || this.isActualFieldAnEmptyOptionalDouble();
    }

    private boolean isActualFieldAnEmptyOptional() {
        return this.isActualFieldAnOptional() && !((Optional)this.actual).isPresent();
    }

    private boolean isActualFieldAnEmptyOptionalInt() {
        return this.isActualFieldAnOptionalInt() && !((OptionalInt)this.actual).isPresent();
    }

    private boolean isActualFieldAnEmptyOptionalLong() {
        return this.isActualFieldAnOptionalLong() && !((OptionalLong)this.actual).isPresent();
    }

    private boolean isActualFieldAnEmptyOptionalDouble() {
        return this.isActualFieldAnOptionalDouble() && !((OptionalDouble)this.actual).isPresent();
    }

    public boolean isExpectedFieldAnOptional() {
        return this.expected instanceof Optional;
    }

    public boolean isExpectedFieldAnAtomicReference() {
        return this.expected instanceof AtomicReference;
    }

    public boolean isActualFieldAnAtomicReference() {
        return this.actual instanceof AtomicReference;
    }

    public boolean isExpectedFieldAnAtomicReferenceArray() {
        return this.expected instanceof AtomicReferenceArray;
    }

    public boolean isActualFieldAnAtomicReferenceArray() {
        return this.actual instanceof AtomicReferenceArray;
    }

    public boolean isExpectedFieldAnAtomicInteger() {
        return this.expected instanceof AtomicInteger;
    }

    public boolean isActualFieldAnAtomicInteger() {
        return this.actual instanceof AtomicInteger;
    }

    public boolean isExpectedFieldAnAtomicIntegerArray() {
        return this.expected instanceof AtomicIntegerArray;
    }

    public boolean isActualFieldAnAtomicIntegerArray() {
        return this.actual instanceof AtomicIntegerArray;
    }

    public boolean isExpectedFieldAnAtomicLong() {
        return this.expected instanceof AtomicLong;
    }

    public boolean isActualFieldAnAtomicLong() {
        return this.actual instanceof AtomicLong;
    }

    public boolean isExpectedFieldAnAtomicLongArray() {
        return this.expected instanceof AtomicLongArray;
    }

    public boolean isActualFieldAnAtomicLongArray() {
        return this.actual instanceof AtomicLongArray;
    }

    public boolean isExpectedFieldAnAtomicBoolean() {
        return this.expected instanceof AtomicBoolean;
    }

    public boolean isActualFieldAnAtomicBoolean() {
        return this.actual instanceof AtomicBoolean;
    }

    public boolean isActualFieldAMap() {
        return this.actual instanceof Map;
    }

    public boolean isExpectedFieldAMap() {
        return this.expected instanceof Map;
    }

    public boolean isActualFieldASortedMap() {
        return this.actual instanceof SortedMap;
    }

    public boolean isExpectedFieldASortedMap() {
        return this.expected instanceof SortedMap;
    }

    public boolean isActualFieldAnOrderedCollection() {
        return DualValue.isAnOrderedCollection(this.actual);
    }

    public boolean isExpectedFieldAnOrderedCollection() {
        return DualValue.isAnOrderedCollection(this.expected);
    }

    public boolean isActualFieldAnIterable() {
        return DualValue.isAnIterable(this.actual);
    }

    public boolean isExpectedFieldAnIterable() {
        return DualValue.isAnIterable(this.expected);
    }

    private static boolean isAnIterable(Object value) {
        return value instanceof Iterable && !(value instanceof Path) && !DualValue.isAJsonValueNode(value) && !DualValue.isAnObjectNode(value);
    }

    private static boolean isAJsonValueNode(Object value) {
        try {
            Class<?> valueNodeClass = Class.forName("com.fasterxml.jackson.databind.node.ValueNode");
            return valueNodeClass.isInstance(value);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean isAnObjectNode(Object value) {
        try {
            Class<?> objectNodeClass = Class.forName("com.fasterxml.jackson.databind.node.ObjectNode");
            return objectNodeClass.isInstance(value);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean isAnOrderedCollection(Object value) {
        return Stream.of(DEFAULT_ORDERED_COLLECTION_TYPES).anyMatch(type -> type.isInstance(value));
    }

    public boolean isExpectedAnEnum() {
        return this.expected != null && this.expected.getClass().isEnum();
    }

    public boolean isActualAnEnum() {
        return this.actual != null && this.actual.getClass().isEnum();
    }

    public boolean hasNoContainerValues() {
        return !RecursiveHelper.isContainer(this.actual) && !this.isExpectedAContainer();
    }

    public boolean isExpectedAContainer() {
        return RecursiveHelper.isContainer(this.expected);
    }

    public boolean hasNoNullValues() {
        return this.actual != null && this.expected != null;
    }

    public boolean hasPotentialCyclingValues() {
        return DualValue.isPotentialCyclingValue(this.actual) && DualValue.isPotentialCyclingValue(this.expected);
    }

    private static boolean isPotentialCyclingValue(Object object) {
        if (object == null) {
            return false;
        }
        String canonicalName = object.getClass().getCanonicalName();
        if (canonicalName == null) {
            return true;
        }
        if (object.getClass().isEnum()) {
            return false;
        }
        return !canonicalName.startsWith("java.lang");
    }
}

