/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.remote;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import java.util.Arrays;
import java.util.List;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.executor.RemotePromise;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.remote.AsyncRemoteProxy;
import org.redisson.remote.BaseRemoteService;
import org.redisson.rx.CommandRxExecutor;
import org.redisson.rx.CommandRxService;

public class RxRemoteProxy
extends AsyncRemoteProxy {
    public RxRemoteProxy(CommandAsyncExecutor commandExecutor, String name, String responseQueueName, Codec codec, String executorId, String cancelRequestMapName, BaseRemoteService remoteService) {
        super(RxRemoteProxy.convert(commandExecutor), name, responseQueueName, codec, executorId, cancelRequestMapName, remoteService);
    }

    private static CommandAsyncExecutor convert(CommandAsyncExecutor commandExecutor) {
        if (commandExecutor instanceof CommandRxExecutor) {
            return commandExecutor;
        }
        return new CommandRxService(commandExecutor.getConnectionManager(), commandExecutor.getObjectBuilder());
    }

    @Override
    protected List<Class<?>> permittedClasses() {
        return Arrays.asList(Completable.class, Single.class, Maybe.class);
    }

    @Override
    protected Object convertResult(RemotePromise<Object> result, Class<?> returnType) {
        Flowable flowable = ((CommandRxExecutor)this.commandExecutor).flowable(() -> new CompletableFutureWrapper(result));
        if (returnType == Completable.class) {
            return flowable.ignoreElements();
        }
        if (returnType == Single.class) {
            return flowable.singleOrError();
        }
        return flowable.singleElement();
    }
}

