/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.mcp.source.protocol.impl;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import lombok.Generated;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.config.connector.mcp.SourceConnectorConfig;
import org.apache.eventmesh.connector.mcp.source.data.McpRequest;
import org.apache.eventmesh.connector.mcp.source.data.McpResponse;
import org.apache.eventmesh.connector.mcp.source.protocol.Protocol;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpStandardProtocol
implements Protocol {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(McpStandardProtocol.class);
    public static final String PROTOCOL_NAME = "MCP";
    private static final String EXTENSION_PROTOCOL = "protocol";
    private static final String EXTENSION_SESSION_ID = "sessionid";
    private static final String EXTENSION_TOOL_NAME = "toolname";
    private static final String EXTENSION_METHOD = "method";
    private static final String EXTENSION_REQUEST_ID = "requestid";
    private static final String EXTENSION_SUCCESS = "success";
    private static final String EXTENSION_ERROR_MESSAGE = "errormessage";
    private static final String EXTENSION_ROUTING_CONTEXT = "routingcontext";
    private static final String EXTENSION_IS_BASE64 = "isbase64";
    private static final String METADATA_EXTENSION_KEY = "extension";
    private SourceConnectorConfig sourceConnectorConfig;

    @Override
    public void initialize(SourceConnectorConfig sourceConnectorConfig) {
        this.sourceConnectorConfig = sourceConnectorConfig;
        log.info("Initialized MCP Standard Protocol");
    }

    @Override
    public void setHandler(Route route, BlockingQueue<Object> queue) {
        route.method(HttpMethod.POST).handler((Handler)BodyHandler.create()).handler(ctx -> {
            try {
                McpRequest mcpRequest;
                JsonObject requestJson;
                String bodyString = ctx.body().asString(Constants.DEFAULT_CHARSET.toString());
                try {
                    requestJson = new JsonObject(bodyString);
                }
                catch (Exception e) {
                    log.error("Failed to parse request as JSON: {}", (Object)bodyString, (Object)e);
                    ctx.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).putHeader("Content-Type", "application/json").end(McpResponse.error("Invalid JSON format").toJsonStr());
                    return;
                }
                String method = requestJson.getString("type", "");
                String toolName = requestJson.getString("tool", "");
                JsonObject params = requestJson.getJsonObject("arguments");
                String sessionId = ctx.request().getHeader("Mcp-Session-Id");
                if (sessionId == null || sessionId.isEmpty()) {
                    sessionId = this.generateSessionId();
                }
                if (!queue.offer(mcpRequest = this.createMcpRequest(method, params, sessionId, toolName, (RoutingContext)ctx))) {
                    log.error("Failed to queue MCP request: queue is full");
                    ctx.response().setStatusCode(HttpResponseStatus.SERVICE_UNAVAILABLE.code()).putHeader("Content-Type", "application/json").end(McpResponse.error("Service temporarily unavailable").toJsonStr());
                    return;
                }
                if (!this.sourceConnectorConfig.isDataConsistencyEnabled()) {
                    ctx.response().setStatusCode(HttpResponseStatus.OK.code()).putHeader("Content-Type", "application/json").end(McpResponse.success().toJsonStr());
                }
            }
            catch (Exception e) {
                log.error("Error handling MCP request", (Throwable)e);
                ctx.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).putHeader("Content-Type", "application/json").end(McpResponse.error("Internal server error: " + e.getMessage()).toJsonStr());
            }
        }).failureHandler(ctx -> {
            log.error("Failed to handle MCP request", ctx.failure());
            ctx.response().setStatusCode(ctx.statusCode() > 0 ? ctx.statusCode() : 500).putHeader("Content-Type", "application/json").end(McpResponse.error(ctx.failure().getMessage()).toJsonStr());
        });
    }

    private McpRequest createMcpRequest(String method, JsonObject params, String sessionId, String tool, RoutingContext ctx) {
        McpRequest.McpRequestBuilder builder = McpRequest.builder().protocolName(PROTOCOL_NAME).sessionId(sessionId).method(method).toolName(tool).timestamp(System.currentTimeMillis()).routingContext(ctx);
        if ("mcp.tools.call".equals(method) && params != null) {
            String toolName = params.getString("name");
            JsonObject arguments = params.getJsonObject("arguments", new JsonObject());
            builder.toolName(toolName).arguments(arguments).success(false);
        } else if ("initialize".equals(method)) {
            builder.success(true);
        } else {
            builder.success(true);
        }
        return builder.build();
    }

    @Override
    public ConnectRecord convertToConnectRecord(Object message) {
        if (message == null) {
            throw new IllegalArgumentException("Message cannot be null");
        }
        if (!(message instanceof McpRequest)) {
            throw new IllegalArgumentException(String.format("Expected McpRequest but got %s", message.getClass().getName()));
        }
        McpRequest request = (McpRequest)message;
        long timestamp = request.getTimestamp() > 0L ? request.getTimestamp() : System.currentTimeMillis();
        Object data = this.extractData(request);
        ConnectRecord connectRecord = new ConnectRecord(null, null, Long.valueOf(timestamp), data);
        connectRecord.addExtension(EXTENSION_PROTOCOL, (Object)PROTOCOL_NAME);
        if (request.getSessionId() != null) {
            connectRecord.addExtension(EXTENSION_SESSION_ID, (Object)request.getSessionId());
        }
        if (request.getMethod() != null) {
            connectRecord.addExtension(EXTENSION_METHOD, (Object)request.getMethod());
        }
        if (request.getToolName() != null) {
            connectRecord.addExtension(EXTENSION_TOOL_NAME, (Object)request.getToolName());
        }
        connectRecord.addExtension(EXTENSION_SUCCESS, (Object)String.valueOf(request.isSuccess()));
        if (!request.isSuccess() && request.getErrorMessage() != null) {
            connectRecord.addExtension(EXTENSION_ERROR_MESSAGE, (Object)request.getErrorMessage());
        }
        this.handleBase64Decoding(connectRecord);
        if (request.getRoutingContext() != null) {
            connectRecord.addExtension(EXTENSION_ROUTING_CONTEXT, (Object)request.getRoutingContext());
        }
        return connectRecord;
    }

    private Object extractData(McpRequest request) {
        if (request.isSuccess() && request.getResult() != null) {
            return request.getResult().encode();
        }
        if (request.getArguments() != null) {
            return request.getArguments().encode();
        }
        return String.format("{\"tool\":\"%s\",\"timestamp\":%d}", request.getToolName(), request.getTimestamp());
    }

    private void handleBase64Decoding(ConnectRecord connectRecord) {
        Object isBase64Obj = connectRecord.getExtensionObj(EXTENSION_IS_BASE64);
        if (isBase64Obj == null) {
            return;
        }
        boolean isBase64 = isBase64Obj instanceof Boolean ? (Boolean)isBase64Obj : Boolean.parseBoolean(String.valueOf(isBase64Obj));
        if (isBase64 && connectRecord.getData() != null) {
            try {
                String dataStr = connectRecord.getData().toString();
                byte[] decodedData = Base64.getDecoder().decode(dataStr);
                connectRecord.setData((Object)decodedData);
                log.debug("Decoded Base64 data: {} bytes", (Object)decodedData.length);
            }
            catch (IllegalArgumentException e) {
                log.error("Failed to decode Base64 data: {}", (Object)e.getMessage());
            }
        }
    }

    private String generateSessionId() {
        return "mcp-session-" + UUID.randomUUID();
    }
}

