/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.statistics;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.msq.statistics.KeyCollectorSnapshot;
import org.apache.druid.msq.statistics.PartialKeyStatisticsInformation;

public class ClusterByStatisticsSnapshot {
    private final Map<Long, Bucket> buckets;
    private final Set<Integer> hasMultipleValues;

    @JsonCreator
    public ClusterByStatisticsSnapshot(@JsonProperty(value="buckets") Map<Long, Bucket> buckets, @JsonProperty(value="hasMultipleValues") @Nullable Set<Integer> hasMultipleValues) {
        this.buckets = (Map)Preconditions.checkNotNull(buckets, (Object)"buckets");
        this.hasMultipleValues = hasMultipleValues != null ? hasMultipleValues : Collections.emptySet();
    }

    public static ClusterByStatisticsSnapshot empty() {
        return new ClusterByStatisticsSnapshot(Collections.emptyMap(), null);
    }

    @JsonProperty(value="buckets")
    public Map<Long, Bucket> getBuckets() {
        return this.buckets;
    }

    public ClusterByStatisticsSnapshot getSnapshotForTimeChunk(long timeChunk) {
        Bucket bucket = this.buckets.get(timeChunk);
        if (bucket == null) {
            throw new ISE("ClusterByStatistics not present for requested timechunk %s", new Object[]{timeChunk});
        }
        return new ClusterByStatisticsSnapshot((Map<Long, Bucket>)ImmutableMap.of((Object)timeChunk, (Object)bucket), null);
    }

    @JsonProperty(value="hasMultipleValues")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Set<Integer> getHasMultipleValues() {
        return this.hasMultipleValues;
    }

    public PartialKeyStatisticsInformation partialKeyStatistics() {
        double bytesRetained = 0.0;
        for (Bucket bucket : this.buckets.values()) {
            bytesRetained += bucket.bytesRetained;
        }
        return new PartialKeyStatisticsInformation(this.buckets.keySet(), !this.getHasMultipleValues().isEmpty(), bytesRetained);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterByStatisticsSnapshot that = (ClusterByStatisticsSnapshot)o;
        return Objects.equals(this.buckets, that.buckets) && Objects.equals(this.hasMultipleValues, that.hasMultipleValues);
    }

    public int hashCode() {
        return Objects.hash(this.buckets, this.hasMultipleValues);
    }

    public static class Bucket {
        private final RowKey bucketKey;
        private final double bytesRetained;
        private final KeyCollectorSnapshot keyCollectorSnapshot;

        @JsonCreator
        public Bucket(@JsonProperty(value="bucketKey") RowKey bucketKey, @JsonProperty(value="data") KeyCollectorSnapshot keyCollectorSnapshot, @JsonProperty(value="bytesRetained") double bytesRetained) {
            this.bucketKey = (RowKey)Preconditions.checkNotNull((Object)bucketKey, (Object)"bucketKey");
            this.keyCollectorSnapshot = (KeyCollectorSnapshot)Preconditions.checkNotNull((Object)keyCollectorSnapshot, (Object)"data");
            this.bytesRetained = bytesRetained;
        }

        @JsonProperty
        public RowKey getBucketKey() {
            return this.bucketKey;
        }

        @JsonIgnore
        public double getBytesRetained() {
            return this.bytesRetained;
        }

        @JsonProperty(value="data")
        public KeyCollectorSnapshot getKeyCollectorSnapshot() {
            return this.keyCollectorSnapshot;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bucket bucket = (Bucket)o;
            return Objects.equals(this.bucketKey, bucket.bucketKey) && Objects.equals(this.keyCollectorSnapshot, bucket.keyCollectorSnapshot);
        }

        public int hashCode() {
            return Objects.hash(this.bucketKey, this.keyCollectorSnapshot);
        }
    }
}

