/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.controller;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.indexer.report.TaskReport;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.msq.dart.controller.ControllerHolder;
import org.apache.druid.msq.dart.controller.QueryInfoAndReport;
import org.apache.druid.msq.dart.controller.http.DartQueryInfo;
import org.apache.druid.msq.dart.guice.DartControllerConfig;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;

@ManageLifecycle
public class DartControllerRegistry {
    private static final long MIN_CLEANUP_CHECK_MILLIS = 10000L;
    private final DartControllerConfig config;
    private final ConcurrentHashMap<String, ControllerHolder> controllerMap = new ConcurrentHashMap();
    @GuardedBy(value="completeReports")
    private final LinkedHashMap<String, QueryInfoAndReport> completeReports = new LinkedHashMap();
    private final ConcurrentHashMap<String, String> sqlQueryIdToDartQueryId = new ConcurrentHashMap();
    private ScheduledExecutorService cleanupExec;

    @Inject
    public DartControllerRegistry(DartControllerConfig config) {
        this.config = config;
    }

    @LifecycleStart
    public void start() {
        if (!this.config.getMaxRetainedReportDuration().equals((Object)Period.ZERO)) {
            String threadNameFormat = StringUtils.format((String)"%s-ReportCleanupExec-%%s", (Object[])new Object[]{this.getClass().getSimpleName()});
            long cleanupPeriodMs = Math.max(10000L, this.config.getMaxRetainedReportDuration().toStandardDuration().getMillis() / 10L);
            this.cleanupExec = Execs.scheduledSingleThreaded((String)threadNameFormat);
            this.cleanupExec.scheduleAtFixedRate(this::cleanupExpiredReports, cleanupPeriodMs, cleanupPeriodMs, TimeUnit.MILLISECONDS);
        }
    }

    @LifecycleStop
    public void stop() {
        if (this.cleanupExec != null) {
            this.cleanupExec.shutdown();
        }
    }

    public void register(ControllerHolder holder) {
        String dartQueryId = holder.getController().queryId();
        if (this.controllerMap.putIfAbsent(dartQueryId, holder) != null) {
            throw DruidException.defensive((String)"Controller[%s] already registered", (Object[])new Object[]{dartQueryId});
        }
        this.sqlQueryIdToDartQueryId.putIfAbsent(holder.getSqlQueryId(), dartQueryId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(ControllerHolder holder, @Nullable TaskReport.ReportMap completeReport) {
        String dartQueryId = holder.getController().queryId();
        boolean didRemove = this.controllerMap.remove(dartQueryId, holder);
        if (didRemove && completeReport != null && this.config.getMaxRetainedReportCount() > 0) {
            LinkedHashMap<String, QueryInfoAndReport> linkedHashMap = this.completeReports;
            synchronized (linkedHashMap) {
                int reportsToRemove;
                if (reportsToRemove > 0) {
                    Iterator<Map.Entry<String, QueryInfoAndReport>> it = this.completeReports.entrySet().iterator();
                    for (reportsToRemove = this.completeReports.size() - this.config.getMaxRetainedReportCount() + 1; it.hasNext() && reportsToRemove > 0; --reportsToRemove) {
                        QueryInfoAndReport evictedReport = it.next().getValue();
                        it.remove();
                        this.sqlQueryIdToDartQueryId.remove(evictedReport.getQueryInfo().getSqlQueryId(), evictedReport.getQueryInfo().getDartQueryId());
                    }
                }
                this.completeReports.put(dartQueryId, new QueryInfoAndReport(DartQueryInfo.fromControllerHolder(holder), completeReport, DateTimes.nowUtc()));
            }
        } else if (didRemove) {
            this.sqlQueryIdToDartQueryId.remove(holder.getSqlQueryId(), dartQueryId);
        }
    }

    @Nullable
    public ControllerHolder getController(String queryId) {
        return this.controllerMap.get(queryId);
    }

    public Collection<ControllerHolder> getAllControllers() {
        return this.controllerMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public QueryInfoAndReport getQueryInfoAndReport(String queryId) {
        ControllerHolder runningController = this.getController(queryId);
        if (runningController != null) {
            TaskReport.ReportMap liveReportMap = runningController.getController().liveReports();
            if (liveReportMap != null) {
                return new QueryInfoAndReport(DartQueryInfo.fromControllerHolder(runningController), liveReportMap, DateTimes.nowUtc());
            }
            return null;
        }
        LinkedHashMap<String, QueryInfoAndReport> linkedHashMap = this.completeReports;
        synchronized (linkedHashMap) {
            return this.completeReports.get(queryId);
        }
    }

    @Nullable
    public QueryInfoAndReport getQueryInfoAndReportBySqlQueryId(String sqlQueryId) {
        String dartQueryId = this.sqlQueryIdToDartQueryId.get(sqlQueryId);
        if (dartQueryId == null) {
            return null;
        }
        return this.getQueryInfoAndReport(dartQueryId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupExpiredReports() {
        long thresholdTimestamp = DateTimes.nowUtc().minus((ReadablePeriod)this.config.getMaxRetainedReportDuration()).getMillis();
        LinkedHashMap<String, QueryInfoAndReport> linkedHashMap = this.completeReports;
        synchronized (linkedHashMap) {
            QueryInfoAndReport report;
            Iterator<Map.Entry<String, QueryInfoAndReport>> it = this.completeReports.entrySet().iterator();
            while (it.hasNext() && (report = it.next().getValue()).getTimestamp().getMillis() < thresholdTimestamp) {
                it.remove();
                this.sqlQueryIdToDartQueryId.remove(report.getQueryInfo().getSqlQueryId(), report.getQueryInfo().getDartQueryId());
            }
        }
    }
}

