/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord;

import com.google.common.base.Supplier;
import java.util.List;
import java.util.Map;
import org.apache.druid.k8s.overlord.KubernetesTaskRunnerConfig;
import org.apache.druid.k8s.overlord.KubernetesTaskRunnerStaticConfig;
import org.apache.druid.k8s.overlord.execution.KubernetesTaskRunnerDynamicConfig;
import org.apache.druid.k8s.overlord.execution.PodTemplateSelectStrategy;
import org.joda.time.Period;

public class KubernetesTaskRunnerEffectiveConfig
implements KubernetesTaskRunnerConfig {
    private final KubernetesTaskRunnerStaticConfig staticConfig;
    private final Supplier<KubernetesTaskRunnerDynamicConfig> dynamicConfigSupplier;

    public KubernetesTaskRunnerEffectiveConfig(KubernetesTaskRunnerStaticConfig staticConfig, Supplier<KubernetesTaskRunnerDynamicConfig> dynamicConfigSupplier) {
        this.staticConfig = staticConfig;
        this.dynamicConfigSupplier = dynamicConfigSupplier;
    }

    @Override
    public String getNamespace() {
        return this.staticConfig.getNamespace();
    }

    @Override
    public String getOverlordNamespace() {
        return this.staticConfig.getOverlordNamespace();
    }

    @Override
    public String getK8sTaskPodNamePrefix() {
        return this.staticConfig.getK8sTaskPodNamePrefix();
    }

    @Override
    public boolean isDebugJobs() {
        return this.staticConfig.isDebugJobs();
    }

    @Override
    public boolean isSidecarSupport() {
        return this.staticConfig.isSidecarSupport();
    }

    @Override
    public String getPrimaryContainerName() {
        return this.staticConfig.getPrimaryContainerName();
    }

    @Override
    public String getKubexitImage() {
        return this.staticConfig.getKubexitImage();
    }

    @Override
    public Long getGraceTerminationPeriodSeconds() {
        return this.staticConfig.getGraceTerminationPeriodSeconds();
    }

    @Override
    public boolean isDisableClientProxy() {
        return this.staticConfig.isDisableClientProxy();
    }

    @Override
    public Period getTaskTimeout() {
        return this.staticConfig.getTaskTimeout();
    }

    @Override
    public Period getTaskJoinTimeout() {
        return this.staticConfig.getTaskJoinTimeout();
    }

    @Override
    public Period getTaskCleanupDelay() {
        return this.staticConfig.getTaskCleanupDelay();
    }

    @Override
    public Period getTaskCleanupInterval() {
        return this.staticConfig.getTaskCleanupInterval();
    }

    @Override
    public Period getTaskLaunchTimeout() {
        return this.staticConfig.getTaskLaunchTimeout();
    }

    @Override
    public Period getLogSaveTimeout() {
        return this.staticConfig.getLogSaveTimeout();
    }

    @Override
    public List<String> getPeonMonitors() {
        return this.staticConfig.getPeonMonitors();
    }

    @Override
    public List<String> getJavaOptsArray() {
        return this.staticConfig.getJavaOptsArray();
    }

    @Override
    public int getCpuCoreInMicro() {
        return this.staticConfig.getCpuCoreInMicro();
    }

    @Override
    public Map<String, String> getLabels() {
        return this.staticConfig.getLabels();
    }

    @Override
    public Map<String, String> getAnnotations() {
        return this.staticConfig.getAnnotations();
    }

    @Override
    public Integer getCapacity() {
        if (this.dynamicConfigSupplier == null || this.dynamicConfigSupplier.get() == null || ((KubernetesTaskRunnerDynamicConfig)this.dynamicConfigSupplier.get()).getCapacity() == null) {
            return this.staticConfig.getCapacity();
        }
        return ((KubernetesTaskRunnerDynamicConfig)this.dynamicConfigSupplier.get()).getCapacity();
    }

    @Override
    public boolean isUseK8sSharedInformers() {
        return this.staticConfig.isUseK8sSharedInformers();
    }

    @Override
    public Period getK8sSharedInformerResyncPeriod() {
        return this.staticConfig.getK8sSharedInformerResyncPeriod();
    }

    public PodTemplateSelectStrategy getPodTemplateSelectStrategy() {
        if (this.dynamicConfigSupplier == null || this.dynamicConfigSupplier.get() == null || ((KubernetesTaskRunnerDynamicConfig)this.dynamicConfigSupplier.get()).getPodTemplateSelectStrategy() == null) {
            return KubernetesTaskRunnerDynamicConfig.DEFAULT_STRATEGY;
        }
        return ((KubernetesTaskRunnerDynamicConfig)this.dynamicConfigSupplier.get()).getPodTemplateSelectStrategy();
    }
}

