/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.druid.query.JoinAlgorithm;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.planner.ColumnMapping;
import org.apache.druid.sql.calcite.planner.ColumnMappings;
import org.apache.druid.sql.calcite.planner.DruidHint;
import org.apache.druid.sql.calcite.planner.PlannerContext;

public class QueryUtils {
    private QueryUtils() {
    }

    public static ColumnMappings buildColumnMappings(List<Map.Entry<Integer, String>> fieldMapping, RowSignature rowSignature) {
        ArrayList<ColumnMapping> columnMappings = new ArrayList<ColumnMapping>();
        for (Map.Entry<Integer, String> entry : fieldMapping) {
            String queryColumn = rowSignature.getColumnName(entry.getKey().intValue());
            String outputColumn = entry.getValue();
            columnMappings.add(new ColumnMapping(queryColumn, outputColumn));
        }
        return new ColumnMappings(columnMappings);
    }

    public static JoinAlgorithm getJoinAlgorithm(Join join, PlannerContext plannerContext) {
        RelHint closestHint = null;
        for (RelHint hint : join.getHints()) {
            if (closestHint != null && hint.inheritPath.size() >= closestHint.inheritPath.size() || DruidHint.DruidJoinHint.fromString(hint.hintName) == null) continue;
            closestHint = hint;
        }
        if (closestHint != null) {
            return DruidHint.DruidJoinHint.fromString(closestHint.hintName).asJoinAlgorithm();
        }
        return plannerContext.getJoinAlgorithm();
    }
}

