/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.calcite.avatica.AvaticaSeverity;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.avatica.remote.AuthenticationType;
import org.apache.calcite.avatica.remote.Service;
import org.apache.calcite.avatica.server.AvaticaServerConfiguration;
import org.apache.calcite.avatica.server.MetricsAwareAvaticaHandler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public abstract class AbstractAvaticaHandler
extends AbstractHandler
implements MetricsAwareAvaticaHandler {
    private static final Service.ErrorResponse UNAUTHORIZED_ERROR = new Service.ErrorResponse(Collections.emptyList(), "User is not authenticated", 2, "00002", AvaticaSeverity.ERROR, null);

    public boolean isUserPermitted(AvaticaServerConfiguration serverConfig, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String remoteUser;
        if (null != serverConfig && AuthenticationType.SPNEGO == serverConfig.getAuthenticationType() && null == (remoteUser = request.getRemoteUser())) {
            ServletInputStream input = request.getInputStream();
            if (request.getContentLengthLong() < 0L) {
                AvaticaUtils.skipFully((InputStream)input);
            }
            response.setStatus(401);
            response.getOutputStream().write(UNAUTHORIZED_ERROR.serialize().toByteArray());
            baseRequest.setHandled(true);
            return false;
        }
        return true;
    }
}

