/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.jdbc;

import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.distributed.jdbc.BucketTableSettings;
import io.github.bucket4j.distributed.jdbc.SQLProxyConfiguration;
import io.github.bucket4j.distributed.proxy.ClientSideConfig;
import javax.sql.DataSource;

public final class SQLProxyConfigurationBuilder {
    private ClientSideConfig clientSideConfig;
    private BucketTableSettings tableSettings;

    private SQLProxyConfigurationBuilder() {
    }

    public static SQLProxyConfigurationBuilder builder() {
        return new SQLProxyConfigurationBuilder();
    }

    public SQLProxyConfigurationBuilder withClientSideConfig(ClientSideConfig clientSideConfig) {
        this.clientSideConfig = clientSideConfig;
        return this;
    }

    public SQLProxyConfigurationBuilder withTableSettings(BucketTableSettings tableSettings) {
        this.tableSettings = tableSettings;
        return this;
    }

    public SQLProxyConfiguration build(DataSource dataSource) {
        if (dataSource == null) {
            throw new BucketExceptions.BucketExecutionException("DataSource cannot be null");
        }
        if (this.tableSettings == null) {
            this.tableSettings = BucketTableSettings.getDefault();
        }
        if (this.clientSideConfig == null) {
            this.clientSideConfig = ClientSideConfig.getDefault();
        }
        return new SQLProxyConfiguration(dataSource, this.clientSideConfig, this.tableSettings);
    }
}

