/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import org.apache.druid.common.config.Configs;
import org.apache.druid.error.InvalidInput;
import org.joda.time.Duration;

public class HttpLoadQueuePeonConfig {
    private static final Duration DEFAULT_LOAD_TIMEOUT = Duration.standardMinutes((long)15L);
    @JsonProperty
    private final Duration hostTimeout;
    @JsonProperty
    private final Duration repeatDelay;
    @JsonProperty
    @Nullable
    private final Integer batchSize;

    @JsonCreator
    public HttpLoadQueuePeonConfig(@JsonProperty(value="hostTimeout") Duration hostTimeout, @JsonProperty(value="repeatDelay") Duration repeatDelay, @JsonProperty(value="batchSize") @Nullable Integer batchSize) {
        this.hostTimeout = (Duration)Configs.valueOrDefault((Object)hostTimeout, (Object)Duration.standardMinutes((long)5L));
        this.repeatDelay = (Duration)Configs.valueOrDefault((Object)repeatDelay, (Object)Duration.standardMinutes((long)1L));
        this.batchSize = batchSize;
        InvalidInput.conditionalException((batchSize == null || batchSize >= 1 ? 1 : 0) != 0, (String)"'druid.coordinator.loadqueuepeon.http.batchSize'[%s] must be greater than 0", (Object[])new Object[]{batchSize});
    }

    @Nullable
    public Integer getBatchSize() {
        return this.batchSize;
    }

    public Duration getHostTimeout() {
        return this.hostTimeout;
    }

    public Duration getRepeatDelay() {
        return this.repeatDelay;
    }

    public Duration getLoadTimeout() {
        return DEFAULT_LOAD_TIMEOUT;
    }
}

