/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.data.input.Committer;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.Stopwatch;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.segment.BaseProgressIndicator;
import org.apache.druid.segment.DataSegmentWithMetadata;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.ProgressIndicator;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.SchemaPayload;
import org.apache.druid.segment.SchemaPayloadPlus;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentSchemaMapping;
import org.apache.druid.segment.incremental.IncrementalIndexAddResult;
import org.apache.druid.segment.incremental.ParseExceptionHandler;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.metadata.FingerprintGenerator;
import org.apache.druid.segment.realtime.FireHydrant;
import org.apache.druid.segment.realtime.SegmentGenerationMetrics;
import org.apache.druid.segment.realtime.appenderator.Appenderator;
import org.apache.druid.segment.realtime.appenderator.AppenderatorConfig;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.segment.realtime.appenderator.SegmentNotWritableException;
import org.apache.druid.segment.realtime.appenderator.SegmentsAndCommitMetadata;
import org.apache.druid.segment.realtime.appenderator.TaskSegmentSchemaUtil;
import org.apache.druid.segment.realtime.sink.Sink;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.utils.JvmUtils;
import org.joda.time.Interval;

public class BatchAppenderator
implements Appenderator {
    public static final int ROUGH_OVERHEAD_PER_SINK = 5000;
    public static final int ROUGH_OVERHEAD_PER_HYDRANT = 1000;
    private static final EmittingLogger log = new EmittingLogger(BatchAppenderator.class);
    private static final String IDENTIFIER_FILE_NAME = "identifier.json";
    private final String myId;
    private final DataSchema schema;
    private final AppenderatorConfig tuningConfig;
    private final SegmentGenerationMetrics metrics;
    private final DataSegmentPusher dataSegmentPusher;
    private final ObjectMapper objectMapper;
    private final IndexIO indexIO;
    private final IndexMerger indexMerger;
    private final long maxBytesTuningConfig;
    private final boolean skipBytesInMemoryOverheadCheck;
    private volatile ListeningExecutorService persistExecutor = null;
    private volatile ListeningExecutorService pushExecutor = null;
    private final int maxPendingPersists;
    private static final int PERSIST_WARN_DELAY = 1000;
    private volatile Throwable persistError;
    private final Map<SegmentIdWithShardSpec, Sink> sinks = new HashMap<SegmentIdWithShardSpec, Sink>();
    private final ConcurrentHashMap<SegmentIdWithShardSpec, SinkMetadata> sinksMetadata = new ConcurrentHashMap();
    private int rowsCurrentlyInMemory = 0;
    private int totalRows = 0;
    private long bytesCurrentlyInMemory = 0L;
    private final RowIngestionMeters rowIngestionMeters;
    private final ParseExceptionHandler parseExceptionHandler;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private volatile FileLock basePersistDirLock = null;
    private volatile FileChannel basePersistDirLockChannel = null;
    private final CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig;
    private final FingerprintGenerator fingerprintGenerator;

    BatchAppenderator(String id, DataSchema schema, AppenderatorConfig tuningConfig, SegmentGenerationMetrics metrics, DataSegmentPusher dataSegmentPusher, ObjectMapper objectMapper, IndexIO indexIO, IndexMerger indexMerger, RowIngestionMeters rowIngestionMeters, ParseExceptionHandler parseExceptionHandler, CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig) {
        this.myId = id;
        this.schema = (DataSchema)Preconditions.checkNotNull((Object)schema, (Object)"schema");
        this.tuningConfig = (AppenderatorConfig)Preconditions.checkNotNull((Object)tuningConfig, (Object)"tuningConfig");
        this.metrics = (SegmentGenerationMetrics)Preconditions.checkNotNull((Object)metrics, (Object)"metrics");
        this.dataSegmentPusher = (DataSegmentPusher)Preconditions.checkNotNull((Object)dataSegmentPusher, (Object)"dataSegmentPusher");
        this.objectMapper = (ObjectMapper)Preconditions.checkNotNull((Object)objectMapper, (Object)"objectMapper");
        this.indexIO = (IndexIO)Preconditions.checkNotNull((Object)indexIO, (Object)"indexIO");
        this.indexMerger = (IndexMerger)Preconditions.checkNotNull((Object)indexMerger, (Object)"indexMerger");
        this.rowIngestionMeters = (RowIngestionMeters)Preconditions.checkNotNull((Object)rowIngestionMeters, (Object)"rowIngestionMeters");
        this.parseExceptionHandler = (ParseExceptionHandler)Preconditions.checkNotNull((Object)parseExceptionHandler, (Object)"parseExceptionHandler");
        this.maxBytesTuningConfig = tuningConfig.getMaxBytesInMemoryOrDefault();
        this.skipBytesInMemoryOverheadCheck = tuningConfig.isSkipBytesInMemoryOverheadCheck();
        this.maxPendingPersists = tuningConfig.getMaxPendingPersists();
        this.centralizedDatasourceSchemaConfig = centralizedDatasourceSchemaConfig;
        this.fingerprintGenerator = new FingerprintGenerator(objectMapper);
    }

    @Override
    public String getId() {
        return this.myId;
    }

    @Override
    public String getDataSource() {
        return this.schema.getDataSource();
    }

    @Override
    public Object startJob() {
        this.lockBasePersistDirectory();
        this.initializeExecutors();
        return null;
    }

    private void throwPersistErrorIfExists() {
        if (this.persistError != null) {
            throw new RE(this.persistError, "Error while persisting", new Object[0]);
        }
    }

    private void initializeExecutors() {
        log.debug("There will be up to[%d] pending persists", new Object[]{this.maxPendingPersists});
        if (this.persistExecutor == null) {
            log.info("Number of persist threads [%d]", new Object[]{this.tuningConfig.getNumPersistThreads()});
            this.persistExecutor = MoreExecutors.listeningDecorator((ExecutorService)Execs.newBlockingThreaded((String)("[" + StringUtils.encodeForFormat((String)this.myId) + "]-batch-appenderator-persist"), (int)this.tuningConfig.getNumPersistThreads(), (int)this.maxPendingPersists));
        }
        if (this.pushExecutor == null) {
            this.pushExecutor = MoreExecutors.listeningDecorator((ExecutorService)Execs.newBlockingSingleThreaded((String)("[" + StringUtils.encodeForFormat((String)this.myId) + "]-batch-appenderator-push"), (int)1));
        }
    }

    private void shutdownExecutors() {
        if (this.persistExecutor != null) {
            this.persistExecutor.shutdownNow();
        }
        if (this.pushExecutor != null) {
            this.pushExecutor.shutdownNow();
        }
    }

    @Override
    public Appenderator.AppenderatorAddResult add(SegmentIdWithShardSpec identifier, InputRow row, @Nullable Supplier<Committer> committerSupplier, boolean allowIncrementalPersists) throws SegmentNotWritableException {
        this.throwPersistErrorIfExists();
        Preconditions.checkArgument((committerSupplier == null ? 1 : 0) != 0, (Object)"Batch appenderator does not need a committer!");
        Preconditions.checkArgument((boolean)allowIncrementalPersists, (Object)"Batch appenderator should always allow incremental persists!");
        if (!identifier.getDataSource().equals(this.schema.getDataSource())) {
            throw new IAE("Expected dataSource[%s] but was asked to insert row for dataSource[%s]?!", new Object[]{this.schema.getDataSource(), identifier.getDataSource()});
        }
        Sink sink = this.getOrCreateSink(identifier);
        this.metrics.reportMessageMaxTimestamp(row.getTimestampFromEpoch());
        int sinkRowsInMemoryBeforeAdd = sink.getNumRowsInMemory();
        long bytesInMemoryBeforeAdd = sink.getBytesInMemory();
        IncrementalIndexAddResult addResult = sink.add(row);
        int sinkRowsInMemoryAfterAdd = addResult.getRowCount();
        long bytesInMemoryAfterAdd = addResult.getBytesInMemory();
        if (sinkRowsInMemoryAfterAdd < 0) {
            throw new SegmentNotWritableException("Attempt to add row to swapped-out sink for segment[%s].", identifier);
        }
        if (addResult.isRowAdded()) {
            this.rowIngestionMeters.incrementProcessed();
        } else if (addResult.hasParseException()) {
            this.parseExceptionHandler.handle(addResult.getParseException());
        }
        int numAddedRows = sinkRowsInMemoryAfterAdd - sinkRowsInMemoryBeforeAdd;
        this.rowsCurrentlyInMemory += numAddedRows;
        this.bytesCurrentlyInMemory += bytesInMemoryAfterAdd - bytesInMemoryBeforeAdd;
        this.totalRows += numAddedRows;
        this.sinksMetadata.computeIfAbsent(identifier, unused -> new SinkMetadata()).addRows(numAddedRows);
        boolean persist = false;
        ArrayList<String> persistReasons = new ArrayList<String>();
        if (!sink.canAppendRow()) {
            persist = true;
            persistReasons.add("No more rows can be appended to sink");
        }
        if (this.rowsCurrentlyInMemory >= this.tuningConfig.getMaxRowsInMemory()) {
            persist = true;
            persistReasons.add(StringUtils.format((String)"rowsCurrentlyInMemory[%d] is greater than maxRowsInMemory[%d]", (Object[])new Object[]{this.rowsCurrentlyInMemory, this.tuningConfig.getMaxRowsInMemory()}));
        }
        if (this.bytesCurrentlyInMemory >= this.maxBytesTuningConfig) {
            persist = true;
            persistReasons.add(StringUtils.format((String)"bytesCurrentlyInMemory[%d] is greater than maxBytesInMemory[%d]", (Object[])new Object[]{this.bytesCurrentlyInMemory, this.maxBytesTuningConfig}));
        }
        if (persist) {
            log.info("Incremental persist to disk because %s.", new Object[]{String.join((CharSequence)",", persistReasons)});
            long bytesToBePersisted = 0L;
            for (Map.Entry<SegmentIdWithShardSpec, Sink> entry : this.sinks.entrySet()) {
                Sink sinkEntry = entry.getValue();
                if (sinkEntry == null) continue;
                bytesToBePersisted += sinkEntry.getBytesInMemory();
                if (!sinkEntry.swappable()) continue;
                int memoryStillInUse = this.calculateMemoryUsedByHydrant();
                this.bytesCurrentlyInMemory += (long)memoryStillInUse;
            }
            if (!this.skipBytesInMemoryOverheadCheck && this.bytesCurrentlyInMemory - bytesToBePersisted > this.maxBytesTuningConfig) {
                String alertMessage = StringUtils.format((String)"Task has exceeded safe estimated heap usage limits, failing (numSinks: [%d] numHydrantsAcrossAllSinks: [%d] totalRows: [%d])(bytesCurrentlyInMemory: [%d] - bytesToBePersisted: [%d] > maxBytesTuningConfig: [%d])", (Object[])new Object[]{this.sinks.size(), this.sinks.values().stream().mapToInt(Iterables::size).sum(), this.getTotalRowCount(), this.bytesCurrentlyInMemory, bytesToBePersisted, this.maxBytesTuningConfig});
                String errorMessage = StringUtils.format((String)"%s.\nThis can occur when the overhead from too many intermediary segment persists becomes to great to have enough space to process additional input rows. This check, along with metering the overhead of these objects to factor into the 'maxBytesInMemory' computation, can be disabled by setting 'skipBytesInMemoryOverheadCheck' to 'true' (note that doing so might allow the task to naturally encounter a 'java.lang.OutOfMemoryError'). Alternatively, 'maxBytesInMemory' can be increased which will cause an increase in heap footprint, but will allow for more intermediary segment persists to occur before reaching this condition.", (Object[])new Object[]{alertMessage});
                log.makeAlert(alertMessage, new Object[0]).addData("dataSource", (Object)this.schema.getDataSource()).emit();
                throw new RuntimeException(errorMessage);
            }
            Futures.addCallback(this.persistAll(null), (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(@Nullable Object result) {
                }

                public void onFailure(Throwable t) {
                    BatchAppenderator.this.persistError = t;
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
        return new Appenderator.AppenderatorAddResult(identifier, this.sinksMetadata.get((Object)identifier).numRowsInSegment, false);
    }

    @Override
    public List<SegmentIdWithShardSpec> getSegments() {
        return ImmutableList.copyOf((Collection)this.sinksMetadata.keySet());
    }

    @VisibleForTesting
    public List<SegmentIdWithShardSpec> getInMemorySegments() {
        return ImmutableList.copyOf(this.sinks.keySet());
    }

    @Override
    public int getRowCount(SegmentIdWithShardSpec identifier) {
        return this.sinksMetadata.get(identifier).getNumRowsInSegment();
    }

    @Override
    public int getTotalRowCount() {
        return this.totalRows;
    }

    @VisibleForTesting
    public int getRowsInMemory() {
        return this.rowsCurrentlyInMemory;
    }

    @VisibleForTesting
    public long getBytesCurrentlyInMemory() {
        return this.bytesCurrentlyInMemory;
    }

    @VisibleForTesting
    public long getBytesInMemory(SegmentIdWithShardSpec identifier) {
        Sink sink = this.sinks.get(identifier);
        if (sink == null) {
            return 0L;
        }
        return sink.getBytesInMemory();
    }

    private Sink getOrCreateSink(SegmentIdWithShardSpec identifier) {
        Sink retVal = this.sinks.get(identifier);
        if (retVal == null) {
            retVal = new Sink(identifier.getInterval(), this.schema, identifier.getShardSpec(), identifier.getVersion(), this.tuningConfig.getAppendableIndexSpec(), this.tuningConfig.getMaxRowsInMemory(), this.maxBytesTuningConfig);
            this.bytesCurrentlyInMemory += (long)this.calculateSinkMemoryInUsed();
            this.sinks.put(identifier, retVal);
            this.metrics.setSinkCount(this.sinks.size());
        }
        return retVal;
    }

    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        throw new UnsupportedOperationException("No query runner for batch appenderator");
    }

    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        throw new UnsupportedOperationException("No query runner for batch appenderator");
    }

    @Override
    public void clear() {
        this.throwPersistErrorIfExists();
        this.clear(this.sinks, true);
    }

    private void clear(Map<SegmentIdWithShardSpec, Sink> sinksToClear, boolean removeOnDiskData) {
        log.info("Clearing all[%d] sinks & their hydrants, removing data on disk: [%s]", new Object[]{sinksToClear.size(), removeOnDiskData});
        Iterator<Map.Entry<SegmentIdWithShardSpec, Sink>> sinksIterator = sinksToClear.entrySet().iterator();
        sinksIterator.forEachRemaining(entry -> {
            this.clearSinkMemoryCountersAndDiskStoredData((SegmentIdWithShardSpec)entry.getKey(), (Sink)entry.getValue(), removeOnDiskData);
            sinksIterator.remove();
        });
        this.metrics.setSinkCount(sinksToClear.size());
    }

    @Override
    public ListenableFuture<?> drop(SegmentIdWithShardSpec identifier) {
        Sink sink = this.sinks.get(identifier);
        SinkMetadata sm = this.sinksMetadata.remove(identifier);
        if (sm != null) {
            int rowsToDrop;
            int originalTotalRows = this.getTotalRowCount();
            int totalRowsAfter = originalTotalRows - (rowsToDrop = sm.getNumRowsInSegment());
            if (totalRowsAfter < 0) {
                log.warn("Total rows[%d] after dropping segment[%s] rows [%d]", new Object[]{totalRowsAfter, identifier, rowsToDrop});
            }
            this.totalRows = Math.max(totalRowsAfter, 0);
        }
        if (sink != null) {
            this.clearSinkMemoryCountersAndDiskStoredData(identifier, sink, true);
            if (this.sinks.remove(identifier) == null) {
                log.warn("Sink for identifier[%s] not found, skipping", new Object[]{identifier});
            }
        }
        return Futures.immediateFuture(null);
    }

    @Override
    public ListenableFuture<Object> persistAll(@Nullable Committer committer) {
        this.throwPersistErrorIfExists();
        if (committer != null) {
            throw new ISE("committer must be null for BatchAppenderator", new Object[0]);
        }
        Map<SegmentIdWithShardSpec, Sink> sinksToPersist = this.swapSinks();
        Stopwatch runExecStopwatch = Stopwatch.createStarted();
        ListenableFuture future = this.persistExecutor.submit(() -> {
            this.setTaskThreadContext();
            log.info("Spawning intermediate persist", new Object[0]);
            ArrayList<Pair> indexesToPersist = new ArrayList<Pair>();
            int numPersistedRows = 0;
            long bytesPersisted = 0L;
            int totalHydrantsCount = 0;
            long totalSinks = sinksToPersist.size();
            for (Map.Entry entry : sinksToPersist.entrySet()) {
                SegmentIdWithShardSpec identifier = (SegmentIdWithShardSpec)entry.getKey();
                Sink sink = (Sink)entry.getValue();
                if (sink == null) {
                    throw new ISE("No sink for identifier: %s", new Object[]{identifier});
                }
                ArrayList hydrants = Lists.newArrayList((Iterable)sink);
                int totalHydrantsForSink = hydrants.size();
                if (totalHydrantsForSink != 1) {
                    throw new ISE("There should be only one hydrant for identifier[%s] but there are[%s]", new Object[]{identifier, totalHydrantsForSink});
                }
                ++totalHydrantsCount;
                numPersistedRows += sink.getNumRowsInMemory();
                bytesPersisted += sink.getBytesInMemory();
                if (!sink.swappable()) {
                    throw new ISE("Sink is not swappable![%s]", new Object[]{identifier});
                }
                indexesToPersist.add(Pair.of((Object)sink.swap(), (Object)identifier));
            }
            if (indexesToPersist.isEmpty()) {
                log.info("No indexes will be persisted", new Object[0]);
            }
            Stopwatch persistStopwatch = Stopwatch.createStarted();
            long startPersistCpuNanos = JvmUtils.safeGetThreadCpuTime();
            try {
                for (Pair pair : indexesToPersist) {
                    this.metrics.incrementRowOutputCount(this.persistHydrant((FireHydrant)pair.lhs, (SegmentIdWithShardSpec)pair.rhs));
                }
                log.info("Persisted in-memory data for segments: %s", new Object[]{indexesToPersist.stream().filter(itp -> itp.rhs != null).map(itp -> ((SegmentIdWithShardSpec)itp.rhs).asSegmentId().toString()).distinct().collect(Collectors.joining(", "))});
                log.info("Persisted stats: processed rows: [%d], persisted rows[%d], persisted sinks: [%d], persisted fireHydrants (across sinks): [%d]", new Object[]{this.rowIngestionMeters.getProcessed(), numPersistedRows, totalSinks, totalHydrantsCount});
                this.metrics.setPersistCpuTime(JvmUtils.safeGetThreadCpuTime() - startPersistCpuNanos);
            }
            catch (Exception e) {
                try {
                    this.metrics.incrementFailedPersists();
                    throw e;
                }
                catch (Throwable throwable) {
                    this.metrics.setPersistCpuTime(JvmUtils.safeGetThreadCpuTime() - startPersistCpuNanos);
                    long persistMillis = persistStopwatch.millisElapsed();
                    this.metrics.incrementPersistTimeMillis(persistMillis);
                    this.metrics.incrementNumPersists();
                    persistStopwatch.stop();
                    log.info("Persisted rows[%,d] and bytes[%,d] and removed all sinks & hydrants from memory in[%d] millis", new Object[]{numPersistedRows, bytesPersisted, persistMillis});
                    log.info("Persist is done.", new Object[0]);
                    throw throwable;
                }
            }
            long persistMillis = persistStopwatch.millisElapsed();
            this.metrics.incrementPersistTimeMillis(persistMillis);
            this.metrics.incrementNumPersists();
            persistStopwatch.stop();
            log.info("Persisted rows[%,d] and bytes[%,d] and removed all sinks & hydrants from memory in[%d] millis", new Object[]{numPersistedRows, bytesPersisted, persistMillis});
            log.info("Persist is done.", new Object[0]);
            return null;
        });
        long startDelay = runExecStopwatch.millisElapsed();
        this.metrics.incrementPersistBackPressureMillis(startDelay);
        if (startDelay > 1000L) {
            log.warn("Ingestion was throttled for [%,d] millis because persists were pending.", new Object[]{startDelay});
        }
        runExecStopwatch.stop();
        return future;
    }

    Map<SegmentIdWithShardSpec, Sink> swapSinks() {
        ImmutableMap retVal = ImmutableMap.copyOf(this.sinks);
        this.sinks.clear();
        this.resetSinkMetadata();
        return retVal;
    }

    @Override
    public ListenableFuture<SegmentsAndCommitMetadata> push(Collection<SegmentIdWithShardSpec> identifiers, @Nullable Committer committer, boolean useUniquePath) {
        if (committer != null) {
            throw new ISE("There should be no committer for batch ingestion", new Object[0]);
        }
        if (useUniquePath) {
            throw new ISE("Batch ingestion does not require uniquePath", new Object[0]);
        }
        ArrayList dataSegments = new ArrayList();
        SegmentSchemaMapping segmentSchemaMapping = new SegmentSchemaMapping(1);
        return Futures.transform(this.persistAll(null), commitMetadata -> {
            this.setTaskThreadContext();
            log.info("Push started, processsing[%d] sinks", new Object[]{identifiers.size()});
            int totalHydrantsMerged = 0;
            for (SegmentIdWithShardSpec identifier : identifiers) {
                Sink sinkForIdentifier;
                SinkMetadata sm = this.sinksMetadata.get(identifier);
                if (sm == null) {
                    throw new ISE("No sink has been processed for identifier[%s]", new Object[]{identifier});
                }
                File persistedDir = sm.getPersistedFileDir();
                if (persistedDir == null) {
                    throw new ISE("Persisted directory for identifier[%s] is null in sink metadata", new Object[]{identifier});
                }
                totalHydrantsMerged += sm.getNumHydrants();
                try {
                    sinkForIdentifier = this.getSinkForIdentifierPath(identifier, persistedDir);
                }
                catch (IOException e) {
                    throw new ISE((Throwable)e, "Failed to retrieve sinks for identifier[%s]", new Object[]{identifier});
                }
                DataSegmentWithMetadata dataSegmentWithMetadata = this.mergeAndPush(identifier, sinkForIdentifier);
                if (dataSegmentWithMetadata.getDataSegment() != null) {
                    DataSegment segment = dataSegmentWithMetadata.getDataSegment();
                    dataSegments.add(segment);
                    SchemaPayloadPlus schemaPayloadPlus = dataSegmentWithMetadata.getSegmentSchemaMetadata();
                    if (schemaPayloadPlus == null) continue;
                    SchemaPayload schemaPayload = schemaPayloadPlus.getSchemaPayload();
                    segmentSchemaMapping.addSchema(segment.getId(), schemaPayloadPlus, this.fingerprintGenerator.generateFingerprint(schemaPayload, segment.getDataSource(), 1));
                    continue;
                }
                log.warn("mergeAndPush[%s] returned null, skipping.", new Object[]{identifier});
            }
            log.info("Push done: total sinks merged[%d], total hydrants merged[%d]", new Object[]{identifiers.size(), totalHydrantsMerged});
            return new SegmentsAndCommitMetadata(dataSegments, commitMetadata, segmentSchemaMapping);
        }, (Executor)this.pushExecutor);
    }

    private DataSegmentWithMetadata mergeAndPush(SegmentIdWithShardSpec identifier, Sink sink) {
        File persistDir = this.computePersistDir(identifier);
        File mergedTarget = new File(persistDir, "merged");
        File descriptorFile = this.computeDescriptorFile(identifier);
        if (sink.isWritable()) {
            throw new ISE("Expected sink to be no longer writable before mergeAndPush for segment[%s].", new Object[]{identifier});
        }
        int numHydrants = 0;
        for (FireHydrant hydrant : sink) {
            if (!hydrant.hasSwapped()) {
                throw new ISE("Expected sink to be fully persisted before mergeAndPush for segment[%s].", new Object[]{identifier});
            }
            ++numHydrants;
        }
        SinkMetadata sm = this.sinksMetadata.get(identifier);
        if (sm == null) {
            log.warn("Sink metadata not found just before merge for identifier [%s]", new Object[]{identifier});
        } else if (numHydrants != sm.getNumHydrants()) {
            throw new ISE("Number of restored hydrants[%d] for identifier[%s] does not match expected value[%d]", new Object[]{numHydrants, identifier, sm.getNumHydrants()});
        }
        try {
            long mergeTimeMillis;
            File mergedFile;
            if (descriptorFile.exists()) {
                log.info("Segment[%s] already pushed, skipping.", new Object[]{identifier});
                return new DataSegmentWithMetadata((DataSegment)this.objectMapper.readValue(descriptorFile, DataSegment.class), this.centralizedDatasourceSchemaConfig.isEnabled() ? TaskSegmentSchemaUtil.getSegmentSchema(mergedTarget, this.indexIO) : null);
            }
            this.removeDirectory(mergedTarget);
            if (mergedTarget.exists()) {
                throw new ISE("Merged target[%s] exists after removing?!", new Object[]{mergedTarget});
            }
            Stopwatch mergeStopwatch = Stopwatch.createStarted();
            long startMergeCpuNanos = JvmUtils.safeGetThreadCpuTime();
            ArrayList<QueryableIndex> indexes = new ArrayList<QueryableIndex>();
            long rowsinMergedSegment = 0L;
            try (Closer closer = Closer.create();){
                for (FireHydrant fireHydrant : sink) {
                    Segment segment = fireHydrant.acquireSegment();
                    QueryableIndex queryableIndex = (QueryableIndex)segment.as(QueryableIndex.class);
                    if (queryableIndex != null) {
                        rowsinMergedSegment += (long)queryableIndex.getNumRows();
                    }
                    log.debug("Segment[%s] adding hydrant[%s]", new Object[]{identifier, fireHydrant});
                    indexes.add(queryableIndex);
                    closer.register((Closeable)segment);
                }
                mergedFile = this.indexMerger.mergeQueryableIndex(indexes, this.schema.getGranularitySpec().isRollup(), this.schema.getAggregators(), this.schema.getDimensionsSpec(), mergedTarget, this.tuningConfig.getIndexSpec(), this.tuningConfig.getIndexSpecForIntermediatePersists(), (ProgressIndicator)new BaseProgressIndicator(), this.tuningConfig.getSegmentWriteOutMediumFactory(), this.tuningConfig.getMaxColumnsToMerge());
                this.metrics.incrementMergedRows(rowsinMergedSegment);
                this.metrics.setMergeCpuTime(JvmUtils.safeGetThreadCpuTime() - startMergeCpuNanos);
                mergeTimeMillis = mergeStopwatch.millisElapsed();
                this.metrics.setMergeTime(mergeTimeMillis);
                log.debug("Segment[%s] built in %,dms.", new Object[]{identifier, mergeTimeMillis});
            }
            Stopwatch pushStopwatch = Stopwatch.createStarted();
            DataSegment segment = this.dataSegmentPusher.push(mergedFile, sink.getSegment().withDimensions(IndexMerger.getMergedDimensionsFromQueryableIndexes(indexes, (DimensionsSpec)this.schema.getDimensionsSpec())), false);
            for (FireHydrant fireHydrant : sink) {
                fireHydrant.swapSegment(null);
            }
            SchemaPayloadPlus schemaMetadata = this.centralizedDatasourceSchemaConfig.isEnabled() ? TaskSegmentSchemaUtil.getSegmentSchema(mergedTarget, this.indexIO) : null;
            this.removeDirectory(this.computePersistDir(identifier));
            long pushTimeMillis = pushStopwatch.millisElapsed();
            this.metrics.incrementPushedRows(rowsinMergedSegment);
            log.info("Segment[%s] of %,d bytes built from %d incremental persist(s) in %,dms; pushed to deep storage in %,dms. Load spec is: %s", new Object[]{identifier, segment.getSize(), indexes.size(), mergeTimeMillis, pushTimeMillis, this.objectMapper.writeValueAsString((Object)segment.getLoadSpec())});
            return new DataSegmentWithMetadata(segment, schemaMetadata);
        }
        catch (Exception e) {
            this.metrics.incrementFailedHandoffs();
            log.warn((Throwable)e, "Failed to push merged index for segment[%s].", new Object[]{identifier});
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            log.debug("Appenderator already closed, skipping close() call.", new Object[0]);
            return;
        }
        log.debug("Shutting down...", new Object[0]);
        try {
            log.debug("Shutdown & wait for persistExecutor", new Object[0]);
            if (this.persistExecutor != null) {
                this.persistExecutor.shutdown();
                if (!this.persistExecutor.awaitTermination(365L, TimeUnit.DAYS)) {
                    log.warn("persistExecutor not terminated", new Object[0]);
                }
                this.persistExecutor = null;
            }
            log.debug("Shutdown & wait for pushExecutor", new Object[0]);
            if (this.pushExecutor != null) {
                this.pushExecutor.shutdown();
                if (!this.pushExecutor.awaitTermination(365L, TimeUnit.DAYS)) {
                    log.warn("pushExecutor not terminated", new Object[0]);
                }
                this.pushExecutor = null;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ISE("Failed to wait & shutdown executors during close()", new Object[0]);
        }
        log.debug("Waited for and shutdown executors...", new Object[0]);
        this.clear(this.sinks, false);
        this.unlockBasePersistDirectory();
        List<File> persistedIdentifiers = this.getPersistedidentifierPaths();
        if (persistedIdentifiers != null) {
            for (File identifier : persistedIdentifiers) {
                this.removeDirectory(identifier);
            }
        }
        this.totalRows = 0;
        this.sinksMetadata.clear();
    }

    @Override
    public void closeNow() {
        if (!this.closed.compareAndSet(false, true)) {
            log.debug("Appenderator already closed, skipping closeNow() call.", new Object[0]);
            return;
        }
        log.debug("Shutting down immediately...", new Object[0]);
        this.shutdownExecutors();
    }

    private void lockBasePersistDirectory() {
        if (this.basePersistDirLock == null) {
            try {
                FileUtils.mkdirp((File)this.tuningConfig.getBasePersistDirectory());
                this.basePersistDirLockChannel = FileChannel.open(this.computeLockFile().toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                this.basePersistDirLock = this.basePersistDirLockChannel.tryLock();
                if (this.basePersistDirLock == null) {
                    throw new ISE("Cannot acquire lock on basePersistDir: %s", new Object[]{this.computeLockFile()});
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void unlockBasePersistDirectory() {
        try {
            if (this.basePersistDirLock != null) {
                this.basePersistDirLock.release();
                this.basePersistDirLockChannel.close();
                this.basePersistDirLock = null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    @VisibleForTesting
    public List<File> getPersistedidentifierPaths() {
        ArrayList<File> retVal = new ArrayList<File>();
        File baseDir = this.tuningConfig.getBasePersistDirectory();
        if (!baseDir.exists()) {
            return null;
        }
        File[] files = baseDir.listFiles();
        if (files == null) {
            return null;
        }
        for (File sinkDir : files) {
            File identifierFile = new File(sinkDir, IDENTIFIER_FILE_NAME);
            if (!identifierFile.isFile()) continue;
            retVal.add(sinkDir);
        }
        return retVal;
    }

    private Sink getSinkForIdentifierPath(SegmentIdWithShardSpec identifier, File identifierPath) throws IOException {
        File[] sinkFiles = identifierPath.listFiles((dir, fileName) -> Ints.tryParse((String)fileName) != null);
        if (sinkFiles == null) {
            throw new ISE("Problem reading persisted sinks in path[%s]", new Object[]{identifierPath});
        }
        Arrays.sort(sinkFiles, (o1, o2) -> Ints.compare((int)Integer.parseInt(o1.getName()), (int)Integer.parseInt(o2.getName())));
        ArrayList<FireHydrant> hydrants = new ArrayList<FireHydrant>();
        for (File hydrantDir : sinkFiles) {
            int hydrantNumber = Integer.parseInt(hydrantDir.getName());
            log.debug("Loading previously persisted partial segment at [%s]", new Object[]{hydrantDir});
            if (hydrantNumber != hydrants.size()) {
                throw new ISE("Missing hydrant [%,d] in identifier [%s].", new Object[]{hydrants.size(), identifier});
            }
            hydrants.add(new FireHydrant((Segment)new QueryableIndexSegment(this.indexIO.loadIndex(hydrantDir), identifier.asSegmentId()), hydrantNumber));
        }
        Sink retVal = new Sink(identifier.getInterval(), this.schema, identifier.getShardSpec(), identifier.getVersion(), this.tuningConfig.getAppendableIndexSpec(), this.tuningConfig.getMaxRowsInMemory(), this.maxBytesTuningConfig, hydrants);
        retVal.finishWriting();
        return retVal;
    }

    private void resetSinkMetadata() {
        this.rowsCurrentlyInMemory = 0;
        this.bytesCurrentlyInMemory = 0L;
        this.metrics.setSinkCount(0L);
    }

    private void clearSinkMemoryCountersAndDiskStoredData(SegmentIdWithShardSpec identifier, Sink sink, boolean removeOnDiskData) {
        if (sink.finishWriting()) {
            this.rowsCurrentlyInMemory -= sink.getNumRowsInMemory();
            this.bytesCurrentlyInMemory -= sink.getBytesInMemory();
            this.bytesCurrentlyInMemory -= (long)this.calculateSinkMemoryInUsed();
            for (FireHydrant hydrant : sink) {
                if (hydrant.equals(sink.getCurrHydrant())) continue;
                this.bytesCurrentlyInMemory -= (long)this.calculateMemoryUsedByHydrant();
            }
        }
        if (removeOnDiskData) {
            this.removeDirectory(this.computePersistDir(identifier));
        }
        log.info("Removed sink for segment[%s].", new Object[]{identifier});
    }

    private File computeLockFile() {
        return new File(this.tuningConfig.getBasePersistDirectory(), ".lock");
    }

    private File computePersistDir(SegmentIdWithShardSpec identifier) {
        return new File(this.tuningConfig.getBasePersistDirectory(), identifier.toString());
    }

    private File computeIdentifierFile(SegmentIdWithShardSpec identifier) {
        return new File(this.computePersistDir(identifier), IDENTIFIER_FILE_NAME);
    }

    private File computeDescriptorFile(SegmentIdWithShardSpec identifier) {
        return new File(this.computePersistDir(identifier), "descriptor.json");
    }

    private File createPersistDirIfNeeded(SegmentIdWithShardSpec identifier) throws IOException {
        File persistDir = this.computePersistDir(identifier);
        FileUtils.mkdirp((File)persistDir);
        this.objectMapper.writeValue(this.computeIdentifierFile(identifier), (Object)identifier);
        return persistDir;
    }

    private int persistHydrant(FireHydrant indexToPersist, SegmentIdWithShardSpec identifier) {
        if (indexToPersist.hasSwapped()) {
            throw new ISE("Segment[%s] hydrant[%s] already swapped. This cannot happen.", new Object[]{identifier, indexToPersist});
        }
        log.debug("Segment[%s], persisting Hydrant[%s]", new Object[]{identifier, indexToPersist});
        try {
            long startTime = System.nanoTime();
            int numRows = indexToPersist.getIndex().numRows();
            SinkMetadata sm = this.sinksMetadata.get(identifier);
            if (sm == null) {
                throw new ISE("Sink must not be null for identifier when persisting hydrant[%s]", new Object[]{identifier});
            }
            File persistDir = this.createPersistDirIfNeeded(identifier);
            this.indexMerger.persist(indexToPersist.getIndex(), identifier.getInterval(), new File(persistDir, String.valueOf(sm.getNumHydrants())), this.tuningConfig.getIndexSpecForIntermediatePersists(), this.tuningConfig.getSegmentWriteOutMediumFactory());
            sm.setPersistedFileDir(persistDir);
            log.info("Persisted in-memory data for segment[%s] spill[%s] to disk in [%,d] ms (%,d rows).", new Object[]{indexToPersist.getSegmentId(), sm.getNumHydrants(), (System.nanoTime() - startTime) / 1000000L, numRows});
            indexToPersist.swapSegment(null);
            sm.addHydrants(1);
            return numRows;
        }
        catch (IOException e) {
            log.makeAlert("Incremental persist failed", new Object[0]).addData("segment", (Object)identifier.toString()).addData("dataSource", (Object)this.schema.getDataSource()).addData("count", (Object)indexToPersist.getCount()).emit();
            throw new RuntimeException(e);
        }
    }

    private void removeDirectory(File target) {
        if (target.exists()) {
            try {
                FileUtils.deleteDirectory((File)target);
                log.info("Removed directory [%s]", new Object[]{target});
            }
            catch (Exception e) {
                log.makeAlert((Throwable)e, "Failed to remove directory[%s]", new Object[]{this.schema.getDataSource()}).addData("file", (Object)target).emit();
            }
        }
    }

    private int calculateMemoryUsedByHydrant() {
        if (this.skipBytesInMemoryOverheadCheck) {
            return 0;
        }
        int total = 1012;
        return total;
    }

    private int calculateSinkMemoryInUsed() {
        if (this.skipBytesInMemoryOverheadCheck) {
            return 0;
        }
        return 5000;
    }

    private static class SinkMetadata {
        private int numRowsInSegment;
        private int numHydrants;
        File persistedFileDir;

        public SinkMetadata() {
            this(0, 0);
        }

        public SinkMetadata(int numRowsInSegment, int numHydrants) {
            this.numRowsInSegment = numRowsInSegment;
            this.numHydrants = numHydrants;
        }

        public void addRows(int num) {
            this.numRowsInSegment += num;
        }

        public void addHydrants(int num) {
            this.numHydrants += num;
        }

        public int getNumRowsInSegment() {
            return this.numRowsInSegment;
        }

        public int getNumHydrants() {
            return this.numHydrants;
        }

        public void setPersistedFileDir(File persistedFileDir) {
            this.persistedFileDir = persistedFileDir;
        }

        public File getPersistedFileDir() {
            return this.persistedFileDir;
        }
    }
}

