/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.timeline.Overshadowable;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.PartitionHolderContents;

public class SimplePartitionHolderContents<T extends Overshadowable<T>>
implements PartitionHolderContents<T> {
    private final Int2ObjectMap<PartitionChunk<T>> chunkForPartition = new Int2ObjectAVLTreeMap();

    @Override
    public boolean isEmpty() {
        return this.chunkForPartition.isEmpty();
    }

    @Override
    public boolean areVisibleChunksConsistent() {
        return true;
    }

    @Override
    public boolean addChunk(PartitionChunk<T> chunk) {
        if (((Overshadowable)chunk.getObject()).getMinorVersion() != 0) {
            throw DruidException.defensive("Cannot handle chunk with minorVersion[%d]", ((Overshadowable)chunk.getObject()).getMinorVersion());
        }
        PartitionChunk existingChunk = (PartitionChunk)this.chunkForPartition.putIfAbsent(chunk.getChunkNumber(), chunk);
        if (existingChunk != null) {
            if (!existingChunk.equals(chunk)) {
                throw DruidException.defensive("existingChunk[%s] is different from newChunk[%s] for partitionId[%d]", existingChunk, chunk, chunk.getChunkNumber());
            }
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public PartitionChunk<T> removeChunk(PartitionChunk<T> chunk) {
        PartitionChunk knownChunk = (PartitionChunk)this.chunkForPartition.get(chunk.getChunkNumber());
        if (knownChunk == null) {
            return null;
        }
        if (!knownChunk.equals(chunk)) {
            throw DruidException.defensive("Unexpected state: Same partitionId[%d], but known partition[%s] is different from the input partition[%s]", chunk.getChunkNumber(), knownChunk, chunk);
        }
        return (PartitionChunk)this.chunkForPartition.remove(chunk.getChunkNumber());
    }

    @Override
    public PartitionChunk<T> getChunk(int partitionNum) {
        return (PartitionChunk)this.chunkForPartition.get(partitionNum);
    }

    @Override
    public Iterator<PartitionChunk<T>> visibleChunksIterator() {
        return this.chunkForPartition.values().iterator();
    }

    @Override
    public List<PartitionChunk<T>> getOvershadowedChunks() {
        return List.of();
    }

    @Override
    public PartitionHolderContents<T> copyVisible() {
        SimplePartitionHolderContents<T> retVal = new SimplePartitionHolderContents<T>();
        for (PartitionChunk chunk : this.chunkForPartition.values()) {
            retVal.addChunk(chunk);
        }
        return retVal;
    }

    @Override
    public PartitionHolderContents<T> deepCopy() {
        return this.copyVisible();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimplePartitionHolderContents that = (SimplePartitionHolderContents)o;
        return Objects.equals(this.chunkForPartition, that.chunkForPartition);
    }

    public int hashCode() {
        return Objects.hashCode(this.chunkForPartition);
    }

    public String toString() {
        return "SimplePartitionHolderContents{chunkForPartition=" + String.valueOf(this.chunkForPartition) + "}";
    }
}

