/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tasklogs;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.apache.druid.common.config.Configs;
import org.apache.druid.tasklogs.TaskLogs;

public class SwitchingTaskLogs
implements TaskLogs {
    public static final String PROPERTY_PREFIX = "druid.indexer.logs.switching";
    public static final String PROPERTY_DEFAULT_TYPE = "druid.indexer.logs.switching.defaultType";
    public static final String PROPERTY_LOG_PUSH_TYPE = "druid.indexer.logs.switching.logPushType";
    public static final String PROPERTY_LOG_STREAM_TYPE = "druid.indexer.logs.switching.logStreamType";
    public static final String PROPERTY_REPORTS_TYPE = "druid.indexer.logs.switching.reportsType";
    public static final String NAME_REPORTS_TYPE = "switching.reportsType";
    public static final String NAME_LOG_STREAM_TYPE = "switching.logStreamType";
    public static final String NAME_LOG_PUSH_TYPE = "switching.logPushType";
    public static final String NAME_DEFAULT_TYPE = "switching.defaultType";
    private final TaskLogs reportTaskLogs;
    private final TaskLogs logStreamer;
    private final TaskLogs logPusher;

    @Inject
    public SwitchingTaskLogs(@Nullable @Named(value="switching.defaultType") TaskLogs defaultDelegate, @Nullable @Named(value="switching.reportsType") TaskLogs reportsDelegate, @Nullable @Named(value="switching.logStreamType") TaskLogs logStreamer, @Nullable @Named(value="switching.logPushType") TaskLogs logPusher) {
        this.reportTaskLogs = Configs.valueOrDefault(reportsDelegate, defaultDelegate);
        this.logStreamer = Configs.valueOrDefault(logStreamer, defaultDelegate);
        this.logPusher = Configs.valueOrDefault(logPusher, defaultDelegate);
    }

    @Override
    public Optional<InputStream> streamTaskLog(String taskid, long offset) throws IOException {
        return this.logStreamer.streamTaskLog(taskid, offset);
    }

    @Override
    public Optional<InputStream> streamTaskReports(String taskid) throws IOException {
        return this.reportTaskLogs.streamTaskReports(taskid);
    }

    @Override
    public Optional<InputStream> streamTaskStatus(String taskid) throws IOException {
        return this.reportTaskLogs.streamTaskStatus(taskid);
    }

    @Override
    public void pushTaskLog(String taskid, File logFile) throws IOException {
        this.logPusher.pushTaskLog(taskid, logFile);
    }

    @Override
    public void pushTaskPayload(String taskid, File taskPayloadFile) throws IOException {
        this.reportTaskLogs.pushTaskPayload(taskid, taskPayloadFile);
    }

    @Override
    public void killAll() throws IOException {
        this.reportTaskLogs.killAll();
    }

    @Override
    public void killOlderThan(long timestamp) throws IOException {
        this.reportTaskLogs.killOlderThan(timestamp);
    }

    @Override
    public void pushTaskReports(String taskid, File reportFile) throws IOException {
        this.reportTaskLogs.pushTaskReports(taskid, reportFile);
    }

    @Override
    public void pushTaskStatus(String taskid, File reportFile) throws IOException {
        this.reportTaskLogs.pushTaskStatus(taskid, reportFile);
    }

    @Override
    public Optional<InputStream> streamTaskPayload(String taskid) throws IOException {
        return this.reportTaskLogs.streamTaskPayload(taskid);
    }
}

