/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.segment.RowIdSupplier;
import org.apache.druid.segment.virtual.BaseExpressionColumnValueSelector;
import org.apache.druid.segment.virtual.ExpressionPlan;

public class RowBasedExpressionColumnValueSelector
extends BaseExpressionColumnValueSelector {
    private final Expr.ObjectBinding bindings;
    private final Expr expression;
    private final List<String> unknownColumns;
    private final Expr.BindingAnalysis baseBindingAnalysis;
    private final Int2ObjectMap<Expr> transformedCache;

    public RowBasedExpressionColumnValueSelector(ExpressionPlan plan, Expr.ObjectBinding bindings, @Nullable RowIdSupplier rowIdSupplier) {
        super(rowIdSupplier);
        this.bindings = bindings;
        this.expression = plan.getAppliedExpression();
        this.unknownColumns = plan.getUnknownInputs().stream().filter(x -> !plan.getAnalysis().getArrayBindings().contains(x)).collect(Collectors.toList());
        this.baseBindingAnalysis = plan.getAnalysis();
        this.transformedCache = new Int2ObjectArrayMap(this.unknownColumns.size());
    }

    @Override
    protected ExprEval<?> eval() {
        ArrayList arrayBindings = Lists.newArrayListWithCapacity((int)this.unknownColumns.size());
        for (String unknownColumn : this.unknownColumns) {
            if (!this.isBindingArray(unknownColumn)) continue;
            arrayBindings.add(unknownColumn);
        }
        if (!arrayBindings.isEmpty()) {
            int key = arrayBindings.hashCode();
            if (this.transformedCache.containsKey(key)) {
                return ((Expr)this.transformedCache.get(key)).eval(this.bindings);
            }
            Expr transformed = Parser.applyUnappliedBindings(this.expression, this.baseBindingAnalysis, arrayBindings);
            this.transformedCache.put(key, (Object)transformed);
            return transformed.eval(this.bindings);
        }
        return this.expression.eval(this.bindings);
    }

    private boolean isBindingArray(String x) {
        Object binding = this.bindings.get(x);
        if (binding != null) {
            return binding instanceof Object[] && ((Object[])binding).length > 0;
        }
        return false;
    }
}

