/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.projections;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.List;
import java.util.Objects;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.projections.BaseTableProjectionSchema;
import org.apache.druid.segment.projections.ProjectionSchema;
import org.apache.druid.segment.projections.RollupTableProjectionSchema;
import org.apache.druid.segment.projections.TableProjectionSchema;

public class ProjectionMetadata {
    public static final Interner<ProjectionSchema> SCHEMA_INTERNER = Interners.newWeakInterner();
    private final int numRows;
    private final ProjectionSchema schema;

    public static ProjectionMetadata forBaseTable(int numRows, List<String> dims, Metadata metadata) {
        BaseTableProjectionSchema schema = Boolean.TRUE.equals(metadata.isRollup()) ? RollupTableProjectionSchema.fromMetadata(dims, metadata) : TableProjectionSchema.fromMetadata(dims, metadata);
        return new ProjectionMetadata(numRows, schema);
    }

    @JsonCreator
    public ProjectionMetadata(@JsonProperty(value="numRows") int numRows, @JsonProperty(value="schema") ProjectionSchema schema) {
        this.numRows = numRows;
        this.schema = (ProjectionSchema)SCHEMA_INTERNER.intern((Object)schema);
    }

    @JsonProperty
    public int getNumRows() {
        return this.numRows;
    }

    @JsonProperty
    public ProjectionSchema getSchema() {
        return this.schema;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectionMetadata that = (ProjectionMetadata)o;
        return this.numRows == that.numRows && Objects.equals(this.schema, that.schema);
    }

    public int hashCode() {
        return Objects.hash(this.numRows, this.schema);
    }

    public String toString() {
        return "ProjectionMetadata{numRows=" + this.numRows + ", schema=" + String.valueOf(this.schema) + "}";
    }
}

