/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.primitives.Ints;
import com.google.inject.Inject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.druid.io.ZeroCopyByteArrayOutputStream;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.AggregateProjectionMetadata;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.DimensionMergerV9;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMergerBase;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.IndexableAdapter;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.ProgressIndicator;
import org.apache.druid.segment.TimeAndDimsIterator;
import org.apache.druid.segment.TransformableRowIterator;
import org.apache.druid.segment.column.ColumnDescriptor;
import org.apache.druid.segment.column.ColumnFormat;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.file.SegmentFileBuilder;
import org.apache.druid.segment.file.SegmentFileChannel;
import org.apache.druid.segment.loading.MMappedQueryableSegmentizerFactory;
import org.apache.druid.segment.loading.SegmentizerFactory;
import org.apache.druid.segment.serde.NullColumnPartSerde;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.utils.CollectionUtils;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class IndexMergerV9
extends IndexMergerBase {
    private static final Logger log = new Logger(IndexMergerV9.class);
    private final boolean storeEmptyColumns;

    public IndexMergerV9(ObjectMapper mapper, IndexIO indexIO, SegmentWriteOutMediumFactory defaultSegmentWriteOutMediumFactory, boolean storeEmptyColumns) {
        super(mapper, indexIO, defaultSegmentWriteOutMediumFactory);
        this.storeEmptyColumns = storeEmptyColumns;
    }

    @Inject
    public IndexMergerV9(ObjectMapper mapper, IndexIO indexIO, SegmentWriteOutMediumFactory defaultSegmentWriteOutMediumFactory) {
        this(mapper, indexIO, defaultSegmentWriteOutMediumFactory, false);
    }

    @Override
    protected boolean shouldStoreEmptyColumns() {
        return this.storeEmptyColumns;
    }

    @Override
    protected File makeIndexFiles(List<IndexableAdapter> adapters, @Nullable Metadata segmentMetadata, File outDir, ProgressIndicator progress, List<String> mergedDimensionsWithTime, IndexMergerBase.DimensionsSpecInspector dimensionsSpecInspector, List<String> mergedMetrics, Function<List<TransformableRowIterator>, TimeAndDimsIterator> rowMergerFn, IndexSpec indexSpec, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) throws IOException {
        progress.start();
        progress.progress();
        List<String> mergedDimensions = mergedDimensionsWithTime.stream().filter(dim -> !"__time".equals(dim)).collect(Collectors.toList());
        FileSmoosher v9Smoosher = new FileSmoosher(outDir);
        try (Closer closer = Closer.create();){
            FileUtils.mkdirp(outDir);
            SegmentWriteOutMediumFactory omf = segmentWriteOutMediumFactory != null ? segmentWriteOutMediumFactory : this.defaultSegmentWriteOutMediumFactory;
            log.debug("Using SegmentWriteOutMediumFactory[%s]", omf.getClass().getSimpleName());
            SegmentWriteOutMedium segmentWriteOutMedium = omf.makeSegmentWriteOutMedium(outDir);
            closer.register(segmentWriteOutMedium);
            long startTime = System.currentTimeMillis();
            Files.asByteSink((File)new File(outDir, "version.bin"), (FileWriteMode[])new FileWriteMode[0]).write(Ints.toByteArray((int)9));
            log.debug("Completed version.bin in %,d millis.", System.currentTimeMillis() - startTime);
            progress.progress();
            startTime = System.currentTimeMillis();
            try (FileOutputStream fos = new FileOutputStream(new File(outDir, "factory.json"));){
                SegmentizerFactory customSegmentLoader = indexSpec.getSegmentLoader();
                if (customSegmentLoader != null) {
                    this.mapper.writeValue((OutputStream)fos, (Object)customSegmentLoader);
                } else {
                    this.mapper.writeValue((OutputStream)fos, (Object)new MMappedQueryableSegmentizerFactory(this.indexIO));
                }
            }
            log.debug("Completed factory.json in %,d millis", System.currentTimeMillis() - startTime);
            progress.progress();
            TreeMap<String, ColumnFormat> metricFormats = new TreeMap<String, ColumnFormat>((Comparator<String>)Comparators.naturalNullsFirst());
            ArrayList dimFormats = Lists.newArrayListWithCapacity((int)mergedDimensions.size());
            this.mergeFormat(adapters, mergedDimensions, metricFormats, dimFormats);
            Map<String, DimensionHandler> handlers = this.makeDimensionHandlers(mergedDimensions, dimFormats);
            HashMap mergersMap = Maps.newHashMapWithExpectedSize((int)mergedDimensions.size());
            ArrayList<DimensionMergerV9> mergers = new ArrayList<DimensionMergerV9>();
            for (int i = 0; i < mergedDimensions.size(); ++i) {
                DimensionHandler handler = handlers.get(mergedDimensions.get(i));
                DimensionMergerV9 merger = handler.makeMerger(mergedDimensions.get(i), indexSpec, segmentWriteOutMedium, ((ColumnFormat)dimFormats.get(i)).toColumnCapabilities(), progress, outDir, closer);
                mergers.add(merger);
                mergersMap.put(mergedDimensions.get(i), merger);
            }
            if (segmentMetadata != null && segmentMetadata.getProjections() != null) {
                for (AggregateProjectionMetadata projectionMetadata : segmentMetadata.getProjections()) {
                    for (String dimension : projectionMetadata.getSchema().getGroupingColumns()) {
                        DimensionMergerV9 merger = (DimensionMergerV9)mergersMap.get(dimension);
                        if (merger == null) continue;
                        merger.markAsParent();
                    }
                }
            }
            progress.progress();
            startTime = System.currentTimeMillis();
            this.writeDimValuesAndSetupDimConversion(adapters, progress, mergedDimensions, mergers);
            log.debug("Completed dim conversions in %,d millis.", System.currentTimeMillis() - startTime);
            progress.progress();
            TimeAndDimsIterator timeAndDimsIterator = this.makeMergedTimeAndDimsIterator(adapters, mergedDimensionsWithTime, mergedMetrics, rowMergerFn, handlers, mergers);
            closer.register(timeAndDimsIterator);
            GenericColumnSerializer timeWriter = this.setupTimeWriter(segmentWriteOutMedium, indexSpec);
            ArrayList<GenericColumnSerializer> metricWriters = this.setupMetricsWriters(segmentWriteOutMedium, mergedMetrics, metricFormats, indexSpec, "");
            IndexMergerBase.IndexMergeResult indexMergeResult = this.mergeIndexesAndWriteColumns(adapters, progress, timeAndDimsIterator, timeWriter, metricWriters, mergers);
            String section = "build inverted index and columns";
            progress.startSection("build inverted index and columns");
            this.makeTimeColumn(v9Smoosher, progress, timeWriter, indexSpec, "__time");
            this.makeMetricsColumns(v9Smoosher, progress, mergedMetrics, metricFormats, metricWriters, indexSpec, "");
            for (int i = 0; i < mergedDimensions.size(); ++i) {
                ColumnDescriptor columnDesc;
                DimensionMergerV9 merger = (DimensionMergerV9)mergers.get(i);
                merger.writeIndexes(indexMergeResult.rowNumConversions);
                if (!merger.hasOnlyNulls()) {
                    columnDesc = merger.makeColumnDescriptor();
                    this.makeColumn(v9Smoosher, mergedDimensions.get(i), columnDesc);
                    continue;
                }
                if (!dimensionsSpecInspector.shouldStore(mergedDimensions.get(i))) continue;
                columnDesc = ColumnDescriptor.builder().setValueType((ValueType)((ColumnFormat)dimFormats.get(i)).getLogicalType().getType()).addSerde(new NullColumnPartSerde(indexMergeResult.rowCount, indexSpec.getBitmapSerdeFactory())).build();
                this.makeColumn(v9Smoosher, mergedDimensions.get(i), columnDesc);
            }
            progress.stopSection("build inverted index and columns");
            Metadata finalMetadata = segmentMetadata == null || CollectionUtils.isNullOrEmpty(segmentMetadata.getProjections()) ? segmentMetadata : this.makeProjections(v9Smoosher, segmentMetadata.getProjections(), adapters, indexSpec, segmentWriteOutMedium, progress, outDir, closer, mergersMap, segmentMetadata);
            progress.progress();
            this.makeIndexBinary(v9Smoosher, adapters, outDir, mergedDimensions, mergedMetrics, progress, indexSpec, mergers, dimensionsSpecInspector);
            this.makeMetadataBinary(v9Smoosher, progress, finalMetadata);
            v9Smoosher.close();
            progress.stop();
            File file = outDir;
            return file;
        }
    }

    @Override
    protected void makeColumn(SegmentFileBuilder segmentFileBuilder, String columnName, ColumnDescriptor serdeficator) throws IOException {
        ZeroCopyByteArrayOutputStream specBytes = new ZeroCopyByteArrayOutputStream();
        SERIALIZER_UTILS.writeString(specBytes, this.mapper.writeValueAsString((Object)serdeficator));
        try (SegmentFileChannel channel = segmentFileBuilder.addWithChannel(columnName, (long)specBytes.size() + serdeficator.getSerializedSize());){
            specBytes.writeTo(channel);
            serdeficator.writeTo(channel, segmentFileBuilder);
        }
    }

    private void makeMetadataBinary(FileSmoosher v9Smoosher, ProgressIndicator progress, Metadata segmentMetadata) throws IOException {
        if (segmentMetadata != null) {
            progress.startSection("make metadata.drd");
            v9Smoosher.add("metadata.drd", ByteBuffer.wrap(this.mapper.writeValueAsBytes((Object)segmentMetadata)));
            progress.stopSection("make metadata.drd");
        }
    }

    private void makeIndexBinary(FileSmoosher v9Smoosher, List<IndexableAdapter> adapters, File outDir, List<String> mergedDimensions, List<String> mergedMetrics, ProgressIndicator progress, IndexSpec indexSpec, List<DimensionMergerV9> mergers, IndexMergerBase.DimensionsSpecInspector dimensionsSpecInspector) throws IOException {
        HashSet<String> columnSet = new HashSet<String>(mergedDimensions);
        columnSet.addAll(mergedMetrics);
        Preconditions.checkState((columnSet.size() == mergedDimensions.size() + mergedMetrics.size() ? 1 : 0) != 0, (String)"column names are not unique in dims[%s] and mets[%s]", mergedDimensions, mergedMetrics);
        String section = "make index.drd";
        progress.startSection("make index.drd");
        long startTime = System.currentTimeMillis();
        ArrayList<String> nonNullOnlyDimensions = new ArrayList<String>(mergedDimensions.size());
        ArrayList<String> nonNullOnlyColumns = new ArrayList<String>(mergedDimensions.size() + mergedMetrics.size());
        nonNullOnlyColumns.addAll(mergedMetrics);
        ArrayList<String> allDimensions = new ArrayList<String>(mergedDimensions.size());
        ArrayList<String> allColumns = new ArrayList<String>(mergedDimensions.size() + mergedMetrics.size());
        IntStream.range(0, mergedMetrics.size()).forEach(i -> allColumns.add(null));
        for (int i2 = 0; i2 < mergedDimensions.size(); ++i2) {
            if (!mergers.get(i2).hasOnlyNulls()) {
                nonNullOnlyDimensions.add(mergedDimensions.get(i2));
                nonNullOnlyColumns.add(mergedDimensions.get(i2));
                allDimensions.add(null);
                allColumns.add(null);
                continue;
            }
            if (!dimensionsSpecInspector.shouldStore(mergedDimensions.get(i2))) continue;
            allDimensions.add(mergedDimensions.get(i2));
            allColumns.add(mergedDimensions.get(i2));
        }
        GenericIndexed<String> nonNullCols = GenericIndexed.fromIterable(nonNullOnlyColumns, GenericIndexed.STRING_STRATEGY);
        GenericIndexed<String> nonNullDims = GenericIndexed.fromIterable(nonNullOnlyDimensions, GenericIndexed.STRING_STRATEGY);
        GenericIndexed<String> nullCols = GenericIndexed.fromIterable(allColumns, GenericIndexed.STRING_STRATEGY);
        GenericIndexed<String> nullDims = GenericIndexed.fromIterable(allDimensions, GenericIndexed.STRING_STRATEGY);
        String bitmapSerdeFactoryType = this.mapper.writeValueAsString((Object)indexSpec.getBitmapSerdeFactory());
        long numBytes = nonNullCols.getSerializedSize() + nonNullDims.getSerializedSize() + nullCols.getSerializedSize() + nullDims.getSerializedSize() + 16L + (long)SERIALIZER_UTILS.getSerializedStringByteSize(bitmapSerdeFactoryType);
        try (SegmentFileChannel writer = v9Smoosher.addWithChannel("index.drd", numBytes);){
            nonNullCols.writeTo(writer, v9Smoosher);
            nonNullDims.writeTo(writer, v9Smoosher);
            DateTime minTime = DateTimes.MAX;
            DateTime maxTime = DateTimes.MIN;
            for (IndexableAdapter index : adapters) {
                minTime = JodaUtils.minDateTime(minTime, index.getDataInterval().getStart());
                maxTime = JodaUtils.maxDateTime(maxTime, index.getDataInterval().getEnd());
            }
            Interval dataInterval = new Interval((ReadableInstant)minTime, (ReadableInstant)maxTime);
            SERIALIZER_UTILS.writeLong(writer, dataInterval.getStartMillis());
            SERIALIZER_UTILS.writeLong(writer, dataInterval.getEndMillis());
            SERIALIZER_UTILS.writeString(writer, bitmapSerdeFactoryType);
            nullCols.writeTo(writer, v9Smoosher);
            nullDims.writeTo(writer, v9Smoosher);
        }
        IndexIO.checkFileSize(new File(outDir, "index.drd"));
        log.debug("Completed index.drd in %,d millis.", System.currentTimeMillis() - startTime);
        progress.stopSection("make index.drd");
    }
}

