/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.FeedDefiningMonitor;
import org.apache.druid.java.util.metrics.KeyedDiff;
import org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;
import org.apache.druid.java.util.metrics.cgroups.Disk;
import org.apache.druid.java.util.metrics.cgroups.ProcCgroupV2Discoverer;
import org.apache.druid.java.util.metrics.cgroups.ProcSelfCgroupDiscoverer;

public class CgroupV2DiskMonitor
extends FeedDefiningMonitor {
    private static final Logger LOG = new Logger(CgroupV2DiskMonitor.class);
    private static final String IO_STAT = "io.stat";
    final CgroupDiscoverer cgroupDiscoverer;
    private final KeyedDiff diff = new KeyedDiff();

    public CgroupV2DiskMonitor(CgroupDiscoverer cgroupDiscoverer, String feed) {
        super(feed);
        this.cgroupDiscoverer = cgroupDiscoverer;
    }

    @VisibleForTesting
    CgroupV2DiskMonitor(CgroupDiscoverer cgroupDiscoverer) {
        this(cgroupDiscoverer, "metrics");
    }

    CgroupV2DiskMonitor() {
        this(new ProcSelfCgroupDiscoverer(ProcCgroupV2Discoverer.class));
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        for (Disk.Metrics entry : this.snapshot()) {
            Map<String, Long> stats = this.diff.to(entry.getDiskName(), (Map<String, Long>)ImmutableMap.builder().put((Object)"cgroup/disk/read/bytes", (Object)entry.getReadBytes()).put((Object)"cgroup/disk/read/count", (Object)entry.getReadCount()).put((Object)"cgroup/disk/write/bytes", (Object)entry.getWriteBytes()).put((Object)"cgroup/disk/write/count", (Object)entry.getWriteCount()).build());
            if (stats == null) continue;
            ServiceMetricEvent.Builder builder = this.builder().setDimension("diskName", entry.getDiskName());
            builder.setDimension("cgroupversion", (Object)this.cgroupDiscoverer.getCgroupVersion());
            for (Map.Entry<String, Long> stat : stats.entrySet()) {
                emitter.emit(builder.setMetric(stat.getKey(), stat.getValue()));
            }
        }
        return true;
    }

    public List<Disk.Metrics> snapshot() {
        ArrayList<Disk.Metrics> diskStats = new ArrayList<Disk.Metrics>();
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(this.cgroupDiscoverer.discover("disk").toString(), IO_STAT));){
            String line = reader.readLine();
            while (line != null) {
                Disk.Metrics disk = CgroupV2DiskMonitor.getDiskMetrics(line);
                diskStats.add(disk);
                line = reader.readLine();
            }
        }
        catch (IOException | RuntimeException ex) {
            LOG.error(ex, "Unable to fetch memory snapshot", new Object[0]);
        }
        return diskStats;
    }

    private static Disk.Metrics getDiskMetrics(String line) {
        String[] parts = line.split(Pattern.quote(" "));
        Disk.Metrics disk = new Disk.Metrics(parts[0]);
        HashMap<String, Long> stats = new HashMap<String, Long>();
        for (int i = 1; i < parts.length; ++i) {
            String[] keyValue = parts[i].split("=");
            if (keyValue.length != 2) continue;
            stats.put(keyValue[0], Long.parseLong(keyValue[1]));
        }
        disk.setReadBytes((Long)stats.get("rbytes"));
        disk.setReadCount((Long)stats.get("rios"));
        disk.setWriteBytes((Long)stats.get("wbytes"));
        disk.setWriteCount((Long)stats.get("wios"));
        return disk;
    }
}

