/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.CgroupV2DiskMonitor;
import org.apache.druid.java.util.metrics.FeedDefiningMonitor;
import org.apache.druid.java.util.metrics.KeyedDiff;
import org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;
import org.apache.druid.java.util.metrics.cgroups.CgroupVersion;
import org.apache.druid.java.util.metrics.cgroups.Disk;
import org.apache.druid.java.util.metrics.cgroups.ProcSelfCgroupDiscoverer;

public class CgroupDiskMonitor
extends FeedDefiningMonitor {
    private static final Logger LOG = new Logger(CgroupDiskMonitor.class);
    private final CgroupDiscoverer cgroupDiscoverer;
    private final KeyedDiff diff = new KeyedDiff();
    private final boolean isRunningOnCgroupsV2;
    private final CgroupV2DiskMonitor cgroupV2DiskMonitor;

    public CgroupDiskMonitor(CgroupDiscoverer cgroupDiscoverer, String feed) {
        super(feed);
        this.cgroupDiscoverer = cgroupDiscoverer;
        this.isRunningOnCgroupsV2 = cgroupDiscoverer.getCgroupVersion().equals((Object)CgroupVersion.V2);
        if (this.isRunningOnCgroupsV2) {
            this.cgroupV2DiskMonitor = new CgroupV2DiskMonitor(cgroupDiscoverer, feed);
            LOG.info("Detected cgroups v2, using CgroupV2DiskMonitor behavior for accurate metrics", new Object[0]);
        } else {
            this.cgroupV2DiskMonitor = null;
        }
    }

    public CgroupDiskMonitor(String feed) {
        this(ProcSelfCgroupDiscoverer.autoCgroupDiscoverer(), feed);
    }

    public CgroupDiskMonitor() {
        this("metrics");
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        if (this.isRunningOnCgroupsV2) {
            return this.cgroupV2DiskMonitor.doMonitor(emitter);
        }
        return this.doMonitorV1(emitter);
    }

    private boolean doMonitorV1(ServiceEmitter emitter) {
        Map<String, Disk.Metrics> snapshot = new Disk(this.cgroupDiscoverer).snapshot();
        for (Map.Entry<String, Disk.Metrics> entry : snapshot.entrySet()) {
            Map<String, Long> stats = this.diff.to(entry.getKey(), (Map<String, Long>)ImmutableMap.builder().put((Object)"cgroup/disk/read/bytes", (Object)entry.getValue().getReadBytes()).put((Object)"cgroup/disk/read/count", (Object)entry.getValue().getReadCount()).put((Object)"cgroup/disk/write/bytes", (Object)entry.getValue().getWriteBytes()).put((Object)"cgroup/disk/write/count", (Object)entry.getValue().getWriteCount()).build());
            if (stats == null) continue;
            ServiceMetricEvent.Builder builder = this.builder().setDimension("diskName", entry.getValue().getDiskName());
            builder.setDimension("cgroupversion", (Object)this.cgroupDiscoverer.getCgroupVersion());
            for (Map.Entry<String, Long> stat : stats.entrySet()) {
                emitter.emit(builder.setMetric(stat.getKey(), stat.getValue()));
            }
        }
        return true;
    }
}

