/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.field.ReadableFieldPointer;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;

public abstract class NumericArrayFieldSelector<ElementType extends Number>
implements ColumnValueSelector<Object[]> {
    protected final Memory memory;
    private final ReadableFieldPointer fieldPointer;
    private long currentFieldPosition = -1L;
    @Nullable
    private Number[] currentRow = null;

    public NumericArrayFieldSelector(Memory memory, ReadableFieldPointer fieldPointer) {
        this.memory = memory;
        this.fieldPointer = fieldPointer;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
    }

    @Override
    @Nullable
    public Object[] getObject() {
        return this.computeCurrentArray();
    }

    @Override
    public Class<Object[]> classOfObject() {
        return Object[].class;
    }

    @Override
    public double getDouble() {
        return 0.0;
    }

    @Override
    public float getFloat() {
        return 0.0f;
    }

    @Override
    public long getLong() {
        return 0L;
    }

    @Override
    public boolean isNull() {
        long position = this.fieldPointer.position();
        byte firstByte = this.memory.getByte(position);
        return firstByte == 0;
    }

    @Nullable
    public abstract ElementType getIndividualValueAtMemory(long var1);

    public abstract int getIndividualFieldSize();

    @Nullable
    private Object[] computeCurrentArray() {
        long fieldPosition = this.fieldPointer.position();
        long fieldLength = this.fieldPointer.length();
        if (fieldPosition != this.currentFieldPosition) {
            this.updateCurrentArray(fieldPosition, fieldLength);
        }
        this.currentFieldPosition = fieldPosition;
        return this.currentRow;
    }

    private void updateCurrentArray(long fieldPosition, long fieldLength) {
        this.currentRow = null;
        long position = fieldPosition;
        long limit = this.memory.getCapacity();
        if (this.isNull()) {
            return;
        }
        if (position < limit) {
            ++position;
        }
        int numElements = this.numElements(fieldLength);
        this.currentRow = new Number[numElements];
        boolean rowTerminatorSeen = false;
        int curElement = 0;
        while (position < limit) {
            byte kind = this.memory.getByte(position);
            if (kind == 0) {
                rowTerminatorSeen = true;
                break;
            }
            this.currentRow[curElement] = this.getIndividualValueAtMemory(position);
            position += (long)this.getIndividualFieldSize();
            ++curElement;
        }
        if (!rowTerminatorSeen || curElement != numElements) {
            throw DruidException.defensive("Unexpected end of field", new Object[0]);
        }
    }

    int numElements(long fieldSize) {
        if (fieldSize <= 1L) {
            throw DruidException.defensive("fieldSize should be greater than 1 for non null array elements", new Object[0]);
        }
        long cumulativeFieldSize = fieldSize - 1L - 1L;
        if (cumulativeFieldSize % (long)this.getIndividualFieldSize() != 0L) {
            throw DruidException.defensive("cumulativeFieldSize should be a multiple of the individual fieldSize", new Object[0]);
        }
        return Math.toIntExact(cumulativeFieldSize / (long)this.getIndividualFieldSize());
    }
}

