/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.joda.ser.DateTimeSerializer;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.query.QueryToolChest;
import org.joda.time.DateTime;

public class ResourceIOReaderWriterFactory {
    private final ObjectMapper jsonMapper;
    private final ObjectMapper smileMapper;
    private final ObjectMapper serializeDateTimeAsLongJsonMapper;
    private final ObjectMapper serializeDateTimeAsLongSmileMapper;

    @Inject
    public ResourceIOReaderWriterFactory(@Json ObjectMapper jsonMapper, @Smile ObjectMapper smileMapper) {
        this.jsonMapper = jsonMapper;
        this.smileMapper = smileMapper;
        this.serializeDateTimeAsLongJsonMapper = ResourceIOReaderWriterFactory.serializeDataTimeAsLong(jsonMapper);
        this.serializeDateTimeAsLongSmileMapper = ResourceIOReaderWriterFactory.serializeDataTimeAsLong(smileMapper);
    }

    public ResourceIOReaderWriter factorize(HttpServletRequest req, boolean pretty) {
        String requestType = req.getContentType();
        String acceptHeader = req.getHeader("Accept");
        String responseType = Strings.isNullOrEmpty((String)acceptHeader) ? requestType : acceptHeader;
        boolean isRequestSmile = "application/x-jackson-smile".equals(requestType) || "application/smile".equals(requestType);
        boolean isResponseSmile = "application/x-jackson-smile".equals(responseType) || "application/smile".equals(responseType);
        return new ResourceIOReaderWriter(isRequestSmile ? this.smileMapper : this.jsonMapper, new ResourceIOWriter(isResponseSmile ? "application/x-jackson-smile" : "application/json", isResponseSmile ? this.smileMapper : this.jsonMapper, isResponseSmile ? this.serializeDateTimeAsLongSmileMapper : this.serializeDateTimeAsLongJsonMapper, pretty));
    }

    private static ObjectMapper serializeDataTimeAsLong(ObjectMapper mapper) {
        return mapper.copy().registerModule((Module)new SimpleModule().addSerializer(DateTime.class, (JsonSerializer)new DateTimeSerializer()));
    }

    public static class ResourceIOReaderWriter {
        private final ObjectMapper requestMapper;
        private final ResourceIOWriter writer;

        public ResourceIOReaderWriter(ObjectMapper requestMapper, ResourceIOWriter writer) {
            this.requestMapper = requestMapper;
            this.writer = writer;
        }

        public ObjectMapper getRequestMapper() {
            return this.requestMapper;
        }

        public ResourceIOWriter getResponseWriter() {
            return this.writer;
        }
    }

    public static class ResourceIOWriter {
        private final String responseType;
        private final ObjectMapper inputMapper;
        private final ObjectMapper serializeDateTimeAsLongInputMapper;
        private final boolean isPretty;

        ResourceIOWriter(String responseType, ObjectMapper inputMapper, ObjectMapper serializeDateTimeAsLongInputMapper, boolean isPretty) {
            this.responseType = responseType;
            this.inputMapper = inputMapper;
            this.serializeDateTimeAsLongInputMapper = serializeDateTimeAsLongInputMapper;
            this.isPretty = isPretty;
        }

        String getResponseType() {
            return this.responseType;
        }

        ObjectMapper newOutputWriter(@Nullable QueryToolChest<?, Query<?>> toolChest, @Nullable Query<?> query, boolean serializeDateTimeAsLong) {
            ObjectMapper mapper = serializeDateTimeAsLong ? this.serializeDateTimeAsLongInputMapper : this.inputMapper;
            ObjectMapper decoratedMapper = toolChest != null ? toolChest.decorateObjectMapper(mapper, (Query)Preconditions.checkNotNull(query, (Object)"query")) : mapper;
            return this.isPretty ? decoratedMapper.copy().enable(SerializationFeature.INDENT_OUTPUT) : decoratedMapper;
        }

        public Response ok(Object object) throws IOException {
            return Response.ok((Object)this.newOutputWriter(null, null, false).writeValueAsString(object), (String)this.responseType).build();
        }

        public Response gotError(Exception e) throws IOException {
            return this.buildNonOkResponse(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Exception)QueryInterruptedException.wrapIfNeeded((Throwable)e));
        }

        public Response buildNonOkResponse(int status, Exception e) throws JsonProcessingException {
            return Response.status((int)status).type(this.responseType).entity((Object)this.newOutputWriter(null, null, false).writeValueAsBytes((Object)e)).build();
        }
    }
}

