/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.ExtractionDimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.SelectableColumn;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.nested.NestedColumnIndexSupplier;
import org.apache.druid.segment.nested.NestedColumnSelectorFactory;
import org.apache.druid.segment.nested.NestedColumnTypeInspector;
import org.apache.druid.segment.nested.NestedPathField;
import org.apache.druid.segment.nested.NestedPathPart;
import org.apache.druid.segment.nested.NestedVectorColumnSelectorFactory;
import org.apache.druid.segment.vector.NilVectorSelector;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.segment.virtual.SpecializedExpressionVirtualColumn;

@JsonTypeName(value="nested-object")
public class NestedObjectVirtualColumn
extends SpecializedExpressionVirtualColumn {
    private final Map<String, TypedExpression> keyExprMap;
    private final ExprMacroTable macroTable;

    @JsonCreator
    public NestedObjectVirtualColumn(@JsonProperty(value="name") String name, @JsonProperty(value="object") Map<String, TypedExpression> keyExprMap, @JacksonInject ExprMacroTable macroTable) {
        super(new ExpressionVirtualColumn(name, StringUtils.format("%s(%s)", "json_object", keyExprMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> {
            String key = (String)entry.getKey();
            TypedExpression valueExpr = (TypedExpression)entry.getValue();
            return Parser.constant(key).stringify() + "," + valueExpr.expression;
        }).collect(Collectors.joining(","))), ColumnType.NESTED_DATA, macroTable));
        this.keyExprMap = keyExprMap;
        this.macroTable = macroTable;
    }

    @JsonProperty(value="object")
    public Map<String, TypedExpression> getKeyExprMap() {
        return this.keyExprMap;
    }

    @Override
    public SelectableColumn toSelectableColumn(final ColumnIndexSelector columnSelector) {
        if (this.keyExprMap.values().stream().allMatch(te -> te.type.isPrimitive())) {
            return new SelectableColumn(){

                @Override
                public <T> T as(Class<T> clazz) {
                    if (NestedColumnTypeInspector.class.equals(clazz) || NestedColumnSelectorFactory.class.equals(clazz) || NestedVectorColumnSelectorFactory.class.equals(clazz) || NestedColumnIndexSupplier.class.equals(clazz)) {
                        return (T)new AsNestedColumn(columnSelector);
                    }
                    return null;
                }
            };
        }
        return super.toSelectableColumn(columnSelector);
    }

    public String toString() {
        return "NestedObjectVirtualColumn{name='" + this.getOutputName() + "', object=" + String.valueOf(this.keyExprMap) + "}";
    }

    public static class TypedExpression {
        private final String expression;
        private final ColumnType type;

        @JsonCreator
        public TypedExpression(@JsonProperty(value="expression") String expression, @JsonProperty(value="type") ColumnType type) {
            this.expression = (String)Preconditions.checkNotNull((Object)expression, (Object)"expression");
            this.type = (ColumnType)Preconditions.checkNotNull((Object)type, (Object)"type");
        }

        @JsonProperty
        public String getExpression() {
            return this.expression;
        }

        @JsonProperty
        public ColumnType getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypedExpression that = (TypedExpression)o;
            return Objects.equals(this.expression, that.expression) && Objects.equals(this.type, that.type);
        }

        public int hashCode() {
            return Objects.hash(this.expression, this.type);
        }

        public String toString() {
            return "TypedExpression{expression='" + this.expression + "', type=" + String.valueOf(this.type) + "}";
        }
    }

    class AsNestedColumn
    implements NestedColumnTypeInspector,
    NestedVectorColumnSelectorFactory,
    NestedColumnSelectorFactory,
    NestedColumnIndexSupplier {
        private final ColumnIndexSelector columnSelector;
        private final Map<String, VirtualColumn> keyColumnMap = new HashMap<String, VirtualColumn>();

        public AsNestedColumn(ColumnIndexSelector columnSelector) {
            this.columnSelector = columnSelector;
        }

        @Override
        public List<List<NestedPathPart>> getNestedFields() {
            ArrayList<List<NestedPathPart>> retVal = new ArrayList<List<NestedPathPart>>();
            for (String keyString : NestedObjectVirtualColumn.this.keyExprMap.keySet()) {
                retVal.add(Collections.singletonList(new NestedPathField(keyString)));
            }
            return retVal;
        }

        @Override
        @Nullable
        public Set<ColumnType> getFieldTypes(List<NestedPathPart> path) {
            if (path.isEmpty()) {
                return Set.of(ColumnType.NESTED_DATA);
            }
            TypedExpression typedExpression = this.getExpressionForPath(path);
            if (typedExpression != null) {
                return Set.of(typedExpression.type);
            }
            return Set.of();
        }

        @Override
        @Nullable
        public ColumnType getFieldLogicalType(List<NestedPathPart> path) {
            Set<ColumnType> fieldTypes = this.getFieldTypes(path);
            if (fieldTypes == null || fieldTypes.isEmpty()) {
                return null;
            }
            return fieldTypes.iterator().next();
        }

        @Override
        public boolean isNumeric(List<NestedPathPart> path) {
            ColumnType type = this.getFieldLogicalType(path);
            return type != null && type.isNumeric();
        }

        @Override
        public DimensionSelector makeDimensionSelector(List<NestedPathPart> path, @Nullable ExtractionFn extractionFn, ColumnSelectorFactory columnSelectorFactory, ReadableOffset readableOffset) {
            if (path.isEmpty()) {
                return NestedObjectVirtualColumn.this.makeDimensionSelector(DefaultDimensionSpec.of(NestedObjectVirtualColumn.this.getOutputName()), columnSelectorFactory, this.columnSelector, readableOffset);
            }
            TypedExpression typedExpression = this.getExpressionForPath(path);
            VirtualColumn vc = this.getVirtualColumnForExpression(path, typedExpression);
            if (vc == null) {
                return DimensionSelector.constant(null, extractionFn);
            }
            String key = path.get(0).getPartIdentifier();
            DimensionSpec dimensionSpec = extractionFn != null ? new ExtractionDimensionSpec(key, key, typedExpression.type, extractionFn) : DefaultDimensionSpec.of(key, typedExpression.type);
            return vc.makeDimensionSelector(dimensionSpec, columnSelectorFactory, this.columnSelector, readableOffset);
        }

        @Override
        public ColumnValueSelector<?> makeColumnValueSelector(List<NestedPathPart> path, ColumnSelectorFactory columnSelectorFactory, ReadableOffset readableOffset) {
            if (path.isEmpty()) {
                return NestedObjectVirtualColumn.this.makeColumnValueSelector(NestedObjectVirtualColumn.this.getOutputName(), columnSelectorFactory, this.columnSelector, readableOffset);
            }
            TypedExpression typedExpression = this.getExpressionForPath(path);
            VirtualColumn vc = this.getVirtualColumnForExpression(path, typedExpression);
            if (vc == null) {
                return NilColumnValueSelector.instance();
            }
            String key = path.get(0).getPartIdentifier();
            return vc.makeColumnValueSelector(key, columnSelectorFactory, this.columnSelector, readableOffset);
        }

        @Override
        public SingleValueDimensionVectorSelector makeSingleValueDimensionVectorSelector(List<NestedPathPart> path, VectorColumnSelectorFactory columnSelectorFactory, ReadableVectorOffset readableOffset) {
            if (path.isEmpty()) {
                return NestedObjectVirtualColumn.this.makeSingleValueVectorDimensionSelector(DefaultDimensionSpec.of(NestedObjectVirtualColumn.this.getOutputName()), columnSelectorFactory, this.columnSelector, readableOffset);
            }
            TypedExpression typedExpression = this.getExpressionForPath(path);
            VirtualColumn vc = this.getVirtualColumnForExpression(path, typedExpression);
            if (vc == null) {
                return NilVectorSelector.create(readableOffset);
            }
            String key = path.get(0).getPartIdentifier();
            return vc.makeSingleValueVectorDimensionSelector(DefaultDimensionSpec.of(key), columnSelectorFactory, this.columnSelector, readableOffset);
        }

        @Override
        public VectorObjectSelector makeVectorObjectSelector(List<NestedPathPart> path, VectorColumnSelectorFactory columnSelectorFactory, ReadableVectorOffset readableOffset) {
            if (path.isEmpty()) {
                return NestedObjectVirtualColumn.this.makeVectorObjectSelector(NestedObjectVirtualColumn.this.getOutputName(), columnSelectorFactory, this.columnSelector, readableOffset);
            }
            TypedExpression typedExpression = this.getExpressionForPath(path);
            VirtualColumn vc = this.getVirtualColumnForExpression(path, typedExpression);
            if (vc == null) {
                return NilVectorSelector.create(readableOffset);
            }
            String key = path.get(0).getPartIdentifier();
            return vc.makeVectorObjectSelector(key, columnSelectorFactory, this.columnSelector, readableOffset);
        }

        @Override
        public VectorValueSelector makeVectorValueSelector(List<NestedPathPart> path, VectorColumnSelectorFactory columnSelectorFactory, ReadableVectorOffset readableOffset) {
            if (path.isEmpty()) {
                return NestedObjectVirtualColumn.this.makeVectorValueSelector(NestedObjectVirtualColumn.this.getOutputName(), columnSelectorFactory, this.columnSelector, readableOffset);
            }
            TypedExpression typedExpression = this.getExpressionForPath(path);
            VirtualColumn vc = this.getVirtualColumnForExpression(path, typedExpression);
            if (vc == null) {
                return NilVectorSelector.create(readableOffset);
            }
            String key = path.get(0).getPartIdentifier();
            return vc.makeVectorValueSelector(key, columnSelectorFactory, this.columnSelector, readableOffset);
        }

        @Override
        @Nullable
        public ColumnIndexSupplier getColumnIndexSupplier(List<NestedPathPart> path) {
            if (path.isEmpty()) {
                return NestedObjectVirtualColumn.this.getIndexSupplier(NestedObjectVirtualColumn.this.getOutputName(), this.columnSelector);
            }
            TypedExpression typedExpression = this.getExpressionForPath(path);
            VirtualColumn vc = this.getVirtualColumnForExpression(path, typedExpression);
            if (vc != null) {
                return vc.getIndexSupplier(vc.getOutputName(), this.columnSelector);
            }
            return null;
        }

        @Nullable
        private TypedExpression getExpressionForPath(List<NestedPathPart> path) {
            if (path.isEmpty()) {
                throw DruidException.defensive("Empty path should be handled by the caller, not here.", new Object[0]);
            }
            if (path.size() > 1) {
                return null;
            }
            return (TypedExpression)path.get(0).find(NestedObjectVirtualColumn.this.keyExprMap);
        }

        @Nullable
        private VirtualColumn getVirtualColumnForExpression(List<NestedPathPart> path, @Nullable TypedExpression typedExpression) {
            if (typedExpression != null) {
                return this.keyColumnMap.computeIfAbsent(path.get(0).getPartIdentifier(), fieldName -> new ExpressionVirtualColumn((String)fieldName, typedExpression.expression, typedExpression.type, NestedObjectVirtualColumn.this.macroTable));
            }
            return null;
        }
    }
}

