/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.segment.ReferenceCountedObjectProvider;
import org.apache.druid.segment.Segment;

public class AcquireSegmentAction
implements Closeable {
    private final Supplier<ListenableFuture<ReferenceCountedObjectProvider<Segment>>> segmentFutureSupplier;
    @Nullable
    private final Closeable loadCleanup;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public static AcquireSegmentAction missingSegment() {
        return new AcquireSegmentAction(() -> Futures.immediateFuture(Optional::empty), null);
    }

    public AcquireSegmentAction(Supplier<ListenableFuture<ReferenceCountedObjectProvider<Segment>>> segmentFutureSupplier, @Nullable Closeable loadCleanup) {
        this.segmentFutureSupplier = segmentFutureSupplier;
        this.loadCleanup = loadCleanup;
    }

    public ListenableFuture<ReferenceCountedObjectProvider<Segment>> getSegmentFuture() {
        return this.segmentFutureSupplier.get();
    }

    @Override
    public void close() throws IOException {
        if (this.loadCleanup != null && this.closed.compareAndSet(false, true)) {
            this.loadCleanup.close();
        }
    }
}

