/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator.window.ranking;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.List;
import org.apache.druid.query.operator.window.ranking.WindowRankingProcessorBase;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.DoubleArrayColumn;

public class WindowCumeDistProcessor
extends WindowRankingProcessorBase {
    @JsonCreator
    public WindowCumeDistProcessor(@JsonProperty(value="group") List<String> groupingCols, @JsonProperty(value="outputColumn") String outputColumn) {
        super(groupingCols, outputColumn);
    }

    @Override
    public RowsAndColumns process(RowsAndColumns incomingPartition) {
        return this.processInternal(incomingPartition, groupings -> {
            double[] ranks = new double[incomingPartition.numRows()];
            for (int i = 1; i < ((int[])groupings).length; ++i) {
                int start = groupings[i - 1];
                int end = groupings[i];
                double relativeRank = (double)end / (double)ranks.length;
                Arrays.fill(ranks, start, end, relativeRank);
            }
            return new DoubleArrayColumn(ranks);
        });
    }
}

