/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.filter.DruidPredicateMatch;
import org.apache.druid.query.filter.LikeDimFilter;

public class LikeExprMacro
implements ExprMacroTable.ExprMacro {
    private static final String FN_NAME = "like";

    @Override
    public String name() {
        return FN_NAME;
    }

    @Override
    public Expr apply(List<Expr> args) {
        String escape;
        this.validationHelperCheckAnyOfArgumentCount(args, 2, 3);
        final Expr arg = args.get(0);
        Expr patternExpr = args.get(1);
        Expr escapeExpr = args.size() > 2 ? args.get(2) : null;
        this.validationHelperCheckArgIsLiteral(patternExpr, "pattern");
        if (escapeExpr != null) {
            this.validationHelperCheckArgIsLiteral(escapeExpr, "escape");
        }
        String string = escape = escapeExpr == null ? null : (String)escapeExpr.getLiteralValue();
        if (escape != null && escape.length() != 1) {
            throw this.validationFailed("escape must be null or a single character", new Object[0]);
        }
        Character escapeChar = escape == null ? null : Character.valueOf(escape.charAt(0));
        final LikeDimFilter.LikeMatcher likeMatcher = LikeDimFilter.LikeMatcher.from((String)patternExpr.getLiteralValue(), escapeChar);
        class LikeExtractExpr
        extends ExprMacroTable.BaseScalarMacroFunctionExpr {
            private LikeExtractExpr(List<Expr> args) {
                super(this$0, args);
            }

            @Override
            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                DruidPredicateMatch match = likeMatcher.matches(arg.eval(bindings).asString());
                if (match == DruidPredicateMatch.UNKNOWN) {
                    return ExprEval.ofLong(null);
                }
                return ExprEval.ofLongBoolean(match.matches(false));
            }

            @Override
            @Nullable
            public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                return ExpressionType.LONG;
            }
        }
        return new LikeExtractExpr(args);
    }
}

