/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.AggregateProjectionMetadata;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.utils.CollectionUtils;
import org.joda.time.DateTimeZone;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonTypeName(value="aggregate")
public class AggregateProjectionSpec {
    public static final String TYPE_NAME = "aggregate";
    private final String name;
    @Nullable
    private final DimFilter filter;
    private final VirtualColumns virtualColumns;
    private final List<DimensionSchema> groupingColumns;
    private final AggregatorFactory[] aggregators;
    private final List<OrderBy> ordering;
    @Nullable
    private final String timeColumnName;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String name) {
        return new Builder().name(name);
    }

    public static Builder builder(AggregateProjectionSpec spec) {
        return new Builder().name(spec.getName()).virtualColumns(spec.getVirtualColumns()).filter(spec.getFilter()).groupingColumns(spec.getGroupingColumns()).aggregators(spec.getAggregators());
    }

    @JsonCreator
    public AggregateProjectionSpec(@JsonProperty(value="name") String name, @JsonProperty(value="filter") @Nullable DimFilter filter, @JsonProperty(value="virtualColumns") @Nullable VirtualColumns virtualColumns, @JsonProperty(value="groupingColumns") @Nullable List<DimensionSchema> groupingColumns, @JsonProperty(value="aggregators") @Nullable AggregatorFactory[] aggregators) {
        if (name == null || name.isEmpty()) {
            throw InvalidInput.exception("projection name cannot be null or empty", new Object[0]);
        }
        this.name = name;
        if (CollectionUtils.isNullOrEmpty(groupingColumns) && (aggregators == null || aggregators.length == 0)) {
            throw InvalidInput.exception("projection[%s] groupingColumns and aggregators must not both be null or empty", name);
        }
        this.filter = filter;
        this.virtualColumns = virtualColumns == null ? VirtualColumns.EMPTY : virtualColumns;
        this.groupingColumns = groupingColumns == null ? Collections.emptyList() : groupingColumns;
        ProjectionOrdering ordering = AggregateProjectionSpec.computeOrdering(this.virtualColumns, this.groupingColumns);
        this.ordering = ordering.ordering;
        this.timeColumnName = ordering.timeColumnName;
        this.aggregators = aggregators == null ? new AggregatorFactory[]{} : aggregators;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public DimFilter getFilter() {
        return this.filter;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public VirtualColumns getVirtualColumns() {
        return this.virtualColumns;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public List<DimensionSchema> getGroupingColumns() {
        return this.groupingColumns;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public AggregatorFactory[] getAggregators() {
        return this.aggregators;
    }

    @JsonProperty
    public List<OrderBy> getOrdering() {
        return this.ordering;
    }

    @JsonIgnore
    public AggregateProjectionMetadata.Schema toMetadataSchema() {
        return new AggregateProjectionMetadata.Schema(this.name, this.timeColumnName, this.filter, this.virtualColumns, this.groupingColumns.stream().map(DimensionSchema::getName).collect(Collectors.toList()), this.aggregators, this.ordering);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregateProjectionSpec that = (AggregateProjectionSpec)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.filter, that.filter) && Objects.equals(this.groupingColumns, that.groupingColumns) && Objects.equals(this.virtualColumns, that.virtualColumns) && Objects.deepEquals(this.aggregators, that.aggregators) && Objects.equals(this.ordering, that.ordering);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.filter, this.virtualColumns, this.groupingColumns, Arrays.hashCode(this.aggregators), this.ordering);
    }

    public String toString() {
        return "AggregateProjectionSpec{name='" + this.name + "', filter=" + String.valueOf(this.filter) + ", virtualColumns=" + String.valueOf(this.virtualColumns) + ", groupingColumns=" + String.valueOf(this.groupingColumns) + ", aggregators=" + Arrays.toString(this.aggregators) + ", ordering=" + String.valueOf(this.ordering) + "}";
    }

    private static ProjectionOrdering computeOrdering(VirtualColumns virtualColumns, List<DimensionSchema> groupingColumns) {
        if (groupingColumns.isEmpty()) {
            return new ProjectionOrdering(List.of(), null);
        }
        ArrayList ordering = Lists.newArrayListWithCapacity((int)groupingColumns.size());
        String timeColumnName = null;
        Granularity granularity = null;
        for (DimensionSchema groupingColumn : groupingColumns) {
            VirtualColumn vc;
            Granularity maybeGranularity;
            ordering.add(OrderBy.ascending(groupingColumn.getName()));
            if ("__time".equals(groupingColumn.getName())) {
                if (!groupingColumn.getColumnType().is(ValueType.LONG)) {
                    throw DruidException.forPersona(DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).build("Encountered grouping column[%s] with incorrect type[%s]. Type must be 'long'.", groupingColumn.getName(), groupingColumn.getColumnType());
                }
                timeColumnName = groupingColumn.getName();
                break;
            }
            if (!groupingColumn.getColumnType().is(ValueType.LONG) || (maybeGranularity = Granularities.fromVirtualColumn(vc = virtualColumns.getVirtualColumn(groupingColumn.getName()))) == null || maybeGranularity.equals(Granularities.ALL)) continue;
            if (Granularities.NONE.equals(maybeGranularity)) {
                timeColumnName = groupingColumn.getName();
                break;
            }
            if (!maybeGranularity.getClass().equals(PeriodGranularity.class) || !maybeGranularity.getTimeZone().equals((Object)DateTimeZone.UTC) || ((PeriodGranularity)maybeGranularity).getOrigin() != null || granularity != null && !maybeGranularity.isFinerThan(granularity)) continue;
            timeColumnName = groupingColumn.getName();
            granularity = maybeGranularity;
        }
        return new ProjectionOrdering(ordering, timeColumnName);
    }

    public static final class Builder {
        private String name;
        private DimFilter filter;
        private VirtualColumns virtualColumns = VirtualColumns.EMPTY;
        private List<DimensionSchema> groupingColumns;
        private AggregatorFactory[] aggregators;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder filter(@Nullable DimFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder virtualColumns(@Nullable VirtualColumns virtualColumns) {
            this.virtualColumns = virtualColumns;
            return this;
        }

        public Builder virtualColumns(VirtualColumn ... virtualColumns) {
            this.virtualColumns = VirtualColumns.create(virtualColumns);
            return this;
        }

        public Builder groupingColumns(@Nullable List<DimensionSchema> groupingColumns) {
            this.groupingColumns = groupingColumns;
            return this;
        }

        public Builder groupingColumns(DimensionSchema ... groupingColumns) {
            this.groupingColumns = Arrays.asList(groupingColumns);
            return this;
        }

        public Builder aggregators(AggregatorFactory ... aggregators) {
            this.aggregators = aggregators;
            return this;
        }

        public AggregateProjectionSpec build() {
            return new AggregateProjectionSpec(this.name, this.filter, this.virtualColumns, this.groupingColumns, this.aggregators);
        }
    }

    private static final class ProjectionOrdering {
        private final List<OrderBy> ordering;
        @Nullable
        private final String timeColumnName;

        private ProjectionOrdering(List<OrderBy> ordering, @Nullable String timeColumnName) {
            this.ordering = ordering;
            this.timeColumnName = timeColumnName;
        }
    }
}

