/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.duty;

import com.google.inject.Inject;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.druid.indexing.overlord.duty.DutySchedule;
import org.apache.druid.indexing.overlord.duty.OverlordDuty;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutorFactory;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutors;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.common.logger.Logger;
import org.joda.time.Duration;

public class OverlordDutyExecutor {
    private static final Logger log = new Logger(OverlordDutyExecutor.class);
    private final ScheduledExecutorFactory execFactory;
    private final Set<OverlordDuty> duties;
    private volatile ScheduledExecutorService exec;
    private final Object startStopLock = new Object();
    private volatile boolean started = false;

    @Inject
    public OverlordDutyExecutor(ScheduledExecutorFactory scheduledExecutorFactory, Set<OverlordDuty> duties) {
        this.execFactory = scheduledExecutorFactory;
        this.duties = duties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        Object object = this.startStopLock;
        synchronized (object) {
            if (!this.started) {
                log.info("Starting OverlordDutyExecutor.", new Object[0]);
                for (OverlordDuty duty : this.duties) {
                    if (!duty.isEnabled()) continue;
                    this.schedule(duty);
                }
                this.started = true;
                log.info("OverlordDutyExecutor is now running.", new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.startStopLock;
        synchronized (object) {
            if (this.started) {
                log.info("Stopping OverlordDutyExecutor.", new Object[0]);
                if (this.exec != null) {
                    this.exec.shutdownNow();
                    this.exec = null;
                }
                this.started = false;
                log.info("OverlordDutyExecutor has been stopped.", new Object[0]);
            }
        }
    }

    private void schedule(OverlordDuty duty) {
        this.initExecutor();
        DutySchedule schedule = duty.getSchedule();
        String dutyName = duty.getClass().getSimpleName();
        if (schedule == null || schedule.getPeriodMillis() <= 0L) {
            log.info("Not scheduling overlord duty[%s] as it has no period specified.", new Object[]{dutyName});
            return;
        }
        ScheduledExecutors.scheduleWithFixedDelay((ScheduledExecutorService)this.exec, (Duration)Duration.millis((long)schedule.getInitialDelayMillis()), (Duration)Duration.millis((long)schedule.getPeriodMillis()), () -> {
            try {
                duty.run();
            }
            catch (Exception e) {
                log.error((Throwable)e, "Error while running duty[%s]", new Object[]{dutyName});
            }
        });
        log.info("Scheduled overlord duty[%s] with initial delay[%d], period[%d].", new Object[]{dutyName, schedule.getInitialDelayMillis(), schedule.getPeriodMillis()});
    }

    private void initExecutor() {
        if (this.exec == null) {
            boolean numThreads = true;
            this.exec = this.execFactory.create(1, "Overlord-Duty-Exec--%d");
            log.info("Initialized duty executor with [%d] threads", new Object[]{1});
        }
    }
}

