// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
suite("test_index_no_need_read_data", "inverted_index_select"){
    def table1 = "test_index_no_need_read_data"

    sql "drop table if exists ${table1}"

    sql """
       CREATE TABLE IF NOT EXISTS `${table1}` (
      `id` int NULL COMMENT "",
      `city` varchar(20) NULL COMMENT "",
      `addr` varchar(20) NULL COMMENT "",
      `name` varchar(20) NULL COMMENT "",
      `compy` varchar(20) NULL COMMENT "",
      `n` int NULL COMMENT "",
      INDEX idx_city(city) USING INVERTED,
      INDEX idx_addr(addr) using inverted properties("support_phrase" = "true", "parser" = "english", "lower_case" = "true"),
      INDEX idx_n(n) USING INVERTED
    ) ENGINE=OLAP
    DUPLICATE KEY(`id`)
    COMMENT "OLAP"
    DISTRIBUTED BY HASH(`id`) BUCKETS 1
    PROPERTIES (
    "replication_allocation" = "tag.location.default: 1",
    "in_memory" = "false",
    "storage_format" = "V2"
    )
    """

    sql """insert into ${table1} values
            (1,null,'addr qie3','yy','lj',100),
            (2,null,'hehe',null,'lala',200),
            (3,'beijing','addr xuanwu','wugui',null,300),
            (4,'beijing','addr fengtai','fengtai1','fengtai2',null),
            (5,'beijing','addr chaoyang','wangjing','donghuqu',500),
            (6,'shanghai','hehe',null,'haha',null),
            (7,'tengxun','qie','addr gg','lj',null),
            (8,'tengxun2','qie',null,'lj',800)
    """

    // case1: enable nereids planner
    sql """ set enable_common_expr_pushdown = true; """

    qt_select_nereids_0 "SELECT * FROM ${table1} ORDER BY id"
    qt_select_nereids_1 "SELECT count() FROM ${table1} WHERE n > 100"
    qt_select_nereids_2 "SELECT count() FROM ${table1} WHERE city = 'beijing'"
    qt_select_nereids_3 "SELECT count(*) FROM ${table1} WHERE city = 'beijing'"
    qt_select_nereids_4 "SELECT * FROM ${table1} WHERE city = 'beijing' ORDER BY id"
    qt_select_nereids_5 "SELECT city, addr, name FROM ${table1} WHERE city = 'beijing' ORDER BY id"
    qt_select_nereids_6 "SELECT addr, name FROM ${table1} WHERE city > 'beijing' ORDER BY city"
    qt_select_nereids_7 "SELECT addr, name FROM ${table1} WHERE city > 'beijing' ORDER BY id"
    qt_select_nereids_8 "SELECT upper(city), name FROM ${table1} WHERE city != 'beijing' ORDER BY id"
    qt_select_nereids_9 "SELECT length(addr), name FROM ${table1} WHERE city != 'beijing' ORDER BY id"
    qt_select_nereids_10 "SELECT addr, name FROM ( SELECT * from ${table1} WHERE city != 'beijing' ORDER BY id) t"
    qt_select_nereids_11 "SELECT addr, name, upper(city) FROM ( SELECT * from ${table1} WHERE city != 'beijing' ORDER BY id) t"
    qt_select_nereids_12 "SELECT sum(n) FROM ${table1} WHERE city = 'beijing' group by id ORDER BY id"

    def table2 = "test_index_no_need_read_data2"

    sql "drop table if exists ${table2}"

    sql """
       create table ${table2} (
       col_date_undef_signed_not_null date  not null  ,
       col_bigint_undef_signed_not_null_index_inverted bigint  not null  ,
       col_int_undef_signed int  null  ,
       col_int_undef_signed_index_inverted int  null  ,
       col_int_undef_signed_not_null int  not null  ,
       col_int_undef_signed_not_null_index_inverted int  not null  ,
       col_bigint_undef_signed bigint  null  ,
       col_bigint_undef_signed_index_inverted bigint  null  ,
       col_bigint_undef_signed_not_null bigint  not null  ,
       col_date_undef_signed date  null  ,
       col_date_undef_signed_index_inverted date  null  ,
       col_date_undef_signed_not_null_index_inverted date  not null  ,
       col_varchar_10__undef_signed varchar(10)  null  ,
       col_varchar_10__undef_signed_index_inverted varchar(10)  null  ,
       col_varchar_10__undef_signed_not_null varchar(10)  not null  ,
       col_varchar_10__undef_signed_not_null_index_inverted varchar(10)  not null  ,
       col_varchar_1024__undef_signed varchar(1024)  null  ,
       col_varchar_1024__undef_signed_index_inverted varchar(1024)  null  ,
       col_varchar_1024__undef_signed_not_null varchar(1024)  not null  ,
       col_varchar_1024__undef_signed_not_null_index_inverted varchar(1024)  not null  ,
       pk int,
       INDEX col_int_undef_signed_index_inverted_idx (`col_int_undef_signed_index_inverted`) USING INVERTED,
       INDEX col_int_undef_signed_not_null_index_inverted_idx (`col_int_undef_signed_not_null_index_inverted`) USING INVERTED,
       INDEX col_bigint_undef_signed_index_inverted_idx (`col_bigint_undef_signed_index_inverted`) USING INVERTED,
       INDEX col_bigint_undef_signed_not_null_index_inverted_idx (`col_bigint_undef_signed_not_null_index_inverted`) USING INVERTED,
       INDEX col_date_undef_signed_index_inverted_idx (`col_date_undef_signed_index_inverted`) USING INVERTED,
       INDEX col_date_undef_signed_not_null_index_inverted_idx (`col_date_undef_signed_not_null_index_inverted`) USING INVERTED,
       INDEX col_varchar_10__undef_signed_index_inverted_idx (`col_varchar_10__undef_signed_index_inverted`) USING INVERTED,
       INDEX col_varchar_10__undef_signed_not_null_index_inverted_idx (`col_varchar_10__undef_signed_not_null_index_inverted`) USING INVERTED,
       INDEX col_varchar_1024__undef_signed_index_inverted_idx (`col_varchar_1024__undef_signed_index_inverted`) USING INVERTED,
       INDEX col_varchar_1024__undef_signed_not_null_index_inverted_idx (`col_varchar_1024__undef_signed_not_null_index_inverted`) USING INVERTED
       ) engine=olap
       UNIQUE KEY(col_date_undef_signed_not_null, col_bigint_undef_signed_not_null_index_inverted)
       PARTITION BY             RANGE(col_date_undef_signed_not_null) (
                       FROM ('2023-01-01') TO ('2035-01-01') INTERVAL 1 YEAR
                   )

       distributed by hash(col_bigint_undef_signed_not_null_index_inverted) buckets 100
       properties("enable_unique_key_merge_on_write" = "true", "replication_num" = "1");
    """

    sql """INSERT INTO ${table2}(
               pk,
               col_int_undef_signed,
               col_int_undef_signed_index_inverted,
               col_int_undef_signed_not_null,
               col_int_undef_signed_not_null_index_inverted,
               col_bigint_undef_signed,
               col_bigint_undef_signed_index_inverted,
               col_bigint_undef_signed_not_null,
               col_bigint_undef_signed_not_null_index_inverted,
               col_date_undef_signed,
               col_date_undef_signed_index_inverted,
               col_date_undef_signed_not_null,
               col_date_undef_signed_not_null_index_inverted,
               col_varchar_10__undef_signed,
               col_varchar_10__undef_signed_index_inverted,
               col_varchar_10__undef_signed_not_null,
               col_varchar_10__undef_signed_not_null_index_inverted,
               col_varchar_1024__undef_signed,
               col_varchar_1024__undef_signed_index_inverted,
               col_varchar_1024__undef_signed_not_null,
               col_varchar_1024__undef_signed_not_null_index_inverted
           ) VALUES
           (0,-10,3,4,7,5580109438872025323,3872694526474684631,385420850865925584,-3940821135776863465,'2027-01-16','2025-06-18','2024-01-19','2024-01-17','v','a','r','p','j','i','k','v'),
          (1,1,6,-4,0,-1493194171885821015,7387138194313888736,3765212635902277035,7113302526071831680,'2023-12-18','2023-12-14','2023-12-12','2024-01-31','f','p','k','i','w',null,'x','n'),
          (2,6,3,4,7,3563852437963852520,8385106866914432959,4566306316897671779,6364576578692437612,'2023-12-13','2024-02-18','2023-12-13','2023-12-14','o','y','u','f','j','y','r','g'),
          (3,1,0,-4,2,-2254950510857437520,2491560902833588034,8217842243064941717,-921017394636829524,'2023-12-17','2023-12-10','2027-01-09','2023-12-14','m','q','x','t','y',null,'j','m'),
          (4,3,-10,4,-10,null,7628199607952032608,3197258099718089201,5763243269817274185,'2023-12-19','2024-02-18','2023-12-15','2024-01-17','d','a','a','d','n','i','r','k'),
          (5,8,0,-10,8,null,3581621927069206106,-9067180315701355776,-8841115213335077773,'2023-12-18','2023-12-19','2024-02-18','2023-12-11','u','l','n','i',null,'u','k','o'),
          (6,9,-10,-10,4,1923093018429459351,-5433098053895211168,-8967523672716182495,-4056723171560692598,'2023-12-18',null,'2023-12-17','2026-02-18','x','e','q','w','p',null,'f','m'),
          (7,7,4,6,0,-7445550386419643592,null,1648172906321291693,2621186248433016087,'2024-01-17','2024-01-19','2023-12-16','2025-02-18','k','r','a','m','d','n','t','a'),
          (8,-4,1,-4,7,1796634544229381107,-593463340620785966,5787209728812745054,-5485486542440665708,'2025-02-17','2027-01-16','2025-06-18','2024-02-18','l','q','h','o','t','u','a','m'),
          (9,9,1,3,9,null,4937075267478298592,-2273828918034758405,-8206180445681276242,'2025-02-18','2026-02-18','2024-01-17','2024-01-08','m',null,'q','a','q','d','c','w'),
          (10,6,8,8,-4,1207767175600440022,8847766271086933954,2323398854618204264,-493059712089143372,'2024-01-19','2023-12-18','2025-06-18','2024-01-08',null,null,'e','q','o','w','l','q'),
          (11,5,-4,7,7,-3469957288755596137,-2641830827441697431,-8760427991816018685,679645147777243519,'2023-12-14','2024-02-18','2024-01-19','2023-12-09','p','u','t','n','r',null,'j','q'),
          (12,0,1,-4,-4,-7894918345848500465,8680458589049247459,-8377225567607577955,6792164504588279227,'2023-12-09','2024-01-19','2026-02-18','2023-12-09','i','g','g','t','l','l','v','x'),
          (13,1,4,-10,2,4114705031219212601,null,-6177506599019385457,5138406382915390307,'2024-02-18','2025-06-18','2023-12-10','2024-01-09','t',null,'d','w','j','b','v','u'),
          (14,-4,-10,4,3,5975268122701547514,150994224860372313,-1146720549575812907,-7009122126858912431,'2023-12-18','2024-02-18','2023-12-11','2023-12-13','l','w','v','f',null,'q','p','s'),
          (15,1,1,-10,8,-3626135723208192188,519621184823112729,-7573705488022410893,494753102026856399,'2023-12-12','2024-01-09','2026-02-18','2023-12-14','d','l','o','h','u','j','j','s'),
          (16,-10,-10,1,2,null,null,-8398718839920683470,6038460101621662244,'2023-12-14','2027-01-09','2023-12-14','2027-01-16','p','d','v','i','o','z','z','o'),
          (17,9,1,4,-4,3413009869227781893,null,865249880237668165,2770415779455383989,'2023-12-15','2023-12-16','2023-12-16','2024-02-18','v','q','y','q','j','c','a','r'),
          (18,3,6,9,-10,8749385070419959986,-6987739797721157518,-134542821823440506,-746949899172342144,'2023-12-18','2026-01-18','2024-01-31','2024-01-17',null,'f','l','n','p','d','w','r'),
          (19,0,2,1,-10,-7413963880191969679,-7232501961520107253,-925106718320609612,3238785916731870616,'2024-02-18','2023-12-09','2024-02-18','2024-01-17','n',null,'r','r',null,'g','l','a'),
          (20,7,6,8,4,8651297646150639662,6018819133916644480,-136832000802503168,6608563689940337220,'2024-01-19','2024-01-09','2025-02-18','2024-02-18',null,'j','e','z','l','j','j','c'),
          (21,null,7,7,8,null,7850807104570290010,-2940201119327577321,-7782825355908730753,'2027-01-16','2023-12-12','2023-12-11','2023-12-09','r','v','h','l','t','c','s','y'),
          (22,0,3,8,-10,6483641277594834061,5272032945780194227,6721070633124742038,4480541256023769627,'2025-02-18','2025-02-17','2023-12-15','2025-06-18',null,'n','a','c','m','r','n','w'),
          (23,5,-4,9,3,1189711079190301419,-508728666249457767,-4796650213367800041,-2614767289707832609,null,'2023-12-17','2024-02-18','2024-02-18','j','p','n','u',null,'p','j','d'),
          (24,5,7,-4,9,708950585774598434,null,802903261902903991,5034268205269069810,'2023-12-10',null,'2025-06-18','2023-12-16','w',null,'i','g','q',null,'u','a'),
          (25,1,0,2,4,null,-8816502366270413322,-6246915445331697640,-22303848810465001,'2023-12-16','2023-12-11','2023-12-10','2024-02-18','b','t','p','t','w','a','t','j'),
          (26,null,0,8,5,5041704642941241381,-1040920583948735873,-3050904107661227848,3818438036241519364,'2023-12-15','2024-02-18','2023-12-18','2023-12-11','j',null,'b','w','g',null,'n','l'),
          (27,-4,5,5,0,-7110334501024778905,6139458997057859246,1952439230666743535,-1780860814160845957,'2023-12-18','2023-12-19','2024-02-18','2024-02-18','i','q','q','i','k','e','b','r'),
          (28,-10,1,1,-4,-1177929373235978167,1523584050471804610,1741710960961868858,2138613709760771252,'2023-12-15','2024-01-17','2023-12-19','2024-01-09','j','r','y','k','h','s','r','v'),
          (29,2,5,9,5,2151683970592511232,null,-9079195712293984833,-832946634936224763,'2024-01-31','2023-12-14','2024-01-31','2025-06-18','v','o','b','c','v','o','a','h'),
          (30,6,-4,3,-4,-5674973890990533864,-7930103893991073675,-8695393871765917570,8423605879288969451,'2026-01-18','2023-12-18','2026-01-18','2023-12-16','j',null,'k','f','n','c','h','m'),
          (31,-10,null,7,-4,-8613191708658642580,4643025050848756677,-2938926314298340928,-3268125550911659026,'2027-01-09','2023-12-13','2024-01-31','2027-01-16','o','u','v','y','s','e','k','d'),
          (32,4,1,6,-10,-3780476841982360554,-1465800917874352047,-8040569538841136543,-2850720971377524729,'2023-12-17','2025-02-17','2023-12-17','2025-06-18','g','s','l','k','q','o','v','y'),
          (33,null,null,4,6,-7859842309046606373,6339293308146092664,1353722378411931780,-4351109131638306369,'2023-12-13','2027-01-16','2023-12-17','2023-12-10','i','v','r','p','p','p','s','m'),
          (34,null,6,5,-10,775460194850212355,-857318101479980273,5707726219311668064,-8156298623103687698,'2025-06-18','2024-01-17','2024-02-18','2023-12-19','v','k','b','y','u','j','m','d'),
          (35,4,2,3,8,null,7869433062326420427,8577575012653028053,-2427932731456201896,null,'2025-02-17','2023-12-15','2023-12-13','n','w','g','x','n',null,'t','v'),
          (36,1,5,3,-4,-4052850329707382806,null,3543852552281280328,144459604708779398,null,'2023-12-17','2023-12-18','2023-12-15','u','u','v','w',null,'c','r','h'),
          (37,2,-4,-10,-4,3308439093289595569,-4576595019875335985,-5027502052563641731,-1153136184101431003,'2025-06-18','2023-12-14','2023-12-14','2024-01-17','l','r','y','g','q','u','p','s'),
          (38,5,5,5,7,7739062077873814633,-4392780353883175471,7718546622414071889,4784376271820034871,'2023-12-11',null,'2023-12-17','2024-01-08','c','m','v','r',null,'y','o','c'),
          (39,2,null,4,-10,null,null,-7091181624443389952,-1523182598015545283,'2023-12-19','2024-01-09','2023-12-17','2023-12-10',null,null,'g','y','l','r','b','s'),
          (40,null,null,8,8,-3850458026233780339,null,-2224370480099152990,986150044629816420,null,'2023-12-09','2024-01-08','2024-02-18',null,'f','l','h',null,'h','u','t'),
          (41,4,0,-10,2,-8548018030627515877,-526825220301930369,-6837214598909243203,-71495819606874989,'2024-01-17','2023-12-10','2023-12-20','2024-02-18','p','b','g','l','e','p','e','d'),
          (42,6,null,9,7,5247818117274871825,7662842062297160632,4736712239946555003,-8777028431175216502,'2024-01-17','2023-12-17','2026-01-18','2023-12-16','b','f','l','v','b','x','t','j'),
          (43,0,4,1,-4,-7323463697237377652,8359987866596815795,-7696667293877334704,7282058073097594290,'2025-06-18',null,'2023-12-12','2024-01-31',null,'u','f','g','z','e','y','u'),
          (44,-10,0,-10,0,-8774736825980139716,-9087949559314091146,8169500708930581350,-6260433878840298875,'2024-01-08','2026-01-18','2023-12-19','2023-12-15','k','f','c','m','e','g','t','z'),
          (45,null,-10,3,0,null,null,-5113884651055394008,8725402168887851060,'2023-12-13','2023-12-16','2023-12-14','2025-02-17','j',null,'l','t','t','o','b','g'),
          (46,4,1,8,-10,null,-6531952254536753998,-2924421668465251732,-2194652303765193023,'2025-06-18','2025-02-17','2025-02-18','2026-01-18','q','b','i','z',null,'l','t','k'),
          (47,8,-4,0,7,null,3432780964748477613,-7132177230817155428,1182857722110673405,'2023-12-10','2023-12-17','2023-12-19','2026-02-18',null,'f','n','r','u','j','r','m'),
          (48,2,8,6,-10,3402707501095389317,1751756224480974842,6398935893076763254,-6870988324470664552,'2027-01-16','2026-02-18','2023-12-19','2024-01-19','i','w','n','m','q','g','a','q'),
          (49,-4,6,8,0,5486551107215099612,null,-7473782296902431420,-5989367996030108585,'2026-01-18','2024-01-09','2023-12-18','2024-02-18','a',null,'u','w','u',null,'n','u'),
          (50,1,-10,8,1,null,9044941427856703516,5718792231868237169,1904082734065935159,'2023-12-16','2025-06-18','2026-02-18','2023-12-11','z','m','h','p',null,'j','b','h'),
          (51,-4,2,2,0,null,-1652297780041170740,9092511863605571992,3093074109783760178,'2023-12-14','2023-12-18','2024-01-08','2024-02-18','c',null,'p','a','m','o','h','f'),
          (52,-10,1,-4,2,null,-52118520912539584,-2467154476596439436,-1591502250087705128,'2027-01-16','2027-01-16','2027-01-09','2027-01-16','s','m','q','c','b','d','r','c'),
          (53,7,7,-10,8,-6050148469337645927,-6422535335041660441,5264504826379740805,-1085407954320820018,'2023-12-17',null,'2023-12-10','2024-02-18',null,'x','i','u','b','u','r','h'),
          (54,5,8,-4,-10,7459039506829897451,6705880834090083493,-3670400590756658462,-4273060761760940983,'2027-01-16','2024-02-18','2024-01-17','2023-12-14','j','b','n','c','i','z','s','t'),
          (55,-4,-4,2,-4,4855319502460373472,-3126360002573475203,-68729602730082495,3151378913823921708,'2023-12-14','2027-01-09','2024-02-18','2025-02-17','g','e','a','c','w','v','a','p'),
          (56,0,null,3,9,5469091841836564344,-8913501729070845008,6788025520372211892,-1616745350959302522,'2023-12-09','2025-06-18','2024-02-18','2023-12-14','n','t','x','f','d','p','p','n'),
          (57,4,null,-10,1,-1563000628155557629,-862763319942031476,-7432897080628302644,3414999754266286323,'2024-02-18',null,'2023-12-13','2024-01-08','n','z','l','y',null,'i','p','r'),
          (58,1,-10,1,-10,705526106102345691,8224284170341160115,-8671548728855377707,8978322568246121698,'2023-12-13','2024-02-18','2025-02-17','2023-12-18','q',null,'f','e','e',null,'h','i'),
          (59,1,5,8,4,-2904484111886589501,4401239845001785918,-6282784812051737836,-6239511645700996554,'2023-12-09','2023-12-09','2023-12-13','2024-02-18','o','v','d','x','e','c','r','q'),
          (60,1,-10,-10,9,1248425082513772119,null,8859106197807815796,-4988233320410560113,'2025-02-17','2024-01-08','2025-02-17','2025-02-18','s','a','q','m','e','s','v','n'),
          (61,1,7,3,6,-7483005358344115127,-1139236728514143791,1429496785723455224,-4306427359310612465,null,null,'2023-12-15','2025-02-17','x',null,'d','j','y','x','h','o'),
          (62,5,8,7,1,-3104735154314378273,-8395798987915934069,-7982736207736198304,7011986936356258894,'2023-12-12','2024-02-18','2023-12-17','2025-06-18',null,'q','h','e','u','k','v','g'),
          (63,null,-10,2,6,-4271504123822900473,566092902144643066,4749120337344719401,8163272629722250560,'2024-01-17','2023-12-18','2024-01-31','2023-12-17','d',null,'w','m',null,'v','y','b'),
          (64,null,-10,5,-10,-4592552003439471292,-1451345462844358401,-2010580602144950162,-1134972326059249542,'2023-12-20','2024-01-08','2023-12-13','2023-12-09','b',null,'u','v','o','v','t','v'),
          (65,6,9,-10,8,null,-6621292092609311401,4238756076966657595,-2473189958578814158,null,'2023-12-17','2023-12-14','2024-02-18','h','x','q','r','w',null,'z','m'),
          (66,8,null,-4,3,-1129208833673349302,2107615842277768095,6264382583683275445,7431295579919957544,null,'2023-12-09','2026-01-18','2025-06-18','y','k','r','d',null,'p','i','o'),
          (67,3,5,1,-4,-6674906368771292737,-4714909078995860171,-694606630357981501,2056794120664778888,'2023-12-09','2025-02-17','2024-02-18','2023-12-11','l',null,'g','d','q','g','y','c'),
          (68,6,0,-10,1,6421608748716099689,-6420232743727631483,-5027341321206369030,-8047447049344425122,'2024-01-19','2023-12-13','2025-06-18','2023-12-18',null,'d','l','q','y','r','z','w'),
          (69,-4,-4,-10,2,null,-5596432443330502176,72306968755123630,-5958628508439113044,'2023-12-12','2025-06-18','2023-12-09','2023-12-10','x','g','t','m',null,null,'c','v'),
          (70,7,1,-10,-4,6992919153400584793,null,1353783002907846353,-5152302836273005942,'2024-01-19','2023-12-12','2024-01-19','2024-01-19',null,'c','p','e','t','c','p','g'),
          (71,7,0,2,7,null,-8684271386152979594,3233214622962490768,8179162928591451395,'2025-02-18',null,'2025-06-18','2023-12-19','i','u','q','g','g','t','u','l'),
          (72,8,5,-4,-4,8023833669625596957,-2175811755314296797,8273820027333341012,-7561803641363713877,'2023-12-17','2023-12-11','2025-02-18','2023-12-16','k',null,'n','i','v','f','x','r'),
          (73,null,null,4,7,8097971023770222543,null,6847610491507492007,-248447702232261375,'2026-02-18','2024-01-08','2023-12-19','2026-02-18','g','m','k','r','s','m','o','j'),
          (74,-4,null,4,-10,3831989339160695519,-8524697687236665725,-4718672348796081091,2770443942158142445,'2024-02-18','2023-12-17','2026-01-18','2024-01-08','f','f','y','b',null,'m','r','m'),
          (75,-4,2,0,7,null,4959953926979696845,3486608622464080794,-3229317567443887999,'2023-12-14','2027-01-09','2023-12-17','2027-01-09','v','f','w','r',null,null,'q','b'),
          (76,2,-4,-4,2,-601652204721465653,-3212752196133020786,5990606691349434570,-5949271236111832329,'2023-12-09','2024-02-18','2023-12-17','2024-01-19','m','q','x','o',null,'l','g','f'),
          (77,-4,-10,-4,9,3655074239162198459,5189205617498229776,-6518420188701451360,5337606984188054445,'2023-12-10',null,'2023-12-19','2025-02-17','p',null,'j','e','t','a','n','a'),
          (78,-10,9,-10,3,9122168885603966206,6448663440965666822,3372934569284931400,7574495481147792550,null,null,'2023-12-16','2026-01-18','v','x','w','u',null,'c','h','m'),
          (79,-10,4,2,4,1031010101330880152,null,-663567195363937482,-3723694315710801677,'2025-02-18','2023-12-09','2023-12-09','2024-02-18','x',null,'d','s',null,null,'i','e'),
          (80,-4,-4,-4,-10,-860805994236637848,1353988761359803557,8933620360636954498,975751778872136323,'2024-01-09',null,'2024-01-09','2024-02-18','w','e','k','u','g','h','f','k'),
          (81,-10,-4,3,3,6343717446741286985,3019062611073886538,-2947234371040941148,-3140400579276155811,'2027-01-09','2024-01-17','2024-02-18','2027-01-16','v','l','x','m',null,null,'r','w'),
          (82,6,null,-4,1,null,-4998553068568552704,5258188475370747831,785490117157375299,'2024-01-09','2023-12-16','2024-01-19','2024-01-09','x','x','a','b',null,'a','x','m'),
          (83,2,0,-4,-10,-1247191244278730004,-8661164724725903678,7750833324080233471,3775784822365635910,'2024-02-18','2024-01-17','2023-12-13','2023-12-10','x','y','b','x','u','s','k','d'),
          (84,2,9,-10,4,-817858363160312975,-6307225941795055746,2777452333765506049,7606287144502601088,'2025-02-17','2025-06-18','2023-12-20','2023-12-19',null,null,'l','w',null,'b','q','o'),
          (85,3,6,3,1,-3335909153779002796,-2216409861500764748,3000962396131195310,-4606005732372915357,'2024-01-17',null,'2025-02-18','2025-02-17','d','h','n','o','u','o','o','y'),
          (86,7,7,7,3,null,null,177000028736781102,-4500482738673885249,null,'2023-12-13','2024-01-08','2023-12-09','c','a','v','p',null,'l','e','o'),
          (87,1,6,1,3,-8849844482902436466,null,-1399043876332577010,-6205355923329386507,'2023-12-15','2023-12-15','2023-12-11','2023-12-19','a','f','v','o','m',null,'n','x'),
          (88,-10,9,2,7,-4142094149740485178,-6097600667195297942,-7736360815770084520,1137542737768894954,null,'2026-02-18','2023-12-16','2023-12-11','x',null,'m','c','k','k','v','y'),
          (89,null,-10,3,4,5230502337072618230,-5604843245718539955,-4145483474992550386,-7766088395904457482,'2026-01-18','2025-06-18','2025-06-18','2023-12-15','v','i','x','s',null,null,'j','e'),
          (90,-4,null,-4,4,-3303845190780727617,4977491131663868126,-4238194913226948570,7085770928368876512,'2023-12-16','2023-12-20','2024-01-17','2023-12-18',null,'a','g','i','o','j','j','w'),
          (91,2,-4,6,-10,8142670228898751158,-8269778573449278132,5247255187446357862,-7150795204924087206,'2026-01-18','2023-12-19','2024-01-08','2023-12-19','e','q','h','l','z','g','h','y'),
          (92,8,2,-10,-10,8246365030697052702,null,1832518927452710569,213124874328504406,'2023-12-18','2026-02-18','2023-12-11','2023-12-10','q','d','z','w','l',null,'a','e'),
          (93,-4,-4,8,-10,7561272305027437460,-7647150958656616571,-2676635155700154238,-4522007691342264526,'2025-06-18','2025-06-18','2024-01-17','2025-02-17',null,'n','f','d','d','d','y','n'),
          (94,-10,0,3,-10,-5605747574229168194,5182475087931900109,-8309333835210543607,9186292896916463476,'2023-12-09','2026-02-18','2023-12-09','2026-02-18','u','e','x','w','o','k','n','z'),
          (95,6,1,-4,-10,-5252194964165933147,-1746773078673780213,6170198878190586183,-7294735841376118696,'2024-01-09','2025-06-18','2025-06-18','2023-12-19','r','f','t','d',null,'v','k','q'),
          (96,-10,8,9,-10,-6066911064423874486,null,3634168368389506356,3822346680227396148,'2023-12-10','2027-01-09','2023-12-18','2026-02-18','p','t','v','u','y','c','x','e'),
          (97,8,3,-4,3,6175671587580785704,5906494686057356739,-1967425206976655863,-3925705760640524442,'2023-12-16','2023-12-17','2024-02-18','2024-02-18','i','q','k','a','s','z','j','m'),
          (98,8,9,6,8,7411169187348677028,7449414531536242146,-8699252498301697283,-8174321010282471216,'2023-12-18','2023-12-14','2027-01-09','2026-01-18','m','b','z','i','c','e','h','d'),
          (99,-4,0,0,5,null,-1176464926279906122,-4999489278190558824,2571407554977584849,'2023-12-18','2024-01-09','2023-12-17','2024-02-18','z','b','h','r',null,null,'x','t'),
          (100,8,8,8,-4,-3468322257390679547,null,-7914808819562923788,5408223112330809542,'2027-01-09',null,'2023-12-12','2024-01-08','c','x','a','g','o','i','i','u'),
          (101,5,0,8,3,null,-8813549542765202970,-9177655225414804101,2059236470159210950,'2023-12-10','2023-12-20','2023-12-13','2023-12-15','w','p','f','k','r','q','s','z'),
          (102,0,2,-10,9,4085346460992124148,2034777159334372255,-8862747378171119929,-703955865726407353,'2027-01-09',null,'2025-02-18','2023-12-12','j','l','w','y','b','g','e','u'),
          (103,null,2,-4,2,-8759596790358056076,-2332782672358919128,-1015833249060432998,2831574326561352249,'2025-06-18','2023-12-20','2023-12-09','2023-12-13','p','l','d','x','s','h','s','v'),
          (104,0,7,4,7,null,null,-5815230959973118916,-1420422137631498908,'2025-06-18','2023-12-11','2024-01-31','2024-01-08','w','l','y','t','d','k','n','g'),
          (105,0,null,-10,1,2010086610127544661,-4323005608867325730,-990710261784582107,3731689068705537185,null,'2025-06-18','2023-12-19','2023-12-16','w','b','y','c','y',null,'y','b'),
          (106,-10,-4,-10,1,-2094359095540169494,-2152661011165469751,-407651042626345601,7498060011104870144,'2023-12-09','2023-12-16','2023-12-10','2025-02-18',null,'d','j','a','n','o','w','c'),
          (107,-10,-4,7,-4,-3196471327621740923,null,-5572610269276461502,3315068851942396190,'2023-12-11','2023-12-18','2023-12-10','2024-01-08','g','k','q','p','s','n','w','g'),
          (108,4,-10,6,3,-3057042597962031632,null,-2159449737025884731,-1551590702287364467,'2024-02-18','2023-12-13','2025-06-18','2023-12-20',null,'a','q','e',null,null,'r','m'),
          (109,8,4,3,2,null,-4987003599701071002,-1717431060201734552,-1048790362343573455,'2024-01-09','2025-02-17','2024-01-19','2023-12-10',null,null,'v','u','p','a','y','e'),
          (110,8,null,-10,-10,-1842829307815004845,null,1415732896595163275,-6310236724918690102,'2026-02-18','2024-01-19','2023-12-13','2023-12-16',null,'g','u','i','p','p','l','x'),
          (111,6,1,6,0,null,6312305928520220483,3365460910283453490,-3878367957383772837,'2026-02-18','2023-12-11','2023-12-17','2027-01-16','s','q','x','v','j','k','m','p'),
          (112,-4,-10,-10,7,2380400422889424409,1963876330439667216,-5836681077839021771,2440060790583499390,'2025-06-18',null,'2025-02-17','2025-02-17','l','m','v','f',null,'e','g','s'),
          (113,7,null,1,7,-2195405805986914490,4625229358937058763,6033163783549986017,4925074000933733104,null,'2025-06-18','2023-12-17','2023-12-16','k','o','d','d',null,'r','v','k'),
          (114,-10,-10,0,7,6062034195118399521,null,-5411852481933751178,-1987885979907256937,'2024-01-31','2026-01-18','2023-12-13','2023-12-19','t','r','s','o',null,'g','v','e'),
          (115,3,8,7,-4,-9127380289294619156,null,8385668391800796597,7590579961023582879,'2027-01-09','2023-12-17','2024-01-09','2023-12-15','o','p','b','v','e',null,'m','i'),
          (116,7,null,2,-4,-2466262211293807333,null,7128035713146149079,7959758184035771043,'2024-01-09','2023-12-14','2027-01-09','2023-12-18','z','y','c','c','f',null,'j','q'),
          (117,6,-4,-4,9,null,null,-426646984630556550,-1543674850997323049,'2025-06-18',null,'2023-12-11','2023-12-12','o','t','l','t','o','i','s','i'),
          (118,9,3,-4,-4,5551171659862319657,-3857396517970182822,-3381220542530874582,211502040570616805,'2024-01-08','2025-06-18','2023-12-18','2024-01-08','k','s','k','w',null,'i','p','f'),
          (119,-4,null,-4,2,-4036771036354371373,-5268121176736020103,-9202777940063920441,-643910676728604631,'2024-02-18','2024-01-09','2025-02-18','2024-01-17',null,'r','e','v','i','e','u','r'),
          (120,3,8,9,7,-2566318575293129968,1686940761033910913,-2724417428267777664,4374420777915789928,'2023-12-14','2023-12-11','2023-12-15','2024-01-17','h','u','w','m','m','x','d','h'),
          (121,-10,null,6,-4,1582635592543553185,-5137311020664757410,-8579259002422505432,-4363425453047660885,null,'2027-01-16','2023-12-13','2023-12-14',null,'u','x','r','k','x','v','c'),
          (122,-10,-10,8,5,-6275920676345321947,null,6524024749956657019,-1351204623156774281,'2023-12-10','2025-02-18','2023-12-15','2024-01-17',null,'g','v','i',null,'h','p','g'),
          (123,-4,9,-4,-10,-1866034129886413284,null,7284798450703536860,-7983828394429691706,'2023-12-12','2027-01-09','2027-01-16','2023-12-20',null,'e','r','x','b','v','x','y'),
          (124,2,9,-4,5,-7818897807961738922,6256387471948154897,2585605500478691817,-7881817626914286092,'2025-06-18','2025-06-18','2025-06-18','2023-12-20','s','t','e','p',null,'e','y','a'),
          (125,7,4,0,8,-2442289570598034323,3017714704247177402,-8372809352945300223,1070629302200695167,'2023-12-15','2023-12-13','2023-12-16','2024-02-18','j','w','m','h','u',null,'t','a'),
          (126,1,9,2,2,8214142431338730982,3660411019939881762,-1748525699378068112,4234719550387624842,null,'2024-01-09','2023-12-20','2024-01-19','z','j','e','m','c','c','u','d'),
          (127,8,null,-10,-4,-6183774203945608554,1403931482337460752,5497335773114954423,-7041936107758949139,'2026-02-18','2027-01-09','2023-12-17','2023-12-09','e',null,'v','z','m','y','n','p'),
          (128,-4,null,-10,-10,-3527043394788989841,null,-1893599763259313250,6319421229044889007,'2024-02-18','2026-01-18','2024-02-18','2023-12-16','c','y','d','i','i',null,'t','y'),
          (129,4,-4,-10,-4,5232732513450445011,-717919705972489917,-5411752723532127668,-5349655480732064818,'2023-12-14','2024-02-18','2024-01-31','2025-02-18',null,null,'x','c','x','v','y','j'),
          (130,null,1,5,4,-6523085183793426429,-9012193721486509069,-2202067684543775504,-3985855344706264884,'2024-02-18','2025-06-18','2023-12-11','2023-12-10','x','h','w','o','h','a','a','t'),
          (131,-4,3,-4,1,null,null,6198358310085909087,-928590921314043929,'2023-12-16','2024-01-09','2024-01-17','2024-02-18',null,'k','e','w','u','d','g','z'),
          (132,-4,0,8,1,6689827572124436012,4916969215813697399,1578149663472949380,6637733286044673649,null,'2025-06-18','2023-12-19','2023-12-20','y','z','r','a','e','v','x','c'),
          (133,1,-10,6,4,-1297985777428861579,-990447532556969907,6114555769592170501,-1251536506876371467,null,null,'2025-06-18','2025-02-18',null,'x','z','z','q',null,'f','d'),
          (134,9,7,3,0,null,-2574806983372047749,7782943546456622685,1784068357887003432,'2025-02-18','2024-01-08','2024-01-17','2024-02-18','v','s','c','f','a','i','q','w'),
          (135,null,3,3,4,null,-6402238570222527588,456985212413588060,-6324642629429883775,'2023-12-16','2023-12-12','2023-12-10','2026-02-18','e',null,'u','q','x','z','p','i'),
          (136,0,1,4,-4,9165440537890266026,-3368696524456875625,1834670262686358570,7159488295151947092,'2024-01-08',null,'2024-01-19','2025-06-18','f',null,'r','u','p','n','g','q'),
          (137,9,0,-10,2,5825564402002529715,5916583003766254161,308486195639949801,-3084124640868354155,'2023-12-18','2023-12-11','2025-02-17','2023-12-13','u','q','u','q','n',null,'s','m'),
          (138,2,-10,3,-10,null,null,-7906028525213830822,7768974004381159295,'2023-12-12','2024-01-17','2024-01-19','2024-02-18','s','u','a','d','x','i','v','m'),
          (139,4,null,6,3,-1087205098158704253,null,6117774810699553195,5528899066049683102,'2023-12-11','2023-12-12','2023-12-14','2026-01-18',null,'k','l','u','t',null,'h','s'),
          (140,9,-10,7,7,6895235116122591997,6655789171345214492,7435979442397054614,3271248940660667682,'2023-12-18','2024-01-17','2023-12-14','2023-12-14','a','t','f','k','y','x','k','n'),
          (141,-4,-10,-4,0,null,1550572088109129759,2922425330446401892,-3292062204666000685,'2024-01-09','2027-01-09','2023-12-15','2026-01-18',null,'s','v','m',null,'u','a','w'),
          (142,4,-4,-4,2,3750738797310752802,482495131642894924,-1803133122874943468,-5560828149916351177,'2024-02-18','2023-12-20','2024-02-18','2023-12-19','g','u','u','v','t','z','i','l'),
          (143,-10,-10,5,-4,3752175362923346376,null,9070358245968329102,979478163667151368,'2023-12-17','2023-12-15','2023-12-12','2026-01-18','j','b','f','j','e','l','v','q'),
          (144,5,null,-10,5,-7578858516067052196,5296737221140370249,-4036183011311068274,6564252036481980570,'2024-02-18','2024-01-08','2026-02-18','2023-12-19','f',null,'b','b','d','k','z','s'),
          (145,7,null,-10,-10,-2801905559410385260,-5825383618332418622,-8578446262558777713,7659245641813351104,'2023-12-16','2025-06-18','2024-02-18','2026-02-18','c','k','y','j',null,'j','p','g'),
          (146,null,null,5,0,3107760972522643704,null,7134018890318340647,-6320590865572550487,null,'2024-02-18','2024-01-09','2025-02-18','f','w','r','f','n','l','x','s'),
          (147,4,null,-10,8,1846616948654222483,-6412906185260906202,-6731263606855662025,6990855464391374757,'2023-12-15','2023-12-19','2023-12-20','2024-01-19','y','q','r','h','m','f','x','f'),
          (148,null,-4,-4,8,-7453357553846742813,1378835603755975964,-5266233497248044403,-9186504589591711117,'2027-01-16','2025-06-18','2023-12-12','2023-12-17',null,'m','y','r','q','j','v','u'),
          (149,-4,null,8,8,null,null,-2034921767147130207,5520873100977820520,'2024-01-19','2023-12-15','2024-02-18','2024-02-18','q','l','k','z','d','n','u','v'),
          (150,-4,6,4,8,-8093623869105529860,-8931801690014246778,-4084430254900686932,2180092529716307520,'2024-01-08','2023-12-16','2024-02-18','2027-01-09','n','p','w','v','t',null,'b','g'),
          (151,1,5,9,6,-3511936494211303764,2576411238581044414,-2081336023618431624,-6760879733264571615,'2024-01-19','2027-01-09','2023-12-18','2023-12-16',null,'u','z','o','c','i','r','b'),
          (152,null,-4,5,2,-5017752096013630944,null,4195060556751701629,-6421314757947568106,'2026-01-18','2023-12-09','2023-12-13','2024-01-17',null,'o','h','o','e','w','p','m'),
          (153,2,-10,6,-4,3067828230092317486,-6599453705016579907,-9169029376106860745,6781630600285070443,'2023-12-20','2024-01-09','2024-02-18','2023-12-13','z',null,'p','z','u','g','a','v'),
          (154,-10,-4,6,6,4180562161029377651,null,6271979755251634149,-6624217891779638671,null,'2023-12-16','2025-02-18','2023-12-20','o','l','w','h',null,'h','e','n'),
          (155,1,-4,-10,0,-7767798817892634820,5782113845303121502,4207969927461612633,2877262173140503308,'2023-12-09','2024-01-17','2024-02-18','2024-01-31','z','z','o','w','q','v','j','q'),
          (156,-10,6,0,-4,null,-5789953689294652033,102245250334180744,3755119803480784046,'2023-12-14','2023-12-10','2025-06-18','2023-12-17','e','d','y','w','a','c','z','u'),
          (157,8,6,0,-10,-5238309315680282118,-5707254004425303637,3323831776166491524,7139867243097082268,null,'2023-12-14','2023-12-15','2024-01-09',null,'b','e','c','r','h','y','b'),
          (158,null,9,9,1,-5349953513329428835,4403185441047693129,932185000913135760,-1992306805009575326,'2024-01-09','2023-12-18','2025-06-18','2024-02-18','u','i','d','d','t','t','y','r'),
          (159,6,5,-4,-10,3313378859261499127,-7584248478502122376,5760207207702292339,-8987355841581094337,'2026-02-18','2026-01-18','2023-12-19','2024-01-17',null,null,'l','e','c','d','n','u'),
          (160,2,null,7,2,-5498266611850349156,6917745080484487592,-2805323606048046980,1216391667383278497,'2024-01-19','2024-02-18','2023-12-16','2026-01-18','e',null,'e','z','m','a','b','x'),
          (161,6,-4,3,4,-1876263858946146628,-6615460033503337367,-5100038927409331460,8250232565082127255,'2027-01-16','2024-02-18','2024-02-18','2023-12-10','c','b','k','a','r','l','e','b'),
          (162,4,null,-10,9,null,2546849170385649215,8324132647242971653,-7895309615378665473,'2023-12-13','2023-12-16','2025-06-18','2024-02-18','t',null,'p','i','s','d','s','r'),
          (163,5,null,-4,6,-685494335523908835,null,-834712794866661570,-1950489445402007616,'2025-06-18','2024-01-31','2027-01-16','2023-12-11','c','o','u','k','l','k','j','p'),
          (164,-4,4,8,-4,4002375995713095002,-4571185357674435246,-208187264117144629,-2321648468360330025,'2023-12-09','2025-06-18','2024-01-09','2025-06-18',null,'q','d','b','t','o','y','v'),
          (165,-4,7,-4,0,-6278901807472071584,-3313854966455205400,-8085051633312104550,-3109207519938755775,'2026-02-18','2024-02-18','2023-12-09','2023-12-14','r','c','b','j',null,'a','h','y'),
          (166,null,-4,-10,6,-8361792768864825077,-1084162764304274919,-479780499589336666,-1129407620705531893,'2026-02-18','2023-12-13','2024-01-17','2023-12-19',null,null,'g','g','r',null,'j','c'),
          (167,-10,4,9,5,null,null,3951522919893940804,-8332023418620028762,'2024-02-18','2023-12-09','2027-01-09','2023-12-14',null,'d','g','v',null,'w','h','f'),
          (168,-4,9,3,8,1529777499214360074,-6997887526651843542,-8458231178492141089,3840372226716160967,null,'2023-12-16','2024-02-18','2025-06-18',null,'n','z','c','c','h','c','l'),
          (169,-10,4,-4,-4,6946993991730979265,8176100137769720968,-8041462426565086065,-4109741515972549488,null,null,'2024-02-18','2024-02-18','a','z','p','i',null,null,'v','x'),
          (170,3,0,-4,4,null,-7624607757800218752,3618830994450644153,-6129891312770625052,'2025-02-17','2023-12-18','2025-06-18','2025-06-18','d','j','r','d','p','z','g','g'),
          (171,-10,5,6,2,-8830138177615843980,5994980713134629070,6480319847223557063,5812457841941972048,'2027-01-16','2024-01-19','2024-01-08','2023-12-13',null,'i','b','y',null,'h','c','e'),
          (172,null,2,8,-10,null,null,-2668174711835062355,-7937911099765547092,'2024-02-18','2023-12-15','2023-12-11','2023-12-20',null,'p','x','q','k','w','y','j'),
          (173,null,null,-10,-4,-7787325944354092620,1320716527879719392,-9166221674764576094,235735767961663391,'2025-06-18','2023-12-14','2023-12-12','2023-12-10','d','c','j','s','p','b','c','u'),
          (174,null,-4,-4,-10,364622063991352420,4970321947467996353,-9130870957699502595,8196827494559495982,'2025-02-18','2024-02-18','2026-02-18','2023-12-18','z','j','x','x',null,'s','t','a'),
          (175,5,8,-10,7,null,-2825070457296610618,-4914813500598169343,960642228396826217,'2027-01-16','2024-02-18','2023-12-18','2023-12-17',null,'i','n','b','d','x','r','k'),
          (176,-4,7,8,-10,3764948595785602107,2369598693018501594,-7989778992633982458,-382915346647278838,'2026-02-18','2024-01-08','2027-01-16','2025-02-17','o',null,'x','b','g','s','a','u'),
          (177,2,-4,0,9,3737716014645813822,-8560588108410815277,-4182495432745381426,4295861215986743261,null,'2025-06-18','2023-12-15','2026-01-18','d','v','v','v','c','i','t','h'),
          (178,-10,-10,3,-10,9116324680519029777,5244767067437673763,387385371772011475,5929758206547735429,'2025-02-18','2025-02-18','2023-12-14','2023-12-13','x','d','z','n','f','u','x','z'),
          (179,null,-10,4,8,33967237888604502,-5317545323880858579,-5205082973483149617,1930065832149488722,'2024-01-31','2024-02-18','2023-12-17','2023-12-10','k',null,'s','h','r','k','q','j'),
          (180,null,3,0,2,-5628966950066318339,null,5178806324406541024,-3755555444616250127,null,'2023-12-13','2027-01-16','2027-01-16','k','q','z','o','f','b','s','g'),
          (181,2,7,4,-10,6385617375816027246,6495041779069789335,3773525655373506,8863923940907927212,'2027-01-16',null,'2025-02-17','2024-01-31',null,null,'c','j',null,'m','q','k'),
          (182,0,3,9,1,8218839267568478559,-9078367742579969816,42287215527153557,-8332275497056352768,null,'2024-01-17','2023-12-19','2027-01-16','u','o','n','n',null,'d','j','d'),
          (183,0,4,-4,-10,-4412910011538773187,null,6009092362215628337,1397631704475053458,'2025-06-18','2024-01-09','2023-12-16','2023-12-18',null,'j','g','a','l','g','o','d'),
          (184,0,3,2,2,6021283243596252750,-4155088143560449683,6170973520736075185,-4205974343310933147,'2023-12-15','2027-01-09','2024-02-18','2024-02-18',null,'b','h','j','k',null,'t','j'),
          (185,-10,9,8,6,null,-6847080278916852813,447950904400246482,-6933255189029870646,'2024-01-09',null,'2023-12-14','2026-02-18','h','p','g','q','p','u','x','p'),
          (186,3,-4,-4,2,-6009193301033031800,null,-4672034582397754264,879776088217230979,'2023-12-09','2023-12-17','2023-12-12','2023-12-20','m','p','s','c','f','f','t','l'),
          (187,null,0,3,5,8333051860130787223,-6516443762135442729,879209435522521115,8013043252265825497,'2025-02-17','2023-12-18','2025-02-18','2025-06-18','k','b','j','x','g','g','s','l'),
          (188,0,-10,7,-4,-2463031932695328774,null,-2011111060524811832,-6510640267309401751,null,'2023-12-20','2024-01-09','2025-06-18','m','j','s','y','y',null,'n','t'),
          (189,7,-4,-4,9,572148246336646876,null,5241035521810846489,-1634746466882461066,'2027-01-16','2026-02-18','2025-02-18','2023-12-20','b',null,'b','b','l','l','f','k'),
          (190,-4,-10,-4,8,6098594457072613484,null,4073451604755026083,1867497698996352795,'2023-12-13','2024-02-18','2025-02-18','2024-01-08','i','k','f','s','b','o','c','q'),
          (191,0,-4,1,7,null,8584171056884324573,2382411307476548648,-2812791859451287640,'2024-01-17','2024-01-17','2023-12-19','2024-01-31','s','l','o','q','k','r','p','y'),
          (192,null,7,9,-10,-6627830543468052229,-1031929253636573934,-6915694304224904507,-2450876687398543429,'2024-01-09','2023-12-18','2024-02-18','2023-12-17','d','w','f','q','n',null,'k','e'),
          (193,5,8,-10,7,-5900364580208786110,-7872693241314584841,-3099731394333634291,8800894838331835589,'2023-12-14','2023-12-11','2023-12-12','2024-01-08',null,'a','o','s','l','q','l','o'),
          (194,-10,-10,-10,0,6190666485437686533,9106505512949814658,-5259893975720632633,-2082645093827676340,'2023-12-15','2023-12-16','2023-12-14','2026-01-18','f','k','d','l','g','l','h','k'),
          (195,-10,-10,8,-10,9022523916974374832,-1637460904533459978,-2660463402243837366,-1386206454202037958,'2023-12-16','2023-12-12','2024-02-18','2024-01-17',null,'k','h','b','t','y','g','h'),
          (196,null,0,7,0,4521246042360985258,-3539427316714994362,4376191890126961035,-5108612672018064701,null,'2024-01-31','2023-12-20','2024-01-09','c',null,'w','t','h',null,'t','c'),
          (197,7,null,2,1,-3638524270505713749,-960841410750600000,5789480090124650148,8824201152864956993,'2023-12-10','2024-02-18','2024-01-17','2024-02-18','p','u','w','z','a',null,'l','w'),
          (198,null,0,2,-4,-1564019790200386279,-7666918062049658327,-4388748787665181900,-145844673711442497,'2026-01-18','2023-12-14','2027-01-16','2024-01-31','h',null,'a','r','a','t','d','h'),
          (199,null,null,-10,-4,-6417806465018977070,6707853128566441994,-1305020385906477162,6811355155723134908,null,'2023-12-13','2024-01-09','2025-06-18','n','b','y','d','f',null,'p','y');
       """

    qt_select_no_need_0 "SELECT table1 . col_varchar_10__undef_signed AS field1, table1 . `col_int_undef_signed_not_null` - ( 0 + 1) AS field2, table1 . col_varchar_10__undef_signed_not_null AS field3 FROM ${table2} AS table1 WHERE  (  ( table1 . `col_int_undef_signed_not_null` is  NULL ) OR table1 . col_date_undef_signed_index_inverted = '2023-12-18' )  GROUP BY field1,field2,field3  ORDER BY field1,field2,field3 LIMIT 1000 OFFSET 2;"

    def table3 = "test_index_no_need_read_data3"

    sql "drop table if exists ${table3}"
    sql """
       create table ${table3} (
       col_date_undef_signed_not_null_index_inverted date  not null  ,
       col_bigint_undef_signed_not_null_index_inverted bigint  not null  ,
       col_bigint_undef_signed_not_null bigint  not null  ,
       col_int_undef_signed int  null  ,
       col_int_undef_signed_index_inverted int  null  ,
       col_int_undef_signed_not_null int  not null  ,
       col_int_undef_signed_not_null_index_inverted int  not null  ,
       col_bigint_undef_signed bigint  null  ,
       col_bigint_undef_signed_index_inverted bigint  null  ,
       col_date_undef_signed date  null  ,
       col_date_undef_signed_index_inverted date  null  ,
       col_date_undef_signed_not_null date  not null  ,
       col_varchar_10__undef_signed varchar(10)  null  ,
       col_varchar_10__undef_signed_index_inverted varchar(10)  null  ,
       col_varchar_10__undef_signed_not_null varchar(10)  not null  ,
       col_varchar_10__undef_signed_not_null_index_inverted varchar(10)  not null  ,
       col_varchar_1024__undef_signed varchar(1024)  null  ,
       col_varchar_1024__undef_signed_index_inverted varchar(1024)  null  ,
       col_varchar_1024__undef_signed_not_null varchar(1024)  not null  ,
       col_varchar_1024__undef_signed_not_null_index_inverted varchar(1024)  not null  ,
       pk int,
       INDEX col_int_undef_signed_index_inverted_idx (`col_int_undef_signed_index_inverted`) USING INVERTED,
       INDEX col_int_undef_signed_not_null_index_inverted_idx (`col_int_undef_signed_not_null_index_inverted`) USING INVERTED,
       INDEX col_bigint_undef_signed_index_inverted_idx (`col_bigint_undef_signed_index_inverted`) USING INVERTED,
       INDEX col_bigint_undef_signed_not_null_index_inverted_idx (`col_bigint_undef_signed_not_null_index_inverted`) USING INVERTED,
       INDEX col_date_undef_signed_index_inverted_idx (`col_date_undef_signed_index_inverted`) USING INVERTED,
       INDEX col_date_undef_signed_not_null_index_inverted_idx (`col_date_undef_signed_not_null_index_inverted`) USING INVERTED,
       INDEX col_varchar_10__undef_signed_index_inverted_idx (`col_varchar_10__undef_signed_index_inverted`) USING INVERTED,
       INDEX col_varchar_10__undef_signed_not_null_index_inverted_idx (`col_varchar_10__undef_signed_not_null_index_inverted`) USING INVERTED,
       INDEX col_varchar_1024__undef_signed_index_inverted_idx (`col_varchar_1024__undef_signed_index_inverted`) USING INVERTED,
       INDEX col_varchar_1024__undef_signed_not_null_index_inverted_idx (`col_varchar_1024__undef_signed_not_null_index_inverted`) USING INVERTED
       ) engine=olap
       UNIQUE KEY(col_date_undef_signed_not_null_index_inverted, col_bigint_undef_signed_not_null_index_inverted, col_bigint_undef_signed_not_null)
       PARTITION BY             RANGE(col_date_undef_signed_not_null_index_inverted) (
                       FROM ('2023-12-08') TO ('2024-01-01') INTERVAL 1 DAY,
                       FROM ('2024-01-01') TO ('2024-12-01') INTERVAL 1 MONTH,
                       FROM ('2025-01-01') TO ('2027-01-01') INTERVAL 1 YEAR,
                       FROM ('2027-01-01') TO ('2032-01-01') INTERVAL 2 YEAR
                   )

       distributed by hash(col_bigint_undef_signed_not_null)
       properties("enable_unique_key_merge_on_write" = "true", "replication_num" = "1");
    """
    sql """INSERT INTO ${table3} (
        pk,
        col_int_undef_signed,
        col_int_undef_signed_index_inverted,col_int_undef_signed_not_null,
        col_int_undef_signed_not_null_index_inverted,col_bigint_undef_signed,
        col_bigint_undef_signed_index_inverted,col_bigint_undef_signed_not_null,
        col_bigint_undef_signed_not_null_index_inverted,col_date_undef_signed,
        col_date_undef_signed_index_inverted,col_date_undef_signed_not_null,
        col_date_undef_signed_not_null_index_inverted,col_varchar_10__undef_signed,
        col_varchar_10__undef_signed_index_inverted,col_varchar_10__undef_signed_not_null,
        col_varchar_10__undef_signed_not_null_index_inverted,col_varchar_1024__undef_signed,
        col_varchar_1024__undef_signed_index_inverted,col_varchar_1024__undef_signed_not_null,
        col_varchar_1024__undef_signed_not_null_index_inverted)
    VALUES
        (0,5,-10,3,1,null,1146299004109928502,3054813699474005908,-8079828267200209325,null,'2023-12-11','2024-02-18','2023-12-09',null,'m','f','e','a',null,'t','k'),
        (1,7,6,-10,5,-3931151281173717292,-5145129302476624156,902304869577035320,5744562438440616389,'2024-02-18','2023-12-10','2025-06-18','2025-02-17','d',null,'c','l','x','e','y','x'),
        (2,4,3,-4,3,-7408004146830346908,null,-8028056329708851758,1163188885741485002,'2025-02-17','2024-02-18','2023-12-14','2023-12-09',null,'v','p','i','l','c','b','j'),
        (3,1,6,1,0,-1906034789238721279,null,1957761206188834725,3171057930488341880,'2026-02-18','2026-02-18','2025-02-18','2024-01-17','o',null,'e','i',null,'d','a','t'),
        (4,2,-10,9,-4,5850070976734819027,null,-5842840828907453020,-273940474239998130,'2023-12-11','2023-12-09','2027-01-09','2025-02-17','w','r','t','d','h','c','q','a'),
        (5,5,null,4,0,-5480193238064846266,-6620736245996944815,7365496721129870481,1691015090920050763,'2023-12-14','2024-01-19','2027-01-16','2025-02-18',null,'k','a','x','u','w','w','z'),
        (6,1,6,6,0,-9130053015303478082,-7409550162748983851,-6460519591113198675,4268431147039676041,'2023-12-17','2023-12-14','2023-12-13','2023-12-09','f','b','j','t','s','w','k','w'),
        (7,1,1,7,-10,-5034221818576108388,3377388750712858412,4148586308329186918,-6946810068891785279,'2025-06-18','2024-02-18','2025-02-18','2023-12-16','a',null,'v','v','y','d','l','j'),
        (8,4,5,-10,8,-4438909091225320199,5264569089790771494,673882907280772426,-6648743693508345926,'2023-12-14','2023-12-20','2025-02-17','2025-06-18','t','d','g','m','c','p','w','f'),
        (9,-10,-4,8,5,-7072757031384422827,1891130646555645562,7434252548576276534,-5743044648348161373,'2025-06-18','2023-12-19','2023-12-20','2027-01-16','y','a','n','p','c','n','c','m'),
        (10,7,-4,4,5,5857498966192122667,6193204789244308341,-3086121824768187201,1515144221306401089,null,'2024-01-17','2023-12-15','2023-12-18','h','x','n','j','t','i','m','e'),
        (11,-10,2,2,-10,6625489715972743845,103798082185739918,8612497332139231257,754097475492000522,null,'2024-01-31','2023-12-16','2023-12-12','y','d','u','q','j','e','k','s'),
        (12,null,-10,-10,4,1031002928045228743,null,-2121004553096116042,-5786600442641449888,'2025-06-18','2023-12-20','2025-06-18','2023-12-13','e','q','i','s','t','x','a','k'),
        (13,7,6,8,-10,-3650237907046013970,-8923143162937692921,-2901539272447586610,-3848668134431446551,'2025-06-18','2026-01-18','2026-02-18','2023-12-19','q',null,'e','z',null,'k','z','i'),
        (14,-4,8,-4,7,-5551320780754796619,-8198293630186692221,807743948639582197,771500250889699631,'2026-02-18','2023-12-12','2024-01-19','2024-01-09','h','h','f','t','s','b','n','h'),
        (15,-10,null,3,2,-1361577796381150861,-9150402829641459244,-2134857148859701067,-8732326141705640079,'2024-01-17','2023-12-18','2023-12-14','2024-01-17','j','h','r','c',null,'l','u','z'),
        (16,null,null,8,-10,-6046584177751179555,null,-7103875849041184443,-4530723850373671640,'2023-12-16',null,'2025-02-17','2024-02-18','b',null,'m','o','y','l','d','h'),
        (17,-4,4,-4,-4,571594462292185627,-6068611791805235858,-2368221053835161848,5542334773553433761,'2023-12-14','2023-12-17','2024-01-09','2023-12-18','e','m','k','h','e','m','j','l'),
        (18,4,-4,8,-4,-2381305601222026411,null,2689411551411464180,2249737024075651261,'2024-02-18','2023-12-15','2024-01-08','2023-12-12',null,'v','t','x','l',null,'b','x'),
        (19,4,null,5,4,1489284125193916764,8324916610585760001,-188367432889663886,7565473533629309477,'2025-06-18','2023-12-14','2023-12-10','2027-01-16','e','q','s','m',null,null,'h','u'),
        (20,5,5,-10,3,5311791441008953224,-5373656924853056247,5033152844478566987,-1965600420787096371,'2024-01-19',null,'2023-12-13','2023-12-11','h',null,'d','u','y','b','s','t'),
        (21,2,null,-4,-4,null,-5210845946882797263,-1906934135585903680,-6715836128700437175,'2024-01-31',null,'2023-12-15','2025-02-17',null,'h','u','x','d','f','u','o'),
        (22,-4,6,8,3,-7915827973227671028,-7763151239401397618,-6924184946839377244,-5077528576615928221,null,'2026-01-18','2027-01-09','2025-02-18',null,'t','z','w',null,'p','y','a'),
        (23,3,9,3,2,-1377420279866931713,2353940657356813290,-3956199807549024801,-7352610478131219676,'2023-12-15','2025-06-18','2027-01-09','2023-12-16',null,'s','i','u','m','j','y','w'),
        (24,-10,2,3,5,4351938980531654605,null,-7367984332108156958,1547376881468045026,'2023-12-15','2024-02-18','2024-02-18','2027-01-16','i',null,'i','a','v','y','f','u'),
        (25,null,-4,5,-10,813215637967049379,null,-8639371031629360757,-2677090274650435671,'2024-02-18','2023-12-19','2024-01-31','2023-12-14','e','w','h','b','m',null,'e','w'),
        (26,null,-4,7,0,-2705719529474059399,761101566426163462,-4094584249080765052,4728256755894584175,'2027-01-16','2025-06-18','2023-12-15','2023-12-16','l','h','g','l','f','c','b','f'),
        (27,null,-4,0,-4,null,-1915788396240476514,6636972836518065792,973665687888690313,'2023-12-12','2023-12-17','2024-02-18','2024-02-18','f','h','y','t','g','d','e','j'),
        (28,1,3,-4,3,1826767802295773650,-8601082167935472379,786583851108559956,7095204956568924586,'2025-02-17','2026-01-18','2026-02-18','2026-01-18','y','p','h','d',null,'c','j','w'),
        (29,6,1,8,0,2007299877841850028,null,-1033108658215433638,2144620676116321201,'2023-12-09','2024-02-18','2024-02-18','2026-01-18',null,'b','a','m',null,null,'h','v'),
        (30,7,-10,0,8,-1507049011359000670,null,-8045359991171155883,-597686187736225023,'2023-12-16','2024-01-17','2024-01-19','2023-12-17','x',null,'n','s','w','o','k','e'),
        (31,7,2,7,-10,null,-8458279600625224237,-3914822523612983096,-4446342715209868884,'2024-02-18','2027-01-09','2023-12-17','2027-01-09','g',null,'p','l','j','p','r','a'),
        (32,-4,3,4,-4,-5000241005490842497,null,3250886256326101741,-2609778586966241852,'2025-02-18','2024-01-31','2023-12-10','2023-12-16','k','g','r','n','i','i','h','m'),
        (33,8,8,1,-4,545801367274301686,2040874140179283652,6139875498888853887,3305951047824978187,'2023-12-13','2025-02-18','2023-12-19','2027-01-16','z','s','m','e','v','q','e','q'),
        (34,8,-10,6,-4,-9128124361950426021,764648136753512126,-3119079956728551491,2254455287193372425,'2023-12-18','2023-12-12','2024-01-31','2025-02-17','r','e','g','e','t','g','d','a'),
        (35,-4,-10,9,6,-3424830969405380454,null,6332391162045472707,-8275510987434726169,'2023-12-20','2024-02-18','2024-01-09','2023-12-10',null,'v','j','j','n',null,'k','f'),
        (36,3,null,7,5,-386625993355302526,5268031105455808934,-1318788345808047836,4415301058346503575,null,'2023-12-17','2023-12-19','2023-12-11','y','r','z','i','d',null,'m','t'),
        (37,5,2,4,-10,-7921349127087247948,482578803322134946,-7884490253805336058,-5745731346487409054,'2027-01-09','2024-01-17','2026-02-18','2024-01-08','a','p','z','p','r','y','p','b'),
        (38,-4,1,2,0,590841228155877868,null,2145072569052395952,2323398089574171513,'2023-12-19','2026-02-18','2024-02-18','2023-12-16','l','c','a','e','n','j','x','k'),
        (39,9,8,8,7,-480620735123240246,-5176490473294300655,-4313738933151315624,3680054219070596837,'2024-02-18','2023-12-18','2023-12-18','2023-12-13','i','l','p','z','z',null,'x','p'),
        (40,0,2,4,-10,5369707610006331017,null,-9012080361800815742,-4799198380897739036,'2025-02-17','2023-12-10','2024-01-31','2026-02-18','i',null,'z','i','h','f','o','p'),
        (41,1,9,-10,4,8908830966360674313,null,-6993282584234490218,6761134586638358207,'2023-12-11',null,'2026-02-18','2024-01-08',null,'y','z','y','i','b','o','e'),
        (42,7,-4,-4,9,null,4549659473548533477,-2674534228571273744,5306067049540282217,'2026-02-18','2026-01-18','2025-02-18','2023-12-18','r',null,'p','s',null,null,'v','p'),
        (43,5,null,-4,3,-2476241334378583391,null,-6318178316501710444,-8516151862183337116,'2024-01-09',null,'2026-01-18','2023-12-13','r','t','o','e','b','t','u','z'),
        (44,1,6,4,-10,null,3579596494186056294,4966472750863861613,2841646796185804447,'2023-12-17',null,'2023-12-19','2023-12-09','x','g','c','e','l','i','f','q'),
        (45,null,8,-4,-4,-4965111477823617192,-5286434348768626629,2715454396527386574,3309748998908759298,'2024-01-17','2024-01-08','2026-01-18','2023-12-09','t','u','w','e','o','e','b','i'),
        (46,-10,null,3,2,null,-7616474331004486594,-246680075038083294,7820924017202546946,'2027-01-16','2025-02-18','2024-01-17','2024-02-18','h','y','c','e','j','u','s','e'),
        (47,3,6,-4,6,280714650710842291,-631315162984856571,4202780481531603208,927942176177129602,null,'2027-01-16','2023-12-12','2026-02-18','r','z','e','f','e','c','t','x'),
        (48,null,6,-4,9,-8887846129139266086,445589898932113981,4706686273532265628,-1619520637972685150,'2023-12-09','2023-12-13','2027-01-16','2024-02-18',null,'q','c','h','k','g','z','l'),
        (49,6,-10,6,8,5983110054374805308,1601019964266644567,7723563362109930198,399519444913401672,'2026-02-18','2023-12-12','2023-12-14','2023-12-11',null,'x','s','g','p','u','z','a');
    """

    def table4 = "test_index_no_need_read_data4"

    sql "drop table if exists ${table4}"
    sql """create table ${table4} (
    col_int_undef_signed_not_null_index_inverted int  not null  ,
    col_bigint_undef_signed_not_null_index_inverted bigint  not null  ,
    col_bigint_undef_signed_not_null bigint  not null  ,
    col_int_undef_signed int  null  ,
    col_int_undef_signed_index_inverted int  null  ,
    col_int_undef_signed_not_null int  not null  ,
    col_bigint_undef_signed bigint  null  ,
    col_bigint_undef_signed_index_inverted bigint  null  ,
    col_date_undef_signed date  null  ,
    col_date_undef_signed_index_inverted date  null  ,
    col_date_undef_signed_not_null date  not null  ,
    col_date_undef_signed_not_null_index_inverted date  not null  ,
    col_varchar_10__undef_signed varchar(10)  null  ,
    col_varchar_10__undef_signed_index_inverted varchar(10)  null  ,
    col_varchar_10__undef_signed_not_null varchar(10)  not null  ,
    col_varchar_10__undef_signed_not_null_index_inverted varchar(10)  not null  ,
    col_varchar_1024__undef_signed varchar(1024)  null  ,
    col_varchar_1024__undef_signed_index_inverted varchar(1024)  null  ,
    col_varchar_1024__undef_signed_not_null varchar(1024)  not null  ,
    col_varchar_1024__undef_signed_not_null_index_inverted varchar(1024)  not null  ,
    pk int,
    INDEX col_int_undef_signed_index_inverted_idx (`col_int_undef_signed_index_inverted`) USING INVERTED,
    INDEX col_int_undef_signed_not_null_index_inverted_idx (`col_int_undef_signed_not_null_index_inverted`) USING INVERTED,
    INDEX col_bigint_undef_signed_index_inverted_idx (`col_bigint_undef_signed_index_inverted`) USING INVERTED,
    INDEX col_bigint_undef_signed_not_null_index_inverted_idx (`col_bigint_undef_signed_not_null_index_inverted`) USING INVERTED,
    INDEX col_date_undef_signed_index_inverted_idx (`col_date_undef_signed_index_inverted`) USING INVERTED,
    INDEX col_date_undef_signed_not_null_index_inverted_idx (`col_date_undef_signed_not_null_index_inverted`) USING INVERTED,
    INDEX col_varchar_10__undef_signed_index_inverted_idx (`col_varchar_10__undef_signed_index_inverted`) USING INVERTED,
    INDEX col_varchar_10__undef_signed_not_null_index_inverted_idx (`col_varchar_10__undef_signed_not_null_index_inverted`) USING INVERTED,
    INDEX col_varchar_1024__undef_signed_index_inverted_idx (`col_varchar_1024__undef_signed_index_inverted`) USING INVERTED,
    INDEX col_varchar_1024__undef_signed_not_null_index_inverted_idx (`col_varchar_1024__undef_signed_not_null_index_inverted`) USING INVERTED
    ) engine=olap
    UNIQUE KEY(col_int_undef_signed_not_null_index_inverted, col_bigint_undef_signed_not_null_index_inverted, col_bigint_undef_signed_not_null)
    PARTITION BY             RANGE(col_int_undef_signed_not_null_index_inverted) (
                    PARTITION p0 VALUES LESS THAN ('4'),
                    PARTITION p1 VALUES LESS THAN ('6'),
                    PARTITION p2 VALUES LESS THAN ('7'),
                    PARTITION p3 VALUES LESS THAN ('8'),
                    PARTITION p4 VALUES LESS THAN ('10'),
                    PARTITION p5 VALUES LESS THAN ('1147483647'),
                    PARTITION p100 VALUES LESS THAN ('2147483647')
                )

    distributed by hash(col_bigint_undef_signed_not_null)
    properties("enable_unique_key_merge_on_write" = "true", "replication_num" = "1");
    """

    sql """
    INSERT INTO ${table4}(
        pk,
        col_int_undef_signed,
        col_int_undef_signed_index_inverted,
        col_int_undef_signed_not_null,
        col_int_undef_signed_not_null_index_inverted,
        col_bigint_undef_signed,
        col_bigint_undef_signed_index_inverted,
        col_bigint_undef_signed_not_null,
        col_bigint_undef_signed_not_null_index_inverted,
        col_date_undef_signed,
        col_date_undef_signed_index_inverted,
        col_date_undef_signed_not_null,
        col_date_undef_signed_not_null_index_inverted,
        col_varchar_10__undef_signed,
        col_varchar_10__undef_signed_index_inverted,
        col_varchar_10__undef_signed_not_null,
        col_varchar_10__undef_signed_not_null_index_inverted,
        col_varchar_1024__undef_signed,
        col_varchar_1024__undef_signed_index_inverted,
        col_varchar_1024__undef_signed_not_null,
        col_varchar_1024__undef_signed_not_null_index_inverted)
    VALUES
        (0,-4,-10,4,0,-4374279311784469210,6230856899329561501,-1362977170076928174,5463495393891541626,'2024-01-31','2026-01-18','2024-02-18','2023-12-14','p',null,'a','c','g','m','m','j'),
        (1,-4,3,0,5,6906900996486541211,-2711144224856392486,1690655402925311792,332907949355269309,'2026-02-18','2027-01-16','2024-01-31','2023-12-10','u',null,'t','b','x','k','r','p'),
        (2,-4,5,6,1,-5341451822306664502,-7115804010536970742,-4843960976976500243,7691986120828494058,'2023-12-11','2025-06-18','2023-12-18','2023-12-10','z','g','n','r','o','i','t','h'),
        (3,null,-4,7,-10,327892986881735505,-8837888276019013196,-4046944610541972362,4462086985245026136,'2027-01-09','2024-02-18','2024-02-18','2023-12-12','x','g','j','b','p',null,'o','x'),
        (4,8,-10,-4,-10,-8103714258740889321,null,-6100454805711535802,-7007269108987098048,'2024-01-08',null,'2025-06-18','2023-12-19','i',null,'l','m','f','g','k','p'),
        (5,8,8,-10,-4,null,1714919072532351532,-2734317776976078785,-7065081553707628941,'2024-01-09',null,'2023-12-14','2024-02-18','k','l','x','k','p',null,'w','q'),
        (6,9,5,8,5,8933733382910842732,2593449295475070603,-6967069732255393771,4181239333600269,'2023-12-13',null,'2024-02-18','2025-06-18','y','d','q','s','i','s','f','g'),
        (7,null,-4,-10,8,null,-6087104111939342959,-5761839186792307998,-5276788681754397583,'2023-12-16','2024-01-31','2024-02-18','2024-01-09','u','i','g','v','r','x','d','o'),
        (8,-4,9,0,2,2435390590143504753,-6317557083356582458,-7951133009629443607,4001268324476360080,'2024-01-09','2023-12-18','2023-12-10','2023-12-15','t','z','s','p','z','j','u','z'),
        (9,3,-4,5,4,6342563333639934319,-744829708550488670,-3699151955606516335,4592632498223399047,null,'2024-02-18','2023-12-13','2023-12-20','o','p','f','t','y',null,'q','f'),
        (10,3,-4,2,4,-3306843512894296461,-2707388015819334459,392367306362836837,-4713477625347948733,'2023-12-17',null,'2027-01-16','2023-12-12','k',null,'z','o','s','m','u','c'),
        (11,1,-10,7,-4,-2432875797191938254,1709676469795306975,2985452025410848007,7598045945075263293,'2025-02-17','2025-02-17','2023-12-13','2023-12-17',null,'h','l','c',null,'x','e','u'),
        (12,9,-10,-10,4,5840415679800360308,null,-8187426912793923006,-1371366092755353351,'2023-12-18',null,'2023-12-16','2023-12-11','f','y','i','t','j',null,'m','q'),
        (13,4,2,7,-10,-4317958699881727007,4629780752784506794,-768293186225303832,2913296699191586253,'2023-12-13',null,'2024-01-19','2023-12-14','a','u','p','o','s','d','t','v'),
        (14,-4,5,5,4,-6116177655339387947,-5072350629017321874,6032568594823889084,-3637087033433580073,'2025-02-18','2023-12-15','2026-02-18','2023-12-09','c','r','k','g','o','r','m','e'),
        (15,null,-10,5,-4,1451439167875099448,null,-3083064549924141039,8477304707241625848,'2027-01-09','2027-01-09','2023-12-20','2027-01-16','z','w','c','n','y',null,'q','c'),
        (16,3,5,-10,9,-1807434810700055230,-4859213966577544827,-723410772400036445,2758378783736727839,'2023-12-19','2023-12-14','2025-06-18','2024-01-09','h',null,'l','c','n',null,'q','i'),
        (17,7,null,-10,4,-4603591052649553464,4010384366789041704,4768892995676961224,-5776603065792060312,'2023-12-10','2024-01-08','2024-01-19','2025-02-18','d','c','t','i','j','t','a','e'),
        (18,8,3,-4,-10,-2526706244749516773,9150775215396227369,-697278752989518462,-6993391287390315322,null,'2026-02-18','2023-12-12','2027-01-09','u','i','y','r','m',null,'w','s'),
        (19,null,4,-10,-10,null,-4048266292265681313,2198895883037279869,-4727497382390112607,'2023-12-18','2023-12-13','2026-01-18','2023-12-19','c','e','h','w','w','o','r','x'),
        (20,1,-4,4,-10,915044794065797675,5767467541212153071,805079178006980426,-5832392521480652104,'2023-12-09',null,'2023-12-10','2025-06-18','q',null,'m','f','x','g','s','a'),
        (21,null,8,7,2,-7779943329829392946,-580168709010583216,-3875246283753493237,2106715699688700081,'2023-12-19','2024-02-18','2023-12-12','2024-02-18',null,null,'u','c','a','a','l','u'),
        (22,null,3,1,4,-1433244310611814881,463798216469349291,-3993493521540596692,-1655409780328479239,'2024-02-18','2023-12-11','2024-01-17','2024-01-31',null,'a','j','m','n','g','r','z'),
        (23,-4,3,-10,-10,null,796361822606831545,6459034733477890212,-7041503003082661774,'2026-02-18','2024-02-18','2024-01-17','2024-01-09','i','a','u','o','a','a','m','g'),
        (24,5,-10,-10,2,null,2220905695260878249,-786034809849623809,2220087153625747339,null,null,'2023-12-09','2024-02-18',null,'t','m','b','g','k','u','x'),
        (25,-10,-10,8,8,null,null,-3479485257013893199,4115385544188410040,'2024-01-19','2024-01-08','2026-01-18','2023-12-20','m','y','u','i','h','v','m','d'),
        (26,-4,7,-4,-10,-6274266781511631015,-6227105689808199660,-964043111865585753,5538388785209296423,'2027-01-16',null,'2024-02-18','2024-02-18','t','g','b','n','x','u','b','w'),
        (27,5,null,-4,-10,-7644699987660198305,6752007724729926825,1402337567971338188,-8985676234650436106,'2024-01-31','2027-01-09','2023-12-13','2023-12-17','o','d','k','v','w',null,'i','m'),
        (28,null,1,5,9,-32726974781645892,null,3163425560289830058,7947682038003034876,'2024-02-18','2023-12-15','2026-02-18','2023-12-14','j',null,'f','u',null,'l','o','f'),
        (29,4,-10,5,-10,-7494882589520174902,-708794773472534037,8864040579112277958,9016298081936948013,'2024-02-18','2025-02-17','2027-01-09','2027-01-09','s','m','a','d',null,null,'y','z'),
        (30,8,null,8,6,-7969789176743648651,3995090805756755628,-3431502351498670021,-8014312388299533826,'2023-12-11','2025-02-18','2023-12-20','2026-02-18','y','u','e','x','r',null,'f','b'),
        (31,null,-4,-10,2,7550347272789509553,3872875348404154813,7804341187060405957,448443571425496346,'2023-12-09','2024-01-31','2023-12-14','2027-01-09','i','s','m','c','e',null,'c','j'),
        (32,3,3,3,-4,-8959255589673252978,8167700668095735919,-3599832410803104025,890118425432299772,'2023-12-17','2023-12-10','2024-01-19','2025-06-18','o','s','z','n',null,'q','h','k'),
        (33,7,3,-10,5,-1015175028437962837,-8466721438536728594,3251948054786435766,-7771957592532254405,'2024-02-18',null,'2025-06-18','2024-01-08','v','k','f','g','u',null,'y','f'),
        (34,0,8,-10,-4,null,-7079831472885584649,-3385439260999791057,5600810453965655524,'2023-12-19','2023-12-10','2024-02-18','2023-12-19',null,'r','j','y','i','j','r','x'),
        (35,null,9,-10,-10,1580906363255232903,-4080634175451712213,-3552859155879629811,-2166303063843400144,'2024-01-31','2023-12-10','2024-01-08','2023-12-11','h','d','f','b','y','l','o','w'),
        (36,9,1,3,9,-6806495139778535894,2702207607257979668,-3402421250001308357,-8320351824293312344,'2023-12-15',null,'2025-02-18','2024-01-17',null,'v','f','g',null,'z','n','p'),
        (37,7,3,-4,-10,-4800984213430644307,7461383103576184807,-3274035332690061411,-28599221166062621,'2023-12-12',null,'2023-12-14','2023-12-16','q','u','g','i','a','x','w','y'),
        (38,0,-4,3,3,7238664880615018700,-4797606762194243590,9179648063004905118,-1573978436199896,'2023-12-12','2024-02-18','2023-12-19','2023-12-12','c','m','n','s',null,'v','w','y'),
        (39,-10,9,3,3,null,null,8177777199198803415,-347026646202248969,'2024-02-18','2025-06-18','2024-02-18','2024-01-08','m','x','g','b','l','c','s','p'),
        (40,7,-4,2,9,3914381071364338122,null,3924941427391147928,-3657946472047063224,'2027-01-16','2025-06-18','2024-02-18','2025-02-17','k',null,'y','z',null,null,'m','v'),
        (41,2,-10,-10,7,-5808964950144096455,-2100279162114847574,2928466204466928811,5045687639015665238,'2024-02-18','2023-12-12','2024-01-09','2027-01-16','c','h','q','d','u','a','r','b'),
        (42,-4,9,9,6,null,-6160899548039050387,-2191266489297679333,8329335412260929602,'2023-12-15','2025-02-18','2023-12-09','2023-12-15','s','i','o','t','b',null,'i','j'),
        (43,1,4,5,-4,null,-6530600321165393735,804842027815969388,3518829673794923315,'2025-02-18','2023-12-20','2026-01-18','2024-02-18','q','x','o','j','b','y','u','r'),
        (44,9,7,-4,-10,-5847501154351098445,7703034812492442373,1357807031393353032,1366575769668513143,'2025-06-18','2025-02-18','2023-12-09','2024-02-18','q','x','g','i','u','y','t','h'),
        (45,8,9,-10,4,5576279648143068992,4858336579969416801,3613889528376791938,-9050893386117105191,'2023-12-09','2027-01-09','2025-02-18','2024-01-17','b','l','n','a','d','j','x','k'),
        (46,0,-4,2,8,5655393055825953457,-8822505644073884472,-3553290867279881090,5990053982050704820,'2027-01-16','2023-12-20','2023-12-09','2023-12-18','q','z','h','n','r','a','b','t'),
        (47,9,6,0,-4,-4567408599648021877,4726758482151618961,-532407405170053250,-9149611662648095535,'2023-12-13','2027-01-16','2023-12-17','2023-12-11','p','i','y','e','i',null,'h','t'),
        (48,-4,6,7,1,6993537939189193043,null,5219595323544812758,-6266192751197355511,'2023-12-13','2024-01-08','2023-12-19','2025-06-18','x','f','i','x','r','h','x','z'),
        (49,-4,null,1,1,-793429874699684492,2731612800302170068,-8258968138792801394,-604973685259326939,null,'2024-01-31','2023-12-17','2023-12-20','i','t','d','c','u','z','k','h'),
        (50,1,3,2,4,null,-1181340731105722635,1957771400080841726,1514890477185503853,'2023-12-12','2025-06-18','2024-02-18','2023-12-19',null,'o','i','c','x','q','s','t'),
        (51,2,7,-4,-4,null,null,-2154521592160516899,-8254235104879753323,'2024-01-09','2025-02-17','2024-01-09','2025-06-18','h','k','q','f','h','p','n','v'),
        (52,7,-4,3,4,null,-2394426695842498133,7644107209448288384,1463209406830791588,'2023-12-16','2024-01-31','2023-12-12','2023-12-13','v','u','j','k',null,'c','i','h'),
        (53,null,0,2,0,3290186359579227073,5370729292588386525,715755893754043315,-5338635265674023033,'2023-12-11','2023-12-18','2024-02-18','2026-01-18','v',null,'l','w','a',null,'v','q'),
        (54,7,1,5,-4,-2583544562212544609,-6530610552635634122,-1003006555342432486,3466338377827248850,'2026-01-18',null,'2025-02-17','2023-12-12','e',null,'u','s',null,'h','v','q'),
        (55,9,2,9,-4,4569056132889195950,null,-8334941492513475935,1645248882101858167,'2026-01-18','2024-01-17','2026-01-18','2023-12-16','y','l','g','h',null,'l','k','r'),
        (56,0,4,1,-10,null,3889002712426834242,5929860470216094115,5442709659182983947,'2027-01-09',null,'2023-12-11','2024-02-18','u','v','n','n','x',null,'i','f'),
        (57,null,-4,7,3,3301916305625845253,-4917814758883130078,-6315595450234631719,2909744643512919440,'2023-12-10','2025-02-18','2024-01-17','2023-12-10',null,null,'a','h','x','j','p','s'),
        (58,-10,-10,5,0,-5101677846562573474,-3036405238250610875,-8967724773412352716,-7890486781548601303,'2023-12-19','2023-12-15','2025-06-18','2025-06-18','s','w','l','c','c',null,'v','i'),
        (59,8,2,8,0,-3771340549227355567,-5332704703769436099,7969105374518441325,-3290527289471229051,'2025-06-18','2025-06-18','2024-01-09','2026-02-18','k',null,'o','i','h',null,'b','r'),
        (60,-10,null,6,3,6088635990829297416,-427285520357620531,3210661624777882314,6775862866213090148,'2023-12-15',null,'2025-02-18','2025-02-17','o','n','r','f','g',null,'l','l'),
        (61,-10,5,-10,-10,-2582207522113475375,-7751145616567856608,8194407191287366720,3427527395554022329,null,'2025-06-18','2023-12-12','2023-12-17','h',null,'o','r',null,'u','y','m'),
        (62,2,-10,-10,0,9127775229165644097,8965751423304265297,6546740737182994399,8741950356311830606,null,'2025-06-18','2025-02-18','2023-12-14',null,'d','f','m',null,'x','z','r'),
        (63,6,9,-4,5,-8522716279584170123,-5207644728454537578,-8843194407744496348,6433663505469138454,'2024-02-18','2023-12-16','2024-01-08','2024-01-17',null,'l','m','l','j','t','z','g'),
        (64,2,9,9,3,-3165626656511292684,-9032338160285674442,2519602398937561457,-6259991795199694525,'2023-12-20','2024-02-18','2023-12-18','2024-02-18','s','g','t','w','t','h','q','g'),
        (65,-4,5,1,6,7583171009332408221,8603254114462077881,5390788075181477511,-8301919228544148269,null,'2023-12-16','2024-01-17','2023-12-15','w','f','n','w','o',null,'r','u'),
        (66,-10,-4,1,0,9084887619520943355,null,4266488954048054291,7834350410719089719,'2023-12-20','2023-12-15','2024-01-08','2023-12-16','p',null,'n','b','b','m','t','t'),
        (67,9,0,3,3,1287201644628600885,9015092599522141574,2859050237040165999,845696629587897952,'2023-12-14','2027-01-16','2025-06-18','2023-12-20','z','v','v','w',null,null,'c','v'),
        (68,2,8,7,-10,null,8986004892348197686,-3076401008354772909,-3869023017589822322,'2025-06-18','2024-01-09','2025-06-18','2025-06-18','d','k','d','p','f','j','r','x'),
        (69,6,7,4,2,4247710583746697039,null,-2881224756676054192,-6504487671782598775,'2026-01-18','2025-02-18','2024-01-31','2023-12-10','e','x','e','i','r','g','s','k'),
        (70,3,null,5,-4,null,-6379628078115148755,-8637357844994209885,-1175147288893128810,'2023-12-12','2023-12-16','2025-02-18','2023-12-15','w',null,'x','l','s',null,'i','x'),
        (71,-10,-4,8,4,-161114011499147333,null,7527570514662628811,-3143294038995043817,'2023-12-18','2024-02-18','2026-02-18','2027-01-16','z','y','e','t','f','v','i','t'),
        (72,1,8,4,-10,null,-2566686755560124707,-1984722270271696408,6554878357826736076,'2023-12-20','2023-12-14','2023-12-11','2023-12-17','y','h','j','z','l','m','z','b'),
        (73,-10,9,0,-10,null,-5911079654787097794,-1231723484332417712,-1510404922414526519,'2024-01-08','2024-01-08','2024-01-09','2023-12-20','x','t','a','i','w','d','x','i'),
        (74,-4,-4,-10,-4,1021982051302183303,null,-5524412173519497971,4762631702038202273,'2024-02-18','2023-12-15','2023-12-12','2024-01-08',null,'g','l','m','m','r','q','s'),
        (75,-4,5,1,-10,-8187291799007472601,-1589344171272697978,-2221672332904187079,-5498875241982219042,'2023-12-13','2024-01-31','2023-12-12','2024-01-19','d','g','g','i','f','e','e','q'),
        (76,2,null,1,5,-1049556416011894874,5659823604821247801,4576617879751897252,7679004151039096951,'2023-12-10',null,'2024-01-19','2023-12-11','g','y','i','l',null,null,'z','m'),
        (77,2,8,3,-10,-8298457594137779019,-3008519884517039277,6165454958542109984,-2857572786594217366,'2024-01-08','2025-06-18','2023-12-18','2023-12-17','f','y','d','b',null,'g','k','g'),
        (78,7,null,2,1,7922947873248670954,null,-8033901538112331881,-7734882996737897338,'2024-01-31','2024-01-08','2024-02-18','2023-12-10','w','m','x','n','g','m','g','q'),
        (79,2,0,-10,-4,null,null,6866577989530226549,-5648133931388839462,'2025-02-17','2023-12-11','2023-12-10','2023-12-14','x',null,'c','k','n','k','o','j'),
        (80,null,2,5,5,-4002764782855679718,-3334085319763484862,7078340365437125170,153422961666453264,'2023-12-10','2023-12-11','2024-02-18','2023-12-16',null,'x','z','y','l',null,'g','k'),
        (81,-4,8,1,3,-502598168988806100,-2215017116349710864,6667779713577352926,-5057578441666532067,'2023-12-12','2023-12-19','2024-01-31','2024-01-09','l','k','b','l','o',null,'w','z'),
        (82,-10,1,-10,9,-3923170050209511192,null,2722142715895290021,8574020792796821057,'2024-02-18','2023-12-12','2024-01-09','2023-12-17','e','b','a','p','r','u','l','b'),
        (83,3,6,-4,1,1998510655215300619,null,6354289167038372886,-1329048652064706437,'2023-12-18','2023-12-18','2024-01-19','2024-01-09','w',null,'g','a',null,null,'k','p'),
        (84,6,1,9,6,4641731249315512781,-1703620321495592488,-6092625881819943380,-8101002340899447705,'2024-01-09','2023-12-12','2025-02-18','2025-02-17','v','c','o','u','d','c','d','s'),
        (85,6,8,5,4,1844668414721960612,-8146210778991800273,-3936859523385652823,1968571585919863013,'2023-12-13',null,'2025-06-18','2026-02-18',null,'h','n','b','s',null,'p','h'),
        (86,6,4,-4,5,2307184585446501717,8457935425369849751,-4640790242830318334,-5720189668042239199,'2024-01-17','2024-01-31','2024-01-09','2023-12-12','l','d','y','x','b','z','o','d'),
        (87,null,-4,1,-4,-4079880541179092990,-8777085310848376529,-8855355639795760272,-6213712627501603776,'2023-12-17','2026-01-18','2025-06-18','2023-12-19','q','x','i','k','y','z','i','r'),
        (88,2,-4,1,9,2449530539661493163,null,-1034942690256776893,-5239530726206775030,null,null,'2025-06-18','2025-02-17','p','p','e','v','i','s','u','y'),
        (89,-4,4,9,9,null,580744008591223310,582804241137928552,2826188225544777887,'2026-02-18','2023-12-09','2024-01-17','2024-01-09',null,'w','s','p','e','j','n','q'),
        (90,null,-10,1,-10,null,8077986560665786085,-3076874287907959745,-6280654642858117473,'2024-02-18','2025-06-18','2024-02-18','2023-12-14','z','q','u','g',null,null,'k','d'),
        (91,8,null,3,7,-7897081096047758209,-9050557163818221881,-2541271846187182209,8303513704230583288,'2024-01-31','2026-01-18','2024-01-09','2023-12-20','s',null,'r','s','f',null,'q','a'),
        (92,-10,3,0,-4,null,2453017922179789859,7337126341758369206,-5602454622732291242,'2024-01-31','2023-12-16','2023-12-20','2027-01-16','k','q','w','f',null,'e','z','a'),
        (93,0,-10,-10,6,8992480174027148091,-1670336162804176485,1411753004553957735,-198618186182788640,'2024-01-19','2023-12-17','2024-01-08','2024-02-18','r','o','p','y',null,'x','y','u'),
        (94,-4,6,-10,-10,-8957466425083050119,-2402909453843046228,3531706226758585417,-3669324823467897400,'2025-06-18','2025-02-18','2023-12-12','2026-01-18','g',null,'h','x','e',null,'c','g'),
        (95,null,8,-4,-10,null,null,6839449815129485589,279614831548786313,null,'2023-12-11','2023-12-16','2023-12-20','c','m','e','b','g','o','k','a'),
        (96,2,6,-10,-10,738742098729572283,-5347826738826717328,5940077377412709204,1070229902504882739,'2026-01-18','2023-12-18','2023-12-13','2023-12-18','p',null,'q','c',null,'w','b','q'),
        (97,2,5,-10,5,2852709492739526594,3864442720152847647,-5206985522063394337,7684852802358358168,'2023-12-18',null,'2027-01-09','2025-06-18','b','k','c','e',null,'p','l','l'),
        (98,0,6,-10,-10,8129634363133588286,null,6601689984342767762,-2581265504187476060,'2023-12-11',null,'2024-01-09','2024-01-08',null,'m','j','n','s',null,'s','l'),
        (99,7,5,-4,-4,null,-8927275264663200004,2454888163421628958,1159285906723119737,'2024-01-19','2024-02-18','2023-12-13','2024-02-18','e','u','f','t','x','v','l','v'),
        (100,1,null,-10,2,null,-7481942172263910485,-6831752050563716337,-223828997630176126,'2026-02-18','2024-01-17','2023-12-18','2025-06-18','s','y','v','q','e','j','j','o'),
        (101,0,1,8,8,null,null,-4659777097019506942,-6911205925937430248,null,'2025-06-18','2025-02-17','2023-12-19','q','i','q','a',null,'h','j','w'),
        (102,null,4,6,6,-5383300846905119484,-3852892649923125183,8741303194326577454,-1422162377162384531,'2023-12-15','2023-12-16','2024-02-18','2025-02-17',null,'g','s','f','q','d','u','c'),
        (103,9,-10,1,0,null,-5366175811963673605,-6025984314237815618,3195746254337656948,'2023-12-13','2023-12-19','2023-12-11','2024-01-19',null,'p','b','s',null,null,'x','m'),
        (104,2,0,9,3,543598546805911905,7963087580304173292,41125194827462574,-5996112137043481658,null,'2023-12-12','2025-02-17','2023-12-16','v','o','m','u','e','s','z','c'),
        (105,-4,3,-10,5,null,-6700664837979733535,-5960927335705409832,99083855513148415,'2023-12-16',null,'2024-02-18','2025-06-18','p','g','z','p','w','t','a','v'),
        (106,2,0,2,5,6185015649563523480,-4256528497487740013,-7682960043948784363,-4730508576545418376,'2024-01-08','2024-01-09','2025-02-18','2026-02-18','r','m','b','v',null,null,'n','d'),
        (107,3,-10,1,7,4518382840624285261,-4708648979257994067,-1184766874694299954,1822263113487199481,'2023-12-09','2023-12-13','2025-06-18','2023-12-17','z','d','s','h','c','l','i','t'),
        (108,-10,7,4,8,6298603150862889107,null,-8033238113214998802,8655415796198685900,'2024-01-17','2023-12-19','2023-12-20','2024-01-31',null,null,'a','l','y','d','r','f'),
        (109,-4,4,-10,1,8211484109800317652,-2044676252909838031,-3174454308715372561,205997297789665844,'2023-12-11','2025-06-18','2025-06-18','2026-02-18','e','p','h','q','r','p','x','t'),
        (110,7,null,-4,6,-5355279419137407168,null,-4771711721664649895,-1832061257770180659,'2023-12-16','2024-02-18','2023-12-10','2024-01-09',null,null,'d','o','j',null,'m','w'),
        (111,-10,8,9,7,null,null,3495781070681066731,-7751769959271685461,null,'2024-01-09','2023-12-17','2023-12-16',null,'q','y','q',null,null,'n','p'),
        (112,3,2,7,5,null,-8426913959368365890,-3322518183186526632,-9012922211700264139,'2025-06-18','2023-12-09','2025-06-18','2023-12-17','q',null,'f','m','h','d','g','i'),
        (113,6,1,-4,9,3307572978351887404,null,7216752837703912613,-1099717463162147826,'2023-12-20',null,'2026-01-18','2027-01-16','c',null,'l','x',null,'c','g','s'),
        (114,6,0,2,5,4273745106575096240,-4309878515979504572,-8743375667691118143,1150882016866373141,'2023-12-13','2024-02-18','2023-12-13','2024-01-08','n',null,'v','p','b',null,'p','o'),
        (115,null,8,1,2,-5325473613954832428,-6305506083342863376,3282163540651038181,-2348922300393953043,'2023-12-18',null,'2023-12-15','2024-02-18','w','n','t','s',null,null,'a','b'),
        (116,-10,5,-10,5,null,-2280008494954635011,7599532400772891574,-6972157389604191866,'2023-12-12','2023-12-19','2023-12-10','2024-02-18','p',null,'l','g','z','r','d','e'),
        (117,1,null,3,-4,6509515715296433309,null,-7316943633816884717,-7588155182092565097,'2024-02-18','2024-01-08','2024-01-31','2025-06-18','h','o','u','v',null,'k','l','r'),
        (118,7,null,-4,-10,-5348942484818265920,-115842037267334644,8921697522425758050,-7589445783794413545,'2023-12-17','2024-02-18','2023-12-12','2026-02-18','v','z','j','k','s','h','s','d'),
        (119,null,-4,6,-10,-963346494928329499,-5943554955977630098,-3904762043076439214,-3589895882724627048,'2023-12-12','2024-01-09','2023-12-11','2027-01-16','o','p','p','s','o','t','a','e'),
        (120,2,null,0,4,-22680686098672503,null,-5542083999655223056,7463003916581539418,'2025-06-18','2024-01-31','2023-12-09','2023-12-11','c','d','m','i','f','l','n','m'),
        (121,null,null,6,5,392367742148684396,6215444246243059703,7058433144043520407,-5126721088826007011,'2027-01-16','2024-01-08','2026-01-18','2024-02-18','k',null,'u','y','c','i','q','a'),
        (122,-10,1,-4,5,-3938055250590368252,null,-7571075358146213188,6550266852494957073,'2023-12-14','2023-12-12','2023-12-20','2024-02-18','n',null,'r','k',null,'b','r','n'),
        (123,-4,-10,8,5,null,2138737019170354262,351373869269067115,7058505121160252015,'2025-06-18','2023-12-09','2027-01-16','2024-01-19','i','m','q','n','a','g','o','h'),
        (124,3,-4,8,-10,-4210455955286522087,null,2231635375866126752,5613078292080299722,'2023-12-13','2023-12-20','2024-02-18','2023-12-16',null,'a','c','p','p','v','v','f'),
        (125,-4,-10,9,7,null,-245792394362721219,-3380330149007444668,7370021404759691579,'2023-12-15',null,'2023-12-19','2025-02-18','b','o','v','j','p','l','k','t'),
        (126,-10,3,-10,7,3388478275171816529,729277112928857610,7032754029847169854,-4106297766531731833,'2024-01-19','2023-12-19','2024-02-18','2023-12-11','g','y','n','n','m','s','g','t'),
        (127,null,-4,2,-4,-686394147000737042,null,-3106943452438700394,-7634277061725223758,'2024-01-17','2024-02-18','2027-01-09','2024-01-09','k','j','g','p','h','z','d','u'),
        (128,null,1,0,5,6950104621570455987,2471141496485968350,778426102249376628,6570889237740344011,'2026-02-18','2026-01-18','2023-12-15','2024-02-18','m','x','t','h','p','v','h','w'),
        (129,null,0,-10,4,-6879977270320432909,null,-4541442347808369450,-8186430568429593475,'2027-01-16','2024-02-18','2023-12-20','2024-02-18','f','x','z','z','q','o','g','d'),
        (130,-10,0,-4,-4,3564989563073709122,2900579710103386402,6368392132419761484,8375904869864765554,'2023-12-19','2026-02-18','2024-01-19','2023-12-19',null,'p','d','l','b','r','t','e'),
        (131,-10,6,5,9,1394750496655932510,4577557961658420405,-370836983757236658,6306036168787890000,'2023-12-15','2027-01-16','2023-12-10','2024-02-18','p','k','x','z','z',null,'n','j'),
        (132,null,8,5,1,5700672970687850887,9170134070500207214,1057023106304799660,9018548651389304582,'2023-12-20','2027-01-09','2023-12-20','2024-02-18','h','h','k','i','r','d','b','f'),
        (133,-4,2,0,3,null,-742292491060610773,4631105689365007235,4126317630870085333,'2026-02-18','2026-01-18','2023-12-12','2023-12-18','w','j','m','s','v',null,'a','o'),
        (134,-10,2,-10,1,-5225256832161593284,-4130895541709655456,6330602409572608338,8464814604243196898,'2023-12-15','2024-02-18','2023-12-15','2026-01-18','u','p','c','h','u','l','m','m'),
        (135,-10,0,2,9,null,8143831258642605184,-2725133517955844922,8895278493520317424,'2024-01-09','2023-12-13','2023-12-09','2023-12-11',null,'m','h','g','i','b','t','e'),
        (136,9,6,8,-10,3089055599373292605,2754698593244717196,-1062489555710081596,-5348210221819126242,'2024-01-31','2027-01-16','2023-12-10','2027-01-09','y',null,'d','c','i','u','y','w'),
        (137,9,-4,-4,8,null,null,-3229149233350248404,4959767326079369496,null,'2024-01-19','2026-01-18','2026-02-18','d','t','l','d','h',null,'w','l'),
        (138,-4,-10,2,-10,null,5870998506145918366,7295672039040337093,5140113514492461307,'2024-02-18','2025-02-18','2023-12-19','2023-12-19','t','u','i','r','x','k','r','w'),
        (139,0,4,7,6,1753303443248375231,-9172088115534524215,8827609633045132813,-5001366908295118601,'2024-02-18',null,'2023-12-09','2023-12-10','c','s','y','k',null,'a','y','j'),
        (140,8,-10,7,8,5673776871824353756,null,6158602833656611687,-5982984041243386520,'2023-12-13','2023-12-15','2026-02-18','2024-02-18',null,'c','s','q','g','j','q','m'),
        (141,3,8,-10,-10,5390990103301446933,-2355660463889030891,-2769621455151539522,-5201597879712237394,'2024-01-08','2025-06-18','2024-02-18','2024-02-18','l',null,'g','q','p',null,'g','f'),
        (142,null,1,-4,6,-6687890083051077019,8639164517873186908,426636294373918583,3832029756764217724,null,'2025-06-18','2023-12-10','2024-01-19',null,'u','h','w',null,'s','v','m'),
        (143,-10,-4,-4,-10,null,8949000333639224425,6067902032507147112,-8446123205471028580,'2025-02-18','2027-01-16','2024-01-31','2023-12-11','g',null,'t','b','m',null,'q','v'),
        (144,null,9,5,-4,339204242343824700,2278285957545941692,-1943782900027721772,-8348310440995114935,'2023-12-17','2023-12-11','2023-12-13','2026-02-18','n','n','i','f','f',null,'n','k'),
        (145,0,null,8,-4,null,null,3695608990914575340,4568884434825134946,'2027-01-09','2025-06-18','2023-12-12','2023-12-10','g','p','v','j',null,'d','j','d'),
        (146,null,0,1,1,5498577630379820303,-3503412173309954418,-3770797427518516131,4198094291883669841,'2027-01-16','2027-01-09','2023-12-20','2024-01-09',null,'j','a','v','j',null,'d','a'),
        (147,-4,-10,7,-4,-6510420309842072678,null,4759433064330161922,8849696642448442688,'2023-12-16','2024-02-18','2024-01-19','2023-12-16','u','h','m','f',null,'n','i','b'),
        (148,7,7,-4,4,-1528546365398989087,878406751783699950,-5873519552663755005,3831259362162200901,'2023-12-13','2023-12-15','2024-01-17','2024-01-08','s',null,'u','c',null,'p','z','c'),
        (149,4,-10,0,-10,null,8357361433200011727,-9173692827007418900,-7200603283707275459,'2023-12-11','2023-12-09','2024-02-18','2026-01-18','c','i','i','w','b','l','v','q'),
        (150,2,0,-10,0,-5825377272342249605,null,-5212665030454190226,-969357951484574036,'2027-01-09','2023-12-17','2024-02-18','2027-01-16',null,'j','i','l','s','g','h','h'),
        (151,-10,0,4,7,-6947893377272167242,null,-6411444504208654865,-1979976902011568550,'2023-12-15',null,'2023-12-09','2024-01-31','i','e','w','m','v','g','f','s'),
        (152,-10,-10,-4,7,6370484431281596431,-8518580439911769132,-7050763773315008926,-6390924258173564173,'2027-01-16','2024-02-18','2025-02-18','2023-12-09','g',null,'f','p','l','n','q','f'),
        (153,-10,9,1,-10,null,null,-7673493355059181431,8477857846738446950,'2026-02-18','2024-01-09','2023-12-15','2023-12-13',null,'i','s','n','p','o','h','w'),
        (154,-4,1,-10,9,-7834679095386913011,null,-3735896019062322969,-4942386992134761207,'2026-01-18','2027-01-09','2027-01-09','2024-02-18','i',null,'v','l',null,'s','p','x'),
        (155,6,3,1,-10,-8297787415300020751,5520768481578535257,-1114470387745182661,-764765837348618453,'2024-02-18',null,'2027-01-16','2026-02-18','g','f','b','e','p','l','d','a'),
        (156,null,9,3,-4,-7432405070463824918,-6693375447762756089,-1986811764636941378,7077340990429825479,'2027-01-16','2025-02-17','2027-01-09','2023-12-20','b','f','f','j',null,'m','w','s'),
        (157,2,3,-4,-10,-8043045030806164917,-7870179836885921967,8761871061746148914,1842089240437598176,'2023-12-16','2024-02-18','2023-12-16','2023-12-10','z','y','v','r',null,'p','x','k'),
        (158,1,0,1,0,null,null,1734010327074713406,1979012233763050208,'2024-01-17','2027-01-09','2025-06-18','2024-01-31','a','g','b','m','w','h','i','z'),
        (159,4,6,-10,3,7192508453543324048,-6493858886834315917,5768439037668650007,221519802612139801,'2023-12-12','2024-02-18','2025-06-18','2025-02-18','w','x','l','h','e','w','j','y'),
        (160,8,6,4,3,-1529328817972905373,null,9029791646209013309,-4505746455681779129,'2023-12-18','2024-01-08','2026-02-18','2023-12-20','u','r','m','r','a',null,'m','x'),
        (161,5,null,2,3,null,7544424000557143615,-6778192840580332023,1593932536200889022,'2023-12-16','2023-12-15','2023-12-13','2025-06-18',null,null,'z','d','c','y','d','c'),
        (162,null,1,6,7,1191103517914911622,-1425723294077995795,-8923934703783583290,-2392525107762314937,'2024-01-19','2024-01-08','2023-12-19','2026-02-18','g','o','t','r','m','o','i','l'),
        (163,3,-4,6,0,null,4958150149198231841,6593245031185906035,-1747221098105687052,'2023-12-14','2025-06-18','2025-06-18','2023-12-17','r','d','b','z','q','s','g','m'),
        (164,-10,3,3,-4,8102016218211253674,7284917939501292395,7564867875027596179,927945446368696584,'2024-02-18','2023-12-12','2023-12-14','2027-01-16','a','f','l','f','k',null,'z','g'),
        (165,null,7,6,-10,null,4355506312577609302,-2705174508623903125,4098801940084898398,'2023-12-09',null,'2023-12-18','2023-12-13','m',null,'j','e','u',null,'i','t'),
        (166,8,2,0,-10,-4990309479252218962,null,3790696393467372822,2391765835488247935,'2024-01-19','2024-01-17','2024-02-18','2023-12-16',null,'e','t','h','b','o','u','e'),
        (167,2,-4,6,-10,-6137076672853547468,null,-2900378247730534940,-2338205081190906530,'2025-02-18','2027-01-16','2023-12-17','2023-12-10','d','c','q','t','d','l','f','m'),
        (168,0,5,-10,7,null,1519973463029064780,-6509976041346963722,886038751462832370,'2023-12-20','2023-12-20','2023-12-12','2023-12-10','a',null,'s','k','k','j','c','n'),
        (169,8,9,5,-10,-511207748233993056,7046983661427344232,-5318962225951558018,-1318222236071998412,'2023-12-19','2023-12-19','2023-12-16','2027-01-09','p',null,'g','y','h',null,'o','l'),
        (170,6,0,7,-4,null,5924995693151446165,2857092396499732737,4719009073079633717,'2023-12-16','2027-01-09','2025-02-18','2024-02-18',null,'a','l','r','c','g','z','r'),
        (171,4,0,1,-10,-5807726131379650488,6259985254657646686,1028606200226150260,2120169321684016642,'2024-01-19','2024-01-08','2023-12-20','2023-12-11','k','c','t','h','t','w','z','n'),
        (172,-4,6,2,-10,-6851025984395220766,-328701344968344845,6218450411210712060,225568743996045356,'2026-02-18','2026-01-18','2023-12-18','2024-01-31','k','m','j','p','g',null,'h','c'),
        (173,null,8,0,2,1642699978568713558,-2568532380212377065,-2082836525352075283,5209217917654654520,'2024-01-17','2026-02-18','2024-01-19','2023-12-17','a','a','y','g','v','u','u','s'),
        (174,-4,4,-4,-10,-2348526840264403896,null,-2977286597882087585,-8430105457775039900,'2027-01-16','2026-02-18','2024-01-09','2023-12-18','b','b','q','g','m','m','x','c'),
        (175,0,-4,5,9,-4097757866510737899,6783793723723705316,261959403170202823,-6825567933941997716,'2024-01-17','2023-12-16','2023-12-16','2026-01-18','q',null,'f','y','g',null,'v','u'),
        (176,-10,2,-10,0,null,null,-140347096143572621,86829518304300526,'2023-12-15','2024-02-18','2023-12-18','2026-02-18','i','o','w','c','w','m','h','g'),
        (177,null,-10,-4,-10,-7615873053221805473,6325575376391465954,5458267994860900945,1669894698302833125,'2023-12-11','2023-12-15','2024-01-31','2024-01-09','e','h','x','y','u','h','f','y'),
        (178,-4,null,0,-10,-3374084688925056163,-8974590571037228863,6173067536220354560,5177723430144022077,'2023-12-17','2025-06-18','2024-01-09','2026-02-18','e','x','y','l','b','l','r','e'),
        (179,-10,3,-4,3,4888772792430910481,-2422846341304380745,-3409113689143764843,-277946275457162521,'2024-02-18',null,'2023-12-15','2023-12-14','k','h','j','c',null,'p','z','z'),
        (180,0,-10,-4,4,4559628989934340783,1169759166701362797,8038493369777588256,-3475228011229159393,'2024-01-09','2026-01-18','2024-02-18','2026-01-18',null,'z','m','m','f','f','v','m'),
        (181,null,-4,-10,4,-7639548024677292410,null,7741850675438233282,4199787323519713824,null,'2026-01-18','2023-12-10','2023-12-13','c','z','u','o','e','d','g','j'),
        (182,4,9,7,-10,-7047837547077595442,-1349401890221094682,-8853431113232879688,-7249128399854997696,'2023-12-19',null,'2023-12-17','2024-01-17','a','p','h','k','y','k','g','k'),
        (183,-10,9,9,3,3193253807762625012,-5090770560149993651,1493502922801515898,1308247327449744618,'2023-12-12','2023-12-17','2023-12-14','2027-01-16','o','r','r','m',null,'f','z','y'),
        (184,3,-10,5,-10,7601150030431055036,-812354007846758385,8625532598119016236,-4767366624796468315,'2025-02-17','2025-06-18','2024-01-19','2023-12-13','x',null,'h','t','b','a','l','l'),
        (185,4,7,9,-10,-6021921667796296429,1218029009091194815,-937139680579393800,-5699041435989644582,'2023-12-20','2023-12-12','2024-02-18','2024-02-18',null,'a','d','p',null,null,'n','a'),
        (186,null,5,0,-4,-4739781826478334628,3448714532477042523,6622887693003280697,-4672628169180526397,'2023-12-10','2023-12-14','2024-01-08','2024-01-08','f',null,'q','u','b','f','y','t'),
        (187,6,-10,4,0,-6552746736645849518,7759107423043535417,-7360918406119053279,-4697591193108461511,'2023-12-10','2023-12-13','2026-02-18','2025-02-17','i','q','l','t','r','f','p','v'),
        (188,1,-10,6,3,2551624430450557094,-9221429894279860380,-4029424833018792759,-2163512570069363981,'2023-12-13','2023-12-11','2023-12-14','2026-01-18','v','j','o','l','e','q','g','k'),
        (189,-10,-4,1,-10,-4266387829623969689,8664598246988494509,-5427197804641841558,2504276125332448414,'2023-12-20','2023-12-14','2023-12-18','2024-02-18','a','r','c','v','g',null,'p','u'),
        (190,-10,-10,1,2,null,-5948265905124383321,-7991503254852671835,-7043212206068634989,'2027-01-16','2023-12-18','2025-06-18','2024-01-17','t','l','z','a','t','a','j','e'),
        (191,0,null,7,1,1548108972526451159,4462555000975404165,4615986075498860358,-1621744719252279787,'2024-02-18','2023-12-14','2024-01-31','2025-06-18','z','r','i','j','n','p','e','m'),
        (192,1,-10,-10,8,-6983097378483968395,-1670182270275689551,1321755971686558697,-4296180545508691666,'2023-12-11','2023-12-15','2024-01-09','2027-01-09','t','l','b','h','d',null,'e','f'),
        (193,-10,9,6,8,4045177501727154496,null,5650317515348191145,-7005853801693584638,'2024-01-31','2023-12-09','2023-12-10','2024-01-31','i','g','n','m',null,null,'u','j'),
        (194,8,-10,-4,2,-6781646106891734793,-4667314839816313423,-6624319356593031557,8007192365744554099,'2023-12-19','2024-02-18','2023-12-14','2027-01-16','c',null,'j','m','v',null,'d','w'),
        (195,null,null,3,5,-9046822387689193037,-5639261652851770842,-2209317473234106988,-5451079706538694578,'2024-02-18','2023-12-12','2024-01-19','2024-01-09','q','j','v','e','h','s','c','s'),
        (196,3,-4,4,4,3194602054453660972,null,-2451730047630426313,3495039411706418770,null,'2023-12-13','2024-01-09','2024-01-09','e','k','m','j',null,null,'k','q'),
        (197,null,null,-4,0,5528277152284673127,null,-6870269485237355163,-4701734578161453960,null,'2024-02-18','2023-12-11','2023-12-18','g','s','a','j','e','j','p','m'),
        (198,2,-4,1,-4,8482784137563371099,664963432144069941,-8513218057058084600,-733752538492864451,'2023-12-17','2023-12-15','2023-12-16','2024-02-18','g','u','r','y','k','r','q','i'),
        (199,-10,-4,3,4,-5342490364422145651,4360392406090046370,6261509186250799159,-7692382056950526338,'2027-01-16','2023-12-09','2025-02-18','2023-12-15',null,null,'q','p','d','p','w','d');
    """

    qt_select_no_need_1 """
    SELECT
        COUNT(DISTINCT table1.col_date_undef_signed_not_null_index_inverted) AS field1,
        (
            (CASE
                WHEN (table1.col_int_undef_signed_not_null - (4 + 1) <> table1.col_bigint_undef_signed)
                    THEN table1.col_int_undef_signed_not_null
                WHEN (table1.col_int_undef_signed_not_null IN (NULL))
                    THEN table1.col_int_undef_signed_not_null_index_inverted * (8 + 1)
                WHEN (table1.col_int_undef_signed_not_null_index_inverted IN (2))
                    THEN DAY(DATE_ADD(table1.col_date_undef_signed_not_null_index_inverted, INTERVAL 8 DAY))
                WHEN (table1.col_int_undef_signed_not_null <= YEAR(table1.col_date_undef_signed_index_inverted))
                    THEN 8
                WHEN (table1.col_int_undef_signed_not_null_index_inverted * (1 + 1) IN (9))
                    THEN table1.col_int_undef_signed_not_null_index_inverted
                WHEN (table1.col_int_undef_signed + (7 + 1) != table1.col_int_undef_signed_not_null)
                    THEN table1.col_bigint_undef_signed_not_null
                ELSE (MONTH(table1.col_date_undef_signed_not_null_index_inverted))
            END)
        ) AS field2,
        table1.col_int_undef_signed_not_null_index_inverted AS field3,
        table1.col_int_undef_signed_index_inverted AS field4
    FROM
        ${table4} AS table1
    LEFT OUTER JOIN
        ${table3} AS table2
    ON
        (table2.col_int_undef_signed_index_inverted = table1.col_int_undef_signed_index_inverted)
    WHERE
        NOT (
                (table1.col_varchar_1024__undef_signed_not_null_index_inverted = 'n')
            OR  (table1.col_int_undef_signed_not_null_index_inverted BETWEEN NULL AND (8 + 8)
            AND table2.col_date_undef_signed_not_null_index_inverted BETWEEN '2000-03-11'
            AND DATE_ADD(table1.col_date_undef_signed_not_null_index_inverted, INTERVAL 9 DAY))
            OR  (table1.col_varchar_1024__undef_signed_not_null_index_inverted <
            table1.col_varchar_1024__undef_signed_index_inverted)
        )
    GROUP BY
        field2, field3, field4
    ORDER BY
        field2, field3, field4
    LIMIT 1000;
    """

    def table5 = "test_index_no_need_read_data5"
    sql "drop table if exists ${table5}"
    sql """
    create table ${table5} (
    col_int_undef_signed_not_null_index_inverted int  not null  ,
    col_date_undef_signed_not_null_index_inverted date  not null  ,
    col_bigint_undef_signed_not_null_index_inverted bigint  not null  ,
    col_bigint_undef_signed_not_null bigint  not null  ,
    col_int_undef_signed int  null  ,
    col_int_undef_signed_index_inverted int  null  ,
    col_int_undef_signed_not_null int  not null  ,
    col_bigint_undef_signed bigint  null  ,
    col_bigint_undef_signed_index_inverted bigint  null  ,
    col_date_undef_signed date  null  ,
    col_date_undef_signed_index_inverted date  null  ,
    col_date_undef_signed_not_null date  not null  ,
    col_varchar_10__undef_signed varchar(10)  null  ,
    col_varchar_10__undef_signed_index_inverted varchar(10)  null  ,
    col_varchar_10__undef_signed_not_null varchar(10)  not null  ,
    col_varchar_10__undef_signed_not_null_index_inverted varchar(10)  not null  ,
    col_varchar_1024__undef_signed varchar(1024)  null  ,
    col_varchar_1024__undef_signed_index_inverted varchar(1024)  null  ,
    col_varchar_1024__undef_signed_not_null varchar(1024)  not null  ,
    col_varchar_1024__undef_signed_not_null_index_inverted varchar(1024)  not null  ,
    pk int,
    INDEX col_int_undef_signed_index_inverted_idx (`col_int_undef_signed_index_inverted`) USING INVERTED,
    INDEX col_int_undef_signed_not_null_index_inverted_idx (`col_int_undef_signed_not_null_index_inverted`) USING INVERTED,
    INDEX col_bigint_undef_signed_index_inverted_idx (`col_bigint_undef_signed_index_inverted`) USING INVERTED,
    INDEX col_bigint_undef_signed_not_null_index_inverted_idx (`col_bigint_undef_signed_not_null_index_inverted`) USING INVERTED,
    INDEX col_date_undef_signed_index_inverted_idx (`col_date_undef_signed_index_inverted`) USING INVERTED,
    INDEX col_date_undef_signed_not_null_index_inverted_idx (`col_date_undef_signed_not_null_index_inverted`) USING INVERTED,
    INDEX col_varchar_10__undef_signed_index_inverted_idx (`col_varchar_10__undef_signed_index_inverted`) USING INVERTED,
    INDEX col_varchar_10__undef_signed_not_null_index_inverted_idx (`col_varchar_10__undef_signed_not_null_index_inverted`) USING INVERTED,
    INDEX col_varchar_1024__undef_signed_index_inverted_idx (`col_varchar_1024__undef_signed_index_inverted`) USING INVERTED,
    INDEX col_varchar_1024__undef_signed_not_null_index_inverted_idx (`col_varchar_1024__undef_signed_not_null_index_inverted`) USING INVERTED
    ) engine=olap
    UNIQUE KEY(col_int_undef_signed_not_null_index_inverted, col_date_undef_signed_not_null_index_inverted, col_bigint_undef_signed_not_null_index_inverted, col_bigint_undef_signed_not_null)
    PARTITION BY             RANGE(col_int_undef_signed_not_null_index_inverted, col_date_undef_signed_not_null_index_inverted) (
                    PARTITION p VALUES LESS THAN ('-1', '1997-12-11'),
                    PARTITION p0 VALUES LESS THAN ('4', '2023-12-11'),
                    PARTITION p1 VALUES LESS THAN ('6', '2023-12-15'),
                    PARTITION p2 VALUES LESS THAN ('7', '2023-12-16'),
                    PARTITION p3 VALUES LESS THAN ('8', '2023-12-25'),
                    PARTITION p4 VALUES LESS THAN ('8', '2024-01-18'),
                    PARTITION p5 VALUES LESS THAN ('10', '2024-02-18'),
                    PARTITION p6 VALUES LESS THAN ('1147483647', '2056-12-31'),
                    PARTITION p100 VALUES LESS THAN ('2147483647', '9999-12-31')
                )

    distributed by hash(col_bigint_undef_signed_not_null_index_inverted)
    properties("enable_unique_key_merge_on_write" = "true", "replication_num" = "1");
    """
    sql """
    INSERT INTO ${table5}(
      pk,
      col_int_undef_signed,
      col_int_undef_signed_index_inverted,
      col_int_undef_signed_not_null,
      col_int_undef_signed_not_null_index_inverted,
      col_bigint_undef_signed,
      col_bigint_undef_signed_index_inverted,
      col_bigint_undef_signed_not_null,
      col_bigint_undef_signed_not_null_index_inverted,
      col_date_undef_signed,
      col_date_undef_signed_index_inverted,
      col_date_undef_signed_not_null,
      col_date_undef_signed_not_null_index_inverted,
      col_varchar_10__undef_signed,
      col_varchar_10__undef_signed_index_inverted,
      col_varchar_10__undef_signed_not_null,
      col_varchar_10__undef_signed_not_null_index_inverted,
      col_varchar_1024__undef_signed,
      col_varchar_1024__undef_signed_index_inverted,
      col_varchar_1024__undef_signed_not_null,
      col_varchar_1024__undef_signed_not_null_index_inverted)
    VALUES
    (0,-4,2,5,9,1597656363509768688,null,3477062685138998670,4767688554724266649,'2024-02-18','2026-02-18','2026-01-18','2023-12-14','p','k','e','r','u','v','r','r'),
    (1,null,-4,6,6,null,7053826899060545018,-1737102912815425073,-5764949869476544269,'2025-06-18',null,'2023-12-11','2023-12-11','h','k','t','i','w','o','y','g'),
    (2,null,1,-4,4,-8335129479222173285,-7566068947847872996,-39411413887182943,-7512882586003478045,'2025-06-18','2023-12-15','2026-02-18','2023-12-17','p','f','p','q','x',null,'e','a'),
    (3,null,-10,2,-4,8010755982890395310,1559081802508005052,-8715541722086947818,678744477444498899,'2023-12-20','2023-12-17','2023-12-18','2023-12-19','z','e','p','i','u',null,'j','j'),
    (4,5,null,1,-4,-7228047648562902143,null,7050675995302884140,-8968510540616847830,'2027-01-16','2023-12-12','2023-12-20','2023-12-14','l','a','b','j','k','y','c','a'),
    (5,-10,0,4,-4,5074228085074203422,null,8120013656225175775,-320006342449097163,'2023-12-15',null,'2024-02-18','2024-01-17','c',null,'u','r',null,'s','k','k'),
    (6,5,-10,8,0,1115357658589189764,8343874302818886013,8698472252924308100,-7002542535281181212,'2024-01-31','2023-12-17','2023-12-20','2023-12-15','j','h','y','b','m','a','t','a'),
    (7,-10,-10,1,9,1488620132479970379,-469205316727634966,-1498719844048617134,-231574019079462849,'2025-06-18','2024-02-18','2025-06-18','2023-12-20',null,'z','c','b',null,'i','g','r'),
    (8,2,-10,4,-10,-3850478684533807957,null,7047793190400950615,7523455668733189832,'2024-02-18','2023-12-18','2023-12-11','2023-12-09',null,'s','j','y','y','r','h','c'),
    (9,-10,-10,-10,-10,null,null,3435485933063741398,1788726098902371670,'2024-02-18','2024-02-18','2023-12-15','2023-12-20','y',null,'c','c','a',null,'q','i'),
    (10,3,null,6,-10,8777553935583969387,-3482077951326156517,3901651770999202399,2865780292497180496,'2024-01-17','2023-12-17','2023-12-20','2024-01-17','s',null,'e','d',null,'m','x','d'),
    (11,2,0,3,3,-6644405142947020693,null,3067064004989127913,7607548084217601403,'2024-02-18','2025-02-18','2023-12-17','2023-12-12','l','t','u','d','y','d','s','x'),
    (12,null,0,-4,-4,-4872417135400422116,1205495085375795978,-7702512424546554268,-7600835650766273516,'2023-12-19','2025-02-18','2023-12-12','2025-06-18','p','l','b','l',null,'f','h','j'),
    (13,null,null,-10,2,null,-699882169918477984,-2180291753730440488,3271789779065464999,'2023-12-18','2025-02-18','2024-02-18','2023-12-18','b',null,'t','w',null,'t','k','e'),
    (14,9,-4,-4,-10,null,null,-5156308894935799537,-6032268031644144468,null,'2024-01-09','2023-12-20','2023-12-10','a','a','i','x',null,'j','c','d'),
    (15,6,-10,1,2,-3338081029023625464,null,1072509329519376549,-6633612545261775452,'2023-12-19','2026-01-18','2024-02-18','2024-01-31','g','e','n','j','i','d','v','e'),
    (16,-10,3,0,-10,-1742529706030341317,1056826562732178058,-5364229721598921904,6893536832961113233,'2024-02-18','2024-01-17','2024-01-31','2027-01-09','m',null,'z','p',null,null,'l','l'),
    (17,2,-4,7,-4,2592405093302233664,1608435584399428122,-6426429174505417004,-7544346517252924507,'2023-12-19',null,'2023-12-16','2025-02-17','p','h','l','n','k','z','f','b'),
    (18,null,1,0,8,-3573421517528334090,7811565869245468089,-5446226584934144420,-8413430202286478431,'2024-01-09','2023-12-18','2023-12-16','2026-01-18','x','d','h','d','l','b','w','v'),
    (19,-4,9,8,3,-7125926251423688718,6341224698131984819,-3371654985950559359,1199793145261479561,'2023-12-13','2024-01-17','2023-12-17','2027-01-09','u',null,'q','c','w',null,'e','a'),
    (20,4,-4,-4,6,807962263040457164,9055398770010878103,3797035456323434216,-8416209988958337787,'2024-02-18','2025-02-17','2023-12-11','2025-06-18','m','h','l','w','z','d','l','o'),
    (21,null,5,6,0,-2629528750940912658,8962173047011554525,-5906507312435721614,-1786047889497973187,'2023-12-10','2023-12-11','2024-01-19','2023-12-20',null,null,'l','w',null,'w','m','e'),
    (22,4,6,6,2,-7631688882022577635,7055215301860175948,-3514252823980272726,-7523286580831237711,'2024-01-08','2024-02-18','2023-12-16','2023-12-13','s',null,'w','m','l',null,'p','o'),
    (23,null,7,6,0,7615656268832605572,-1564610451171981620,-1768817764471954975,-3374849624752145210,'2023-12-16',null,'2024-01-09','2024-01-17','m','t','g','u','j',null,'i','b'),
    (24,5,-4,-10,2,null,8383349808088957594,2526137371271116192,-6744509714081498854,'2024-02-18','2024-01-08','2025-02-17','2025-02-18','p','a','a','n',null,null,'o','n'),
    (25,4,-4,8,-10,-1835042141820830937,4299716784649675069,-3825578274899731320,-1153050820367606492,'2023-12-18','2023-12-20','2023-12-18','2023-12-16','h','c','q','m','d','s','x','b'),
    (26,-10,6,8,6,null,-6641277582431037683,-829195265364748673,4291956542269552120,'2026-01-18',null,'2027-01-09','2026-01-18',null,null,'p','z','v',null,'t','v'),
    (27,1,-4,0,-10,7147924798526829963,-3008886870901963502,-5500938975328560818,-2937658153167169603,'2023-12-09','2023-12-19','2023-12-18','2023-12-16','r','j','x','b','j','d','f','x'),
    (28,3,null,-4,2,null,-542393139344341007,7266425618829254654,5986215015408735830,'2024-01-17','2026-01-18','2023-12-17','2024-01-09','l','c','u','h','s','j','x','i'),
    (29,7,2,-10,0,-2449149726449808461,-3263550110416390547,-743239754115289378,-6439435143295813193,'2023-12-16','2027-01-16','2024-01-17','2023-12-19',null,'c','k','l','z',null,'b','s'),
    (30,-4,9,-4,-4,null,null,3327862269223543080,-4876768748977414760,'2023-12-12','2023-12-20','2024-01-17','2023-12-10','k','y','f','k','p','r','p','q'),
    (31,-10,null,2,-10,7580116570554820877,5031256557141064246,-6329653075431116966,-5300877392863357434,null,'2024-01-17','2023-12-12','2024-02-18','m',null,'q','v','x','j','h','d'),
    (32,null,1,-10,8,null,-8910494162141897995,-1594355786045379063,-7577140151237538169,'2023-12-10','2024-02-18','2026-02-18','2024-02-18','k','b','b','i',null,'l','b','k'),
    (33,3,9,9,-4,8558413542094480695,null,5454006440161012701,5465596246096425615,'2023-12-12','2027-01-16','2026-01-18','2023-12-18','z','i','s','t','w','s','p','m'),
    (34,null,3,-4,9,-3010619115778084208,null,3478014528649114415,-7736271480300818538,'2024-02-18','2023-12-10','2026-02-18','2023-12-20','n','z','j','z','q','u','b','p'),
    (35,-4,6,-10,9,954804292729401716,-9177735606051525480,-2924826934324258500,1168033231532738708,'2026-01-18','2024-01-19','2027-01-16','2023-12-09','q','v','w','k','f','v','q','p'),
    (36,2,4,9,0,2013170980145920580,999602803052914907,3619616622626928675,-4931185426999669275,'2027-01-09','2023-12-18','2023-12-11','2023-12-19','i','w','d','s','y','s','a','c'),
    (37,null,0,-10,4,null,746975401946864323,7974370266159571784,6417345951614161873,null,'2024-02-18','2026-02-18','2023-12-12','j',null,'t','d',null,'p','t','g'),
    (38,-10,2,1,8,-7233548971026614838,-6998803048128269781,-6224763644067194679,6465385609683877470,'2023-12-10','2024-01-17','2027-01-16','2024-01-17','l',null,'g','g','z','q','q','v'),
    (39,-4,-10,-10,-10,-5932136785653398141,-3208434148480417252,-1734025653531583913,8896034426611488543,null,'2025-06-18','2023-12-15','2027-01-09','y','s','e','u','q','s','k','u'),
    (40,-10,null,4,7,-1256893551175421503,-3000730495395157134,-1519983435545895221,7798176241963370987,'2024-02-18','2024-02-18','2023-12-16','2027-01-09','y','f','q','j','f','i','k','z'),
    (41,2,8,4,5,-6545233055337701627,4907365368129133967,2290149502268826972,-7991158197751177069,'2026-01-18','2023-12-09','2024-02-18','2023-12-13','d','w','g','e','i',null,'z','k'),
    (42,3,3,8,2,-6578508965441022011,-7880264496047938709,-8543331693692098430,3531910304092149753,null,'2023-12-12','2026-01-18','2023-12-14','p','c','v','a','p','e','d','v'),
    (43,null,4,-10,0,2725457917653505854,8557846150925997359,2807099962181418709,-3588427962483885672,'2025-02-18','2023-12-15','2025-02-18','2023-12-11',null,'n','b','h','a','y','t','x'),
    (44,null,9,-4,1,7283131058306208552,3978372352631598410,247592582266331249,-6817649122949614629,null,null,'2023-12-11','2024-02-18','i','w','c','e','z','e','o','b'),
    (45,5,null,5,-10,null,3373140005405369242,-631199712244554305,-7578881427032213857,'2023-12-09','2023-12-14','2023-12-11','2024-01-31','q','m','a','c','t','i','n','i'),
    (46,4,-4,-4,-10,-5299659623795961390,null,-5444894524037635939,50523792215487445,'2025-02-17','2026-01-18','2024-02-18','2024-02-18',null,'q','s','m','s','u','a','s'),
    (47,-10,null,2,-10,-4508372775109055189,-3176231319264991284,1502833318832087148,6068460913232380144,'2023-12-19','2024-01-19','2026-01-18','2023-12-09','f','v','c','b','n','i','i','w'),
    (48,5,6,0,-10,-5233536567112695291,-6445712292797537361,4999849878272342015,8552570538725511161,'2023-12-10','2023-12-15','2023-12-16','2026-01-18','i','t','w','m','z',null,'i','e'),
    (49,3,null,2,6,null,null,-8176466338515914718,7620389308374960017,'2024-01-08','2025-06-18','2023-12-20','2023-12-18','k','h','r','u','c','q','w','x'),
    (50,-10,-10,6,9,6181345825903272689,7703063180672679128,5106241172121684908,-8644759987673741100,'2024-01-09','2023-12-15','2023-12-09','2024-01-09','f','q','j','i','t','w','o','i'),
    (51,5,-4,-4,0,4256799320317438592,null,1978308330977146209,2982804202006508033,null,'2023-12-09','2025-06-18','2024-01-09',null,'m','p','q','p','j','l','a'),
    (52,3,-4,-10,9,-2047182625461489786,3121447715492634274,5686266365055546679,-9098056376826909848,'2023-12-15','2023-12-17','2026-02-18','2025-02-18',null,'o','m','o','w','w','t','i'),
    (53,9,4,-4,7,1556963964948837322,6602307728457743664,8655113278003697971,-2731426198260190940,'2023-12-10','2023-12-20','2024-01-08','2023-12-10','c','v','r','o','o','c','h','c'),
    (54,2,8,5,9,null,null,5406301970195893182,2283742809491369318,'2023-12-13',null,'2027-01-16','2024-01-09','u','q','j','t',null,null,'r','w'),
    (55,-10,-4,-10,1,-6471529263738757839,7138548307278202012,-5655806087672683329,6695631602579507718,null,null,'2025-06-18','2023-12-11','t','b','g','c','v','a','u','d'),
    (56,-4,-4,-10,-10,6317667989348451736,null,2623552082300546510,-8945506938562134909,'2026-01-18','2023-12-17','2024-01-09','2023-12-16','c',null,'b','v','y','n','o','o'),
    (57,9,9,3,6,7349199604579581785,7288848375256119970,3606236740994390683,5551478440501298432,'2023-12-16','2023-12-20','2026-02-18','2027-01-16','b',null,'z','g','l','c','o','q'),
    (58,-10,null,8,0,null,null,-761254702887054559,4930367676733214645,'2023-12-20','2023-12-15','2023-12-10','2023-12-12','h','k','e','y','t','o','p','x'),
    (59,0,9,5,4,-3476143564679256164,-2866224544284803007,6055459760545202690,1419923708614798489,'2023-12-12','2025-06-18','2024-01-17','2023-12-13','i','z','r','s','i','i','k','m'),
    (60,1,6,6,-10,null,null,-6090932991204929047,-7330518274177368125,'2023-12-14','2023-12-17','2026-01-18','2024-02-18','u','k','o','i','r',null,'c','m'),
    (61,3,4,6,0,null,null,6121442649727188254,944733113920004887,'2024-01-17','2025-02-18','2026-02-18','2023-12-10',null,'c','z','a',null,'t','x','a'),
    (62,null,-4,5,5,4761777570282150780,6443284183605307399,8016007167227007191,2288156563893925798,null,null,'2023-12-12','2024-02-18','z','d','n','p',null,'u','q','y'),
    (63,-4,7,0,-4,-4692283756697162205,-4515985465229046211,-3481582668995753148,1673346934739622588,'2026-02-18','2023-12-15','2027-01-09','2023-12-11','m','l','h','l',null,'r','q','e'),
    (64,-4,0,1,6,4133590807288956396,5708085989361370856,2896879018431987932,5697875663488013740,'2024-01-19','2023-12-15','2025-02-18','2026-02-18','i','x','s','j','v','a','o','j'),
    (65,0,7,-4,5,-5853817091760814964,-2376936740476715030,6572485125767797939,1852795436897151008,null,'2024-01-17','2023-12-17','2023-12-17','j','z','m','y','w',null,'r','v'),
    (66,3,-10,9,-4,null,-8468868073609358107,-2916275337502665940,-7235895390022353046,'2024-02-18','2023-12-09','2024-01-09','2023-12-09','x','a','l','e','p',null,'n','c'),
    (67,-10,-4,6,5,742158889813554037,null,-8428771853332272228,-4554858204337103174,'2024-01-31','2025-06-18','2023-12-12','2023-12-11','f',null,'z','s',null,'j','k','a'),
    (68,9,-4,7,4,-4856859345791266223,-3610029513132479662,6887693797370118503,7904195769271751685,'2023-12-17','2023-12-12','2025-06-18','2024-01-17','i',null,'x','a','z',null,'z','v'),
    (69,9,1,6,3,5572751762070059418,-4509942009300363968,3408045521058488016,-3352800658704292744,'2023-12-12','2025-06-18','2024-02-18','2026-02-18','k','q','l','s','l','i','g','k'),
    (70,4,3,0,-4,4441537213492795994,-6837872668252503022,8754263795362719670,-3618348956417291488,'2026-01-18','2023-12-12','2023-12-12','2023-12-17','e','n','x','d',null,'p','d','l'),
    (71,4,8,-4,-10,null,-2936401583776579064,-960140797891425104,-4833342212206306015,null,'2023-12-10','2023-12-10','2023-12-12','e','q','i','t','f',null,'v','h'),
    (72,7,3,-10,7,8771853032688093527,7000827174982085596,1106894299028158001,-1466852027370745758,'2024-02-18','2024-01-08','2024-02-18','2026-02-18','v','h','c','z','b','z','r','o'),
    (73,0,7,3,7,null,7665290937673679628,5020755453397402790,-9052067807739605901,null,'2024-02-18','2024-01-19','2025-02-18','r','g','a','v',null,'f','g','g'),
    (74,9,-10,-4,6,-8310303623034423210,null,3339638706507555663,8929196675973262374,null,null,'2026-02-18','2027-01-16','w',null,'m','d','p',null,'l','o'),
    (75,null,-10,4,-10,-2365312291705438354,721650033830007864,-8010384940553332493,-7315481204829773559,'2023-12-19','2025-02-17','2024-02-18','2027-01-16',null,'q','b','j','i','w','f','a'),
    (76,-4,4,3,7,1424090740450050572,6064167505669826418,3785000820927952491,-5157609009382905119,'2023-12-17',null,'2024-02-18','2023-12-19','w','a','f','z','x','l','m','g'),
    (77,-4,0,0,4,null,-7839431906416932985,-8241441269452161831,-1074219681504881915,null,'2024-01-17','2023-12-19','2023-12-14','h','g','k','f','c',null,'p','b'),
    (78,-10,9,6,-10,null,null,991384140128589590,5423891201283362272,'2023-12-20','2023-12-18','2024-01-08','2023-12-13',null,'w','x','n',null,null,'a','q'),
    (79,3,null,-4,-10,-7593115752679173787,-2401174188585496004,-4671607850619222855,2072871780706154773,'2023-12-18','2025-06-18','2024-01-09','2023-12-16','e',null,'h','i',null,'z','y','j'),
    (80,9,-10,-4,5,-6717936580784600387,-8864400986459794599,5607803677297367161,-4512637978159501369,'2024-01-17','2023-12-09','2024-01-19','2025-02-18','v','c','z','f','e','d','c','f'),
    (81,-10,2,3,-4,4445108204526380252,-1944978576532723771,6960203199500619727,-6857756663640247847,'2023-12-16','2024-02-18','2025-06-18','2023-12-20','j','g','s','n','f','p','u','u'),
    (82,-10,8,-4,-10,306086597829979006,-7764436285885729668,7199307167487778664,-4346111357847361278,'2023-12-11','2024-01-19','2024-02-18','2023-12-16','l','a','c','b','t',null,'m','m'),
    (83,6,-10,-10,7,null,null,4681732537204023355,-2356289738487739660,'2027-01-16','2025-02-17','2023-12-14','2024-02-18',null,'a','x','c','m','f','n','m'),
    (84,3,3,-4,6,null,-2267396918546902495,-3794107337343519595,5489824928006690762,'2023-12-13','2025-06-18','2027-01-09','2024-01-08',null,'b','e','i','y','z','k','a'),
    (85,9,5,-4,8,2754606819843992474,null,4602870889071333012,37418768839981613,'2023-12-09','2023-12-10','2025-02-17','2023-12-15',null,null,'a','w','y','u','q','o'),
    (86,null,1,-10,0,-1435450961364862552,null,-7095245157900477894,-1707639265992074971,'2024-01-08','2027-01-16','2024-02-18','2024-02-18','j','c','w','l','q','x','g','b'),
    (87,null,3,7,5,null,-6074479408089430595,-4012702043255751698,5078569345217983823,'2023-12-10','2024-01-17','2024-02-18','2027-01-09','f','y','f','j',null,'l','n','q'),
    (88,9,3,-10,3,null,-8658291299982526624,7233410715991104575,4930722601630283273,'2023-12-15','2027-01-16','2023-12-14','2023-12-16','e',null,'i','y','i','a','c','l'),
    (89,0,-10,4,-4,null,null,-6155233165769459400,-6625601304745147905,'2025-06-18','2023-12-12','2023-12-09','2023-12-12','x','t','b','w','g',null,'y','n'),
    (90,-4,6,-4,1,null,-8617440068868400881,-4485853795881177636,264072083999789066,'2025-02-18','2023-12-18','2023-12-18','2025-02-17','o','j','z','x',null,'l','u','s'),
    (91,7,-10,1,7,-9019770589671961763,1920836416049425798,-7522973294659152929,7537609464607333461,null,'2023-12-17','2024-01-17','2025-02-17',null,'l','c','r',null,'c','b','j'),
    (92,-4,-4,7,6,null,5973348904354699196,4670920932196484283,-1668561480447954116,'2023-12-14','2027-01-16','2025-06-18','2025-02-17','r','j','b','u','i','x','w','o'),
    (93,null,4,-4,7,null,-4002470210049864765,-3320259876617826113,8019053216705563620,'2024-01-31','2025-06-18','2025-06-18','2023-12-15','b','a','e','l',null,'r','s','l'),
    (94,8,9,3,3,-4208341743050238193,null,1949965884731430715,-7273032402169870685,'2025-06-18','2025-06-18','2024-01-08','2024-02-18','t','a','j','s','l','j','w','i'),
    (95,-10,3,0,9,-3332754049963506751,null,-2974393052443111635,4364335977203883677,'2024-01-19','2023-12-12','2025-02-18','2024-01-17','o','r','r','y','c','x','a','q'),
    (96,null,8,9,3,null,null,663336051869955165,6976629635589261895,'2023-12-16',null,'2024-01-19','2027-01-16','e','k','m','c',null,'g','m','r'),
    (97,null,-10,-10,0,-8289828820107282666,5926161235243845848,8470343316244700603,1302036978922211535,'2023-12-09','2024-01-09','2023-12-20','2024-01-19',null,'w','s','x','w',null,'f','q'),
    (98,4,2,0,3,-3715538877788459979,-9190418477109888977,4382057664321747152,-1064550769607271072,'2024-02-18','2026-01-18','2025-06-18','2025-06-18','c','u','e','y','b','k','a','v'),
    (99,3,null,0,-10,null,-2717638308070185546,1939642534293404539,4264581035985789940,'2023-12-19','2024-01-17','2023-12-20','2024-01-17','b','t','d','n','v','u','l','z'),
    (100,null,2,1,5,3610690374202771529,-65630678031649762,-8111611953254798410,4886532844447605188,'2023-12-11','2023-12-17','2024-01-08','2023-12-15','s','k','p','f',null,'m','f','c'),
    (101,1,2,-4,0,6298014739515619507,null,2249013880376945054,-8785251321380163910,'2024-02-18','2023-12-12','2023-12-13','2023-12-20','m','o','c','b','r','l','e','r'),
    (102,0,6,-4,5,null,null,-5914589146684811638,-6506602557176795091,'2023-12-17','2023-12-12','2026-01-18','2027-01-09','b','q','f','e','n','x','g','k'),
    (103,2,null,9,-10,3692325208140934961,6021723988093225073,3325184039956336836,-7256277607023347532,null,'2023-12-13','2024-02-18','2023-12-16','e',null,'p','a',null,'a','b','r'),
    (104,3,9,1,9,-1092237939237856663,null,5835090792412231732,-1403278698098707106,'2026-02-18','2024-02-18','2027-01-09','2023-12-15','k','i','i','j','w','w','z','y'),
    (105,-4,3,0,4,2629031497687628595,1106039974161625029,-2893347664144425108,-682537518243160504,'2023-12-16','2027-01-16','2023-12-09','2023-12-18',null,'x','h','x','o','a','n','f'),
    (106,0,null,9,-10,7712777176591749667,1579003848843259169,-1687980317468168178,191713866060282576,'2023-12-17','2023-12-09','2024-01-08','2023-12-17','u',null,'i','q','k',null,'j','g'),
    (107,-10,2,6,2,-7478612125444333456,-8310903471187624796,1089753572611045696,3970516260861757491,'2024-01-19','2023-12-17','2025-06-18','2024-01-09','e','h','c','s','e','m','x','n'),
    (108,6,2,2,9,null,null,-2299227022974551707,3205317392825455148,'2024-02-18','2024-02-18','2024-02-18','2025-06-18',null,null,'m','a','i','n','c','w'),
    (109,null,-10,3,8,-4296670671937804740,null,5547572807280690648,8094928857339230973,'2024-01-08','2024-02-18','2025-06-18','2024-02-18','u','x','x','e','s','r','z','b'),
    (110,2,8,6,1,-8626378428774269851,4506129639818138593,7819550333726849119,-2459745184222176583,'2025-06-18','2023-12-18','2024-01-17','2026-02-18','i','k','x','e','n','w','g','l'),
    (111,-10,5,-4,-10,-366126235548744225,6896351375005321993,-2399619867834539388,818054328438546892,'2023-12-17','2023-12-10','2025-02-17','2024-01-08','b',null,'h','n','s','g','u','c'),
    (112,2,0,6,6,null,4857550115555702390,-2825930969154779767,-2783207812388226187,'2024-01-17','2023-12-11','2024-01-08','2023-12-09','v',null,'n','f','p','p','e','b'),
    (113,-10,-4,-10,-10,2594465045540922784,4166877316229219774,-983343959804404413,-2674692597364779311,'2023-12-15','2025-02-18','2023-12-18','2027-01-16','n',null,'r','q','a','t','f','y'),
    (114,null,null,8,-4,-4840657534200157093,null,9080131697764981436,6360062755005734256,'2023-12-14','2027-01-09','2025-06-18','2026-02-18','m','q','x','k',null,'d','m','v'),
    (115,0,-10,-4,4,null,null,2832706043832702323,3660467846170871044,null,'2026-01-18','2025-06-18','2023-12-20','h','y','u','s','w','m','z','m'),
    (116,-4,0,0,-4,-5062412393787995484,null,5134623649933706655,-8106300663225367493,'2023-12-19','2027-01-09','2023-12-09','2024-01-08','g','e','f','c',null,'p','r','q'),
    (117,1,0,0,3,5592014993495047282,-3931766274868155600,-8355636459572913690,-8406779578663919972,'2023-12-13','2023-12-10','2024-01-19','2024-01-17',null,'l','x','t','e','l','m','e'),
    (118,6,4,2,6,2125017845398329243,null,-2138972478789514959,-6124342358027041063,null,'2024-01-09','2023-12-12','2025-06-18',null,'b','y','o','e','o','b','h'),
    (119,6,1,4,-10,null,4929311554657213007,-4681829106988135668,5362829677913412786,null,'2026-01-18','2024-01-08','2025-06-18',null,'f','h','t',null,'l','t','t'),
    (120,0,null,5,7,3506695328876632459,3911410784417939002,2658048973434057434,8406237978609022397,'2025-02-18','2024-02-18','2027-01-16','2024-01-09',null,null,'j','v','q','h','j','e'),
    (121,3,-10,1,7,null,7190205388012904033,-5817537367405959127,-1020684850820413392,'2025-06-18','2024-01-19','2024-02-18','2026-01-18','v','o','p','k','b','h','k','j'),
    (122,5,-4,7,8,-1700077098175223936,8773274409492191687,-1580281629115092293,4246514602112547054,'2025-06-18','2025-02-17','2024-01-31','2024-02-18',null,'g','z','c','e','e','u','z'),
    (123,0,6,-10,-4,2162807918426833539,null,-2273338296102402820,6752333019540761174,'2025-02-18','2027-01-16','2023-12-09','2025-06-18',null,null,'q','r','m','r','m','n'),
    (124,3,null,4,8,null,null,-3521132648044090919,1529428401787745839,'2024-01-17','2023-12-20','2023-12-18','2023-12-09',null,'d','a','d',null,'p','m','e'),
    (125,-4,-4,1,-10,5725123748364212788,-8797826498139803462,1878684469497435680,-7298908483924091680,'2023-12-15',null,'2027-01-09','2026-01-18','e',null,'g','s','j','y','w','l'),
    (126,0,5,5,6,null,9054709399415664499,-3486870500120725193,6126048631547082737,'2023-12-17','2023-12-11','2024-01-31','2024-01-09','v','g','m','s','w','p','d','j'),
    (127,9,0,2,0,null,8942822845613726384,4995196744774327167,8433991630030909356,'2024-02-18','2024-01-09','2023-12-12','2027-01-16',null,'g','x','w','l',null,'b','j'),
    (128,7,7,7,4,-7972355990151827559,4711909865339148552,-8911813427278762848,-3759092287096189259,null,'2023-12-15','2023-12-16','2024-01-31','q','d','z','y','u','r','a','j'),
    (129,9,0,4,0,6367621032781589130,-6499766435777709673,-1484957242194242355,5402739757204439244,'2024-02-18','2024-01-31','2025-02-18','2023-12-15','x','r','d','o','r','d','b','e'),
    (130,-10,7,3,-4,-3746234806372376483,6732140003803355082,-3318866882156566009,-3838622433860004974,'2024-01-19','2025-06-18','2023-12-13','2024-01-08','u','z','k','p','m','f','x','g'),
    (131,-10,null,2,2,-6550332796474691666,8750776030616320942,5110965470133359614,3119851742555585121,'2024-02-18','2023-12-14','2027-01-09','2024-01-09',null,'s','j','f','x','j','a','r'),
    (132,-4,1,5,-4,null,679077130089901711,-984454136175668176,6397247872629308672,'2024-02-18','2023-12-12','2025-06-18','2024-02-18','o','g','v','n','d','b','k','j'),
    (133,-4,1,-10,4,-3696259358570368695,1206706047036150684,7667786965778890757,-7652409133256645575,null,'2023-12-14','2024-02-18','2024-02-18','n',null,'c','p','f','w','j','q'),
    (134,4,-10,7,1,908535686674553583,null,-6290652194169323958,-2997949504357225773,'2024-02-18',null,'2026-02-18','2023-12-14','a',null,'k','f',null,null,'g','d'),
    (135,-4,0,5,-4,null,6194656864067365909,4813123536445184753,-2629564069304520051,'2027-01-09','2023-12-20','2024-02-18','2025-02-17','w',null,'y','r','d','w','e','n'),
    (136,7,-4,1,-10,2982861183121414308,-4106511130653738303,2539422496382131229,8111092151184229840,null,'2023-12-11','2027-01-16','2027-01-09','f','j','t','j','j','t','s','b'),
    (137,6,5,-4,2,-4282878903975621428,1519914029575735331,4670547705395860123,346204075283741910,'2025-02-17','2024-01-19','2024-01-19','2023-12-16','n','x','o','d','y',null,'v','r'),
    (138,-10,6,-4,3,-2627987086202135413,-2510575846444534365,6360971244692027207,7139867382333367844,'2026-01-18','2025-02-18','2024-01-08','2024-02-18',null,'f','e','b','o','a','j','h'),
    (139,-4,-10,7,5,null,975380043598036224,-6880208129883758510,2486741216523538476,'2023-12-14',null,'2025-02-17','2023-12-15','c','i','x','f','d','w','b','b'),
    (140,5,1,-4,0,null,-4952653379251796433,-3286944253975051178,-8549343418883589239,'2024-01-09','2025-06-18','2024-02-18','2027-01-16',null,null,'c','f','b',null,'d','x'),
    (141,7,1,-10,0,5086478114600681828,-5201319921574415614,-2204487312248588450,-3207029867417760247,'2023-12-20','2024-01-17','2023-12-15','2025-02-18','n','e','y','d','v','z','t','w'),
    (142,null,5,0,3,8252570654818719163,null,7983773335064801710,-750986034245303651,'2026-02-18','2027-01-16','2025-06-18','2023-12-17',null,'q','x','p','n','c','r','g'),
    (143,8,4,5,-10,-365465944660365439,-183557135648908705,-8890900780744889749,4207266976034775271,'2023-12-20','2024-01-08','2023-12-13','2024-01-08','a','l','x','e','r','x','a','m'),
    (144,1,3,0,-4,null,null,-3003583898618633821,-2134443998905890217,'2023-12-18',null,'2026-01-18','2024-01-19','y','i','b','l','d','q','a','z'),
    (145,-10,-4,9,6,null,1063197137839502471,6789287364811254763,2999056594023717173,'2023-12-15','2023-12-16','2027-01-09','2026-01-18','l','s','e','u','k','t','i','c'),
    (146,-4,null,9,6,1174175580763355522,6451487696701039815,8749915704166793287,-6889714363690204814,'2025-06-18','2026-01-18','2025-02-18','2023-12-11','d','l','a','e','t','o','o','h'),
    (147,0,0,2,7,null,2754818255120865492,798097121363636191,5600317566757932613,'2023-12-09','2027-01-09','2027-01-09','2024-01-19','o','w','y','e','l','t','h','b'),
    (148,null,-4,1,4,5636862055771309412,-3497705340154107819,3667401486513577297,6011150604009607627,'2023-12-20','2023-12-14','2025-06-18','2023-12-19','y','u','m','d','m','b','p','k'),
    (149,5,-10,2,-10,null,-2950882735050599937,7847714559028630649,4201975068094453643,'2023-12-20',null,'2023-12-16','2026-01-18','v','j','t','i','u','h','e','q'),
    (150,1,-4,3,-4,-6287076248939275564,-947862405873888712,-1243932433054210590,1044080321945027921,'2026-02-18','2023-12-14','2024-02-18','2025-06-18','j',null,'x','w','n','p','v','p'),
    (151,-10,0,5,7,-3044173387256889969,-5803258380558763516,1703274450984585284,1588386069242029591,'2026-02-18','2026-02-18','2024-01-17','2023-12-11',null,'v','e','q','o',null,'p','s'),
    (152,-10,0,-4,6,7553774732262232437,1404490877015387722,3444629383444136689,87986376813159460,'2024-01-19','2027-01-09','2025-02-18','2023-12-10','d','b','l','r','u',null,'y','e'),
    (153,-4,1,6,4,-7717895501491809691,-6366519603386418519,-1652144517267348508,6613800408292501893,'2027-01-16',null,'2023-12-12','2023-12-11','b','m','b','k','m',null,'z','d'),
    (154,3,-4,1,9,null,null,-1789847673469739047,7884953486102558099,'2023-12-17','2023-12-10','2023-12-09','2023-12-19',null,'j','n','m','z','f','l','y'),
    (155,-4,6,9,9,-8976962603287659887,6674492652157048443,-2257152036746091193,-346483294692792388,'2025-06-18','2025-02-18','2024-01-17','2023-12-19','n','e','u','s',null,'x','a','r'),
    (156,null,-10,5,2,-2050721669014616848,null,2019753248619260783,-8569139418417363525,'2024-01-08','2026-01-18','2024-01-17','2024-01-09','y','d','x','d','j','n','o','h'),
    (157,0,-10,2,-10,7567739376725572066,5616377650809946837,8573624867352119272,2262392814438727082,'2024-01-08','2024-01-31','2024-01-17','2023-12-19','f','n','f','r','n','q','m','n'),
    (158,-4,9,-10,7,2319159625194776334,407250325989847802,-3588497774199811578,-547418380398391270,'2024-01-17','2024-01-31','2026-01-18','2023-12-19','s','x','u','j','i',null,'p','b'),
    (159,-10,4,8,8,null,null,7705602450550432993,742041524790384390,'2024-01-31','2023-12-09','2023-12-09','2024-01-19','g','y','l','d','g','e','k','h'),
    (160,0,2,2,8,null,8522131301326659073,-8865304049362191686,-7171064086258098677,'2023-12-18',null,'2024-01-19','2024-01-19','n','v','d','j',null,'w','f','l'),
    (161,4,7,3,9,null,3541346781635634258,-8551746578812887781,-7337560889113694888,'2024-01-19','2027-01-09','2024-02-18','2023-12-14',null,'y','j','h','c','w','a','i'),
    (162,7,6,9,8,7030148837172289305,8056410353843730036,-4855338156902986890,5319227784182380731,null,'2023-12-09','2027-01-09','2023-12-16','n','n','a','b','v',null,'t','b'),
    (163,5,3,0,7,427334391358246771,8050112207649519443,-8783981195124085537,-2925264850368739780,'2024-01-31','2024-01-17','2023-12-14','2025-02-18',null,'w','f','g','b','j','g','o'),
    (164,8,null,1,0,null,-5125932554164553193,-361428343629790836,1490877093813367596,'2024-02-18','2023-12-13','2024-02-18','2025-06-18','g','c','u','z','j','t','n','s'),
    (165,6,-10,-10,4,401211505594870957,-2486045565429716565,3679366561172793116,-6544327233785336337,'2023-12-15','2023-12-10','2023-12-12','2024-02-18','n','u','u','l','b',null,'r','o'),
    (166,2,2,7,6,null,null,-1232875368367813909,-2654235050917742705,null,'2026-01-18','2027-01-09','2023-12-18',null,'k','k','x','o','l','a','m'),
    (167,-10,1,8,9,-8578602726444116604,4395344205255541535,-3700493525899938965,5581859827495744469,'2024-01-09','2024-01-19','2024-01-17','2025-06-18','s','f','k','y','n',null,'q','y'),
    (168,8,7,-10,-10,-9099654191483240772,8746495951376111750,7413311732292904586,-3633262094199864671,'2025-02-18','2024-02-18','2024-02-18','2023-12-19','q','l','o','o','s','p','q','i'),
    (169,4,-4,9,-4,-4018679014449613083,6067940199083356941,227509747112856702,-8878903158743492700,'2023-12-09','2024-01-17','2023-12-17','2024-02-18','a','e','q','c','d','l','u','i'),
    (170,-10,1,-10,-10,-4347338175015239096,303152522920523964,-3366861472324546751,-1792053362852353550,'2023-12-14','2023-12-15','2023-12-18','2023-12-12',null,null,'d','j','v','t','t','x'),
    (171,4,8,9,4,6125596596282667356,null,-3769307504282746471,4492543183509474594,'2023-12-19','2024-01-17','2023-12-13','2025-06-18','e','d','z','e','e',null,'v','e'),
    (172,null,8,-10,-10,-5878699407241380005,3707545942848547534,8460371982479682208,-8268219849788841026,'2023-12-20',null,'2023-12-16','2023-12-20','m','k','h','d','f','z','x','p'),
    (173,null,-10,-4,-10,null,null,-4337290235619243347,-4209340769710092424,'2023-12-20','2024-02-18','2024-01-19','2027-01-09','f',null,'o','l','i','s','y','u'),
    (174,1,9,5,0,-2847215348701688440,-5478594453193527180,5027479249607597225,170359040141253660,'2023-12-15','2026-01-18','2024-01-09','2023-12-10','y',null,'u','j','r','n','b','l'),
    (175,9,-10,-10,-4,-4965439207449911104,-8458924371575507301,2633043105526646613,5667795406959092719,'2027-01-16','2023-12-18','2023-12-14','2024-01-09','g','l','v','v','p','r','c','n'),
    (176,3,3,2,-10,null,-8375557814965113270,6578183021595461371,-2562712282389245947,'2023-12-14','2025-02-18','2027-01-16','2023-12-20','m','t','s','r',null,'v','c','a'),
    (177,-4,7,2,1,4395058196255561498,-7229470944605757362,937960490371387357,596062613781144577,'2024-01-09','2023-12-12','2024-01-17','2023-12-09','x',null,'k','s','g','t','v','b'),
    (178,-10,6,-10,-4,-5343127241116805555,3214329783351046811,-2942702620220385757,4629202499911938133,'2024-01-09','2025-06-18','2027-01-09','2025-02-17','k',null,'x','k','s',null,'y','d'),
    (179,8,2,-10,7,1306794644034360185,8104508283348401656,-7781611788119325374,-1559047723439747245,'2026-02-18','2023-12-15','2023-12-16','2023-12-14','c','h','r','h','k','r','m','r'),
    (180,8,null,-10,9,-6845889033670399965,-4012385316602501804,-4338537233243482341,1876438682638258549,'2026-01-18','2024-01-09','2024-02-18','2026-01-18','x','t','x','j','p','f','g','t'),
    (181,-4,1,-10,8,null,null,1262464141766850708,-3799131303622379390,'2024-01-17','2023-12-16','2025-06-18','2025-02-18','d',null,'j','o','s','x','k','x'),
    (182,-4,7,8,6,7946259648386972860,-7710561382439523341,-5136919082500090741,3470998110053417757,'2024-02-18','2023-12-20','2023-12-17','2023-12-14','x','n','g','h','e','r','t','l'),
    (183,-4,-10,-10,0,1509548002977119549,null,-432062717774302450,-3151043498777017301,'2024-01-19','2024-01-09','2023-12-17','2023-12-18',null,'l','b','f','i','l','h','c'),
    (184,null,-10,6,5,2119924088069447144,-1255768152811558172,1012819011919698613,-3496912237284611876,'2023-12-20',null,'2024-01-19','2023-12-15',null,'u','w','q','n',null,'p','a'),
    (185,8,8,8,-10,4676274730336956938,5136751053010961301,8300622693683205319,-1361583777210343375,'2026-01-18','2023-12-16','2024-02-18','2023-12-12','o','c','s','h','d','h','l','c'),
    (186,3,7,-4,6,null,5041489075802116054,-6588426236193545740,8423676058141919964,'2023-12-13','2023-12-19','2023-12-18','2024-01-09',null,'c','r','z','z','i','y','a'),
    (187,-4,null,4,6,null,964974380252695233,-4015675944313432053,-4973580781314544714,'2024-02-18',null,'2023-12-13','2023-12-19','j','a','i','d','w','r','h','s'),
    (188,7,-10,8,-10,-7650070701520749042,-1556549730628237978,-7841366573812989369,2058539311970243887,'2025-02-17','2025-06-18','2023-12-19','2023-12-14','k','l','e','p',null,'a','p','g'),
    (189,6,null,4,8,null,3679128814704027170,-8277380801474691009,-3170290534566200063,'2024-01-08','2024-01-31','2023-12-10','2027-01-09',null,'f','k','b','g',null,'h','e'),
    (190,-10,-4,-10,1,-4219948539138905579,-5244245245890492072,-6785158847867478694,-7248193910059028370,'2023-12-18','2026-01-18','2025-06-18','2023-12-17','l','a','j','a','i','h','h','f'),
    (191,6,-10,-4,8,3175896213233378185,8743318336990811501,-5546142116733032449,-9097610172970560923,'2024-02-18','2026-02-18','2023-12-09','2023-12-10','v','i','h','j','r',null,'v','g'),
    (192,-10,9,8,-4,4335715539682699734,5465033577746370018,4473180193110960481,8659491888045138847,'2023-12-09','2023-12-16','2027-01-16','2027-01-09',null,'h','e','l','n',null,'w','x'),
    (193,-10,-4,6,6,-7375321279050850063,null,8845182676995525750,-4850465566991597349,'2024-02-18','2024-01-31','2023-12-14','2023-12-18','s',null,'o','j','s','g','l','v'),
    (194,-4,-10,8,-10,-4761575559261734188,-7042329325798196061,1260959184865930991,-4767044596743930518,'2024-01-17','2026-01-18','2025-06-18','2023-12-14','i','t','l','m','n',null,'z','n'),
    (195,null,4,9,-10,null,null,2891549689244551808,-5230886631619520164,'2025-06-18','2027-01-16','2023-12-12','2023-12-19',null,'r','j','q','t','r','s','g'),
    (196,9,8,-10,-10,2187809305762373805,null,-2850062827064335926,2430195282731050215,'2024-01-08','2025-06-18','2023-12-18','2026-02-18','y','g','j','v','u','e','b','u'),
    (197,null,3,0,-4,-8286099209958254886,7748929527795363370,-6521295200647841804,789640259676833298,'2027-01-16','2025-02-18','2027-01-09','2023-12-18',null,'f','t','m','a','d','i','p'),
    (198,0,6,9,1,2906540190944252981,1491936597198579837,-424302572113584860,740930406390435907,'2025-06-18','2025-06-18','2024-01-08','2024-02-18','a','x','z','g','y','l','m','v'),
    (199,1,-10,7,-10,6437035907235877917,-2720500768116271006,-1635391493087085931,5523231887763834144,'2023-12-12','2024-01-31','2023-12-13','2023-12-17','z','p','k','i','o','r','k','m');
    """
    qt_select_no_need_2 """
        SELECT
            AVG(DISTINCT table1.`col_int_undef_signed_not_null_index_inverted`) AS field1
        FROM
            ${table5} AS table1
        WHERE
            NOT (
                    (
                            (
                                    (table1.col_int_undef_signed_not_null_index_inverted >= 9)
                                OR table1.col_varchar_10__undef_signed_not_null_index_inverted <> table1.col_varchar_1024__undef_signed_not_null_index_inverted
                            )
                        OR table1.col_varchar_10__undef_signed_index_inverted > 'good'
                    )
                OR table1.`col_int_undef_signed_not_null_index_inverted` BETWEEN NULL AND (7 + 9)
                AND table1.`col_date_undef_signed_not_null_index_inverted` BETWEEN '2023-12-16' AND DATE_ADD(table1.`col_date_undef_signed_not_null`, INTERVAL 7 DAY)
            )
        LIMIT 10000;
    """

    def table6 = "test_index_no_need_read_data6"
    sql "drop table if exists ${table6}"
    sql """
    create table ${table6} (
    col_date_undef_signed_not_null_index_inverted date  not null  ,
    col_bigint_undef_signed_not_null_index_inverted bigint  not null  ,
    col_bigint_undef_signed_not_null bigint  not null  ,
    col_int_undef_signed int  null  ,
    col_int_undef_signed_index_inverted int  null  ,
    col_int_undef_signed_not_null int  not null  ,
    col_int_undef_signed_not_null_index_inverted int  not null  ,
    col_bigint_undef_signed bigint  null  ,
    col_bigint_undef_signed_index_inverted bigint  null  ,
    col_date_undef_signed date  null  ,
    col_date_undef_signed_index_inverted date  null  ,
    col_date_undef_signed_not_null date  not null  ,
    col_varchar_10__undef_signed varchar(10)  null  ,
    col_varchar_10__undef_signed_index_inverted varchar(10)  null  ,
    col_varchar_10__undef_signed_not_null varchar(10)  not null  ,
    col_varchar_10__undef_signed_not_null_index_inverted varchar(10)  not null  ,
    col_varchar_1024__undef_signed varchar(1024)  null  ,
    col_varchar_1024__undef_signed_index_inverted varchar(1024)  null  ,
    col_varchar_1024__undef_signed_not_null varchar(1024)  not null  ,
    col_varchar_1024__undef_signed_not_null_index_inverted varchar(1024)  not null  ,
    pk int,
    INDEX col_int_undef_signed_index_inverted_idx (`col_int_undef_signed_index_inverted`) USING INVERTED,
    INDEX col_int_undef_signed_not_null_index_inverted_idx (`col_int_undef_signed_not_null_index_inverted`) USING INVERTED,
    INDEX col_bigint_undef_signed_index_inverted_idx (`col_bigint_undef_signed_index_inverted`) USING INVERTED,
    INDEX col_bigint_undef_signed_not_null_index_inverted_idx (`col_bigint_undef_signed_not_null_index_inverted`) USING INVERTED,
    INDEX col_date_undef_signed_index_inverted_idx (`col_date_undef_signed_index_inverted`) USING INVERTED,
    INDEX col_date_undef_signed_not_null_index_inverted_idx (`col_date_undef_signed_not_null_index_inverted`) USING INVERTED,
    INDEX col_varchar_10__undef_signed_index_inverted_idx (`col_varchar_10__undef_signed_index_inverted`) USING INVERTED,
    INDEX col_varchar_10__undef_signed_not_null_index_inverted_idx (`col_varchar_10__undef_signed_not_null_index_inverted`) USING INVERTED,
    INDEX col_varchar_1024__undef_signed_index_inverted_idx (`col_varchar_1024__undef_signed_index_inverted`) USING INVERTED,
    INDEX col_varchar_1024__undef_signed_not_null_index_inverted_idx (`col_varchar_1024__undef_signed_not_null_index_inverted`) USING INVERTED
    ) engine=olap
    UNIQUE KEY(col_date_undef_signed_not_null_index_inverted, col_bigint_undef_signed_not_null_index_inverted, col_bigint_undef_signed_not_null)
    distributed by hash(col_bigint_undef_signed_not_null) buckets 1
    properties("enable_unique_key_merge_on_write" = "true", "replication_num" = "1");
    """
    sql """
    INSERT INTO ${table6}(
      pk,
      col_int_undef_signed,
      col_int_undef_signed_index_inverted,
      col_int_undef_signed_not_null,
      col_int_undef_signed_not_null_index_inverted,
      col_bigint_undef_signed,
      col_bigint_undef_signed_index_inverted,
      col_bigint_undef_signed_not_null,
      col_bigint_undef_signed_not_null_index_inverted,
      col_date_undef_signed,
      col_date_undef_signed_index_inverted,
      col_date_undef_signed_not_null,
      col_date_undef_signed_not_null_index_inverted,
      col_varchar_10__undef_signed,
      col_varchar_10__undef_signed_index_inverted,
      col_varchar_10__undef_signed_not_null,
      col_varchar_10__undef_signed_not_null_index_inverted,
      col_varchar_1024__undef_signed,
      col_varchar_1024__undef_signed_index_inverted,
      col_varchar_1024__undef_signed_not_null,
      col_varchar_1024__undef_signed_not_null_index_inverted)
    VALUES
    (0,2,null,2,5,null,6047071702080355644,1743773009061720927,3968365840610113182,null,'2023-12-10','2023-12-18','2023-12-10','m','e','l','w','s','f','c','x'),
    (1,5,null,8,-4,6093818696587887333,9084553190249453965,-4779202639200620381,-5215587017466273548,'2026-02-18','2024-01-08','2027-01-09','2024-02-18','i',null,'f','b','w','o','w','t'),
    (2,-4,5,8,3,null,-5680478258766518915,6193120162169252722,859865224420839805,'2024-01-09','2025-02-17','2025-06-18','2027-01-16',null,'m','r','f','d','l','p','o'),
    (3,0,null,-4,1,null,994798108522699043,-7031415486628048126,5990000782425933563,'2027-01-09','2025-02-18','2023-12-17','2027-01-16','k','k','h','p','f',null,'y','p'),
    (4,8,9,-4,4,5319335073963350191,-4375219010963025933,-3008307869272473435,7920842530090123102,'2023-12-15','2024-02-18','2026-02-18','2023-12-18','o','c','e','u','o','f','f','o'),
    (5,-10,4,-10,3,6905383895504497995,4714785027515578912,7253753864062943115,7704919728637448242,'2023-12-10','2023-12-17','2023-12-11','2023-12-14','q','v','x','a','w','v','h','d'),
    (6,8,3,9,6,3537191251092326115,-7561146461075150845,9134495110669406461,-5763667657169835232,'2024-02-18','2025-02-18','2024-01-08','2023-12-09','d','o','w','p','z','j','w','s'),
    (7,6,0,6,0,3153592367577200883,2371697304713448324,-6286827003601310266,1341411796447444067,'2024-01-09','2024-01-09','2024-01-17','2023-12-13','m','t','b','r','n',null,'k','r'),
    (8,0,2,0,7,-2468425315177796710,null,4842126111665415103,951334858022112250,'2023-12-10',null,'2027-01-09','2024-02-18','n','g','w','n','e','s','e','v'),
    (9,0,8,1,6,4939444585074163694,-9153663403976431389,-353942154540925304,-7032306882339768290,'2023-12-14','2023-12-12','2024-02-18','2023-12-18','x','p','s','d','w','k','x','v'),
    (10,3,4,-10,6,null,null,-4215952697964699827,-1719431863470678908,'2023-12-19',null,'2023-12-12','2023-12-20','z','b','f','q','j',null,'j','c'),
    (11,5,-4,-4,0,null,6548821515603388818,-6175147937517306851,-4094004617028236529,'2024-02-18','2025-02-18','2024-01-19','2027-01-09','u','z','p','f','m','j','i','z'),
    (12,-4,6,-10,3,2203471486366176024,-5277090899702382016,3417149535731923169,6441001575802340806,null,null,'2024-01-17','2023-12-20','u','h','d','v','p',null,'a','r'),
    (13,5,9,4,2,-1992377771700148483,-559291350287121968,-3005977928697009690,-7531456678359909168,'2023-12-16','2024-02-18','2023-12-15','2023-12-15','y','u','z','p','c','k','i','p'),
    (14,-4,7,0,8,590261254598495131,-1908674911887416554,584395141912150539,5072698314763590994,'2023-12-19','2023-12-12','2023-12-11','2027-01-09',null,'o','y','u','q','t','i','x'),
    (15,3,8,4,-10,-7579431748710361647,-8155162620998389425,2874208940129807662,-5742742834942932894,'2023-12-18','2024-01-09','2024-01-17','2025-02-17','r','b','t','z','t','h','h','p'),
    (16,4,-10,1,1,7461938820230421863,null,-9200561829194173663,-3146640760841215298,'2025-06-18','2024-01-31','2024-01-09','2024-02-18','g','n','c','y',null,'q','p','e'),
    (17,6,-10,6,5,null,8625368487501035525,-7286860434583964446,5646630444354261975,'2023-12-17','2023-12-17','2023-12-10','2023-12-18','d','v','j','f',null,'c','g','b'),
    (18,null,null,0,6,3357164691434157854,-5053592862467599824,-299605368484252016,-7301242560619705429,'2025-02-18','2023-12-17','2024-01-08','2023-12-09','x',null,'x','h','l',null,'k','l'),
    (19,7,5,7,7,281475235579931926,6513642546811305927,5267044139266533684,3650267105063752728,null,'2023-12-13','2024-02-18','2027-01-16',null,'k','d','t','y','t','l','l'),
    (20,3,-4,-4,-4,-5540560095623011609,null,53948240632423741,-8352232891511580467,'2023-12-09',null,'2024-01-08','2023-12-09','u','r','a','q','u','k','h','u'),
    (21,6,2,-4,5,null,null,4321355771692382265,4567758090701714014,'2023-12-19','2023-12-18','2023-12-10','2024-01-08',null,'r','d','g','a',null,'a','l'),
    (22,1,-10,3,9,-2036645409027616747,-903109984248808064,-6201579286490831689,3565899407818468374,'2026-02-18',null,'2023-12-12','2023-12-10',null,'b','a','v','c','z','b','f'),
    (23,null,-4,-10,1,3310206209156138586,-4155137914128855235,-3514691054541487722,2915994975133352939,'2023-12-12','2024-01-19','2023-12-09','2026-02-18','o','l','j','v','t','f','y','i'),
    (24,9,null,4,4,6551121666871685812,null,-8016546789408062643,6119825356242292412,'2024-01-09','2025-06-18','2023-12-13','2025-02-18','f',null,'q','z','z',null,'m','w'),
    (25,4,2,0,0,-520048936955506758,7670879000600913113,-2040077939644368040,1197843741238154598,'2023-12-09','2023-12-15','2025-06-18','2026-01-18','r','v','c','g','h','u','f','m'),
    (26,null,-10,4,-4,null,419678391523752890,-7435874721585714233,8898634654295427266,'2026-01-18',null,'2023-12-18','2023-12-18','s','t','e','p','q',null,'p','g'),
    (27,9,-4,3,-10,null,-3974342907695018910,443191779926461130,8233084506172994654,'2024-01-09','2023-12-17','2026-02-18','2024-02-18','t','t','g','a','h','m','v','c'),
    (28,null,7,8,9,null,6152093303748835632,-4562412588627987392,-934172863387418493,'2023-12-17','2024-01-31','2023-12-20','2024-01-17',null,'w','w','k',null,null,'z','p'),
    (29,4,8,8,0,null,null,-2824034215088311828,-180188196226406973,'2023-12-11','2024-01-09','2024-01-31','2023-12-17',null,'u','g','l','g','e','z','z'),
    (30,null,null,-4,-4,7235852278026844130,-9047156586257680967,5923497116520700436,-938448741948749056,'2023-12-19','2025-06-18','2026-01-18','2024-01-09','r',null,'m','i','r','i','v','q'),
    (31,7,5,-4,9,-5135616285903777613,null,-5136431726765172914,-134704751314553959,null,'2024-01-19','2024-01-08','2023-12-09','e',null,'w','d','n',null,'t','d'),
    (32,3,-4,2,4,-117991869282553866,null,-7684403676477748961,4934216177675456310,'2024-01-08',null,'2027-01-09','2023-12-10','n','p','k','f','q',null,'c','s'),
    (33,8,9,4,-4,4678985764823073465,-4473441684795462099,2483205526020008396,4231901676928655206,'2023-12-15',null,'2023-12-16','2026-02-18','z','w','d','a','d','j','q','q'),
    (34,9,8,2,8,-4584748361800749967,4202823116769139963,145368720959794659,2251003368255192412,null,'2025-06-18','2023-12-09','2027-01-09','d','o','t','g','y','e','a','x'),
    (35,5,-4,-10,-4,-906548241884551302,8645460519643931914,6481522417337591957,6261673488873372831,'2024-01-08','2023-12-13','2023-12-14','2023-12-15','p','f','i','p',null,null,'s','n'),
    (36,5,null,8,-4,null,null,4314003773436158626,7579142261463225081,'2024-01-09','2023-12-13','2023-12-15','2023-12-14','c','t','t','e','u','x','r','f'),
    (37,-10,6,9,2,-6620185973552334642,null,-3046015722118082480,-3095068909681245822,'2026-02-18','2027-01-09','2023-12-10','2027-01-16','j','j','j','m','j','i','m','z'),
    (38,-10,8,6,-10,-2515256036168029290,null,8269780684849815478,-8650591097852000982,'2025-06-18',null,'2023-12-18','2024-02-18','m','y','l','j','p','y','s','h'),
    (39,0,-10,-10,0,null,-5522213112273370561,-1316816252214516585,-1567577471748513560,'2023-12-16','2023-12-11','2023-12-09','2024-02-18','a','t','c','d','n','d','a','q'),
    (40,7,-10,-10,3,-5084805805235703626,-1233811050241785632,8217977506968477373,-6963502005382243135,'2023-12-10','2025-06-18','2026-02-18','2024-02-18','v','d','n','u','x','s','x','n'),
    (41,null,null,-10,7,null,null,5799307291119757557,2215391798483197604,'2025-02-18','2026-02-18','2024-01-08','2023-12-18',null,'e','g','l',null,'g','v','w'),
    (42,3,null,3,4,null,-4599200440035458276,-5232722834984859778,-3875787409217377000,'2024-01-19','2023-12-10','2025-02-17','2024-01-17','c','z','r','p','l','p','r','j'),
    (43,3,0,8,1,null,9039465042666792521,8653474097534804813,-3815270519775100915,'2023-12-09','2023-12-10','2026-01-18','2023-12-14','n','y','o','w','x','c','n','u'),
    (44,5,-10,-10,2,null,-1196385874478092971,3634991072249040858,9109232382765106898,'2023-12-17','2026-02-18','2025-06-18','2023-12-12','h','e','b','l','c','x','s','a'),
    (45,1,2,1,-10,3496175437205301884,-750688512374970345,-5989758804641551640,-2702732245503451716,'2024-01-17',null,'2025-06-18','2023-12-13','g','l','g','o','j','c','r','b'),
    (46,4,1,3,-10,-4730011562372937560,-4016339630147734399,5168369054194323923,8388817823560738292,'2023-12-18',null,'2027-01-16','2023-12-11','v','o','b','s','a','r','h','r'),
    (47,null,null,3,-4,null,-8740603053341502757,-5732373097375670728,-4814649296407464281,'2023-12-09','2025-02-17','2024-01-19','2025-02-18',null,'b','m','r','t','d','k','r'),
    (48,-10,1,4,5,244387110332320233,4552672675815310682,2693886189414111015,5304928960690310043,'2025-06-18','2023-12-10','2023-12-12','2024-01-17','r','j','z','f',null,'v','h','j'),
    (49,1,9,-4,6,1253182385525141650,2164820345365000550,758006141978389707,2057826544478381809,'2024-02-18','2025-06-18','2023-12-16','2026-02-18','l','o','q','d','u','q','c','z');
    """
    qt_select_no_need_3 """
        SELECT
            table1.col_date_undef_signed_not_null AS field1,
            table1.col_bigint_undef_signed_index_inverted AS field2,
            table1.col_date_undef_signed AS field3
        FROM
            ${table6} AS table1
        WHERE
            NOT (
                    NOT (
                            (table1.col_varchar_10__undef_signed_index_inverted > table1.col_varchar_1024__undef_signed_not_null_index_inverted)
                        AND table1.col_varchar_10__undef_signed_index_inverted != 'k'
                    )
                AND table1.`col_int_undef_signed_not_null` != (3 + 0.3)
            )
        GROUP BY
            field1, field2, field3
        ORDER BY
            field1, field2, field3
        LIMIT 10000;
"""
}
