/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.authorization.models.ExpandedProperties;
import com.azure.resourcemanager.authorization.models.PrincipalType;
import com.azure.resourcemanager.authorization.models.RequestType;
import com.azure.resourcemanager.authorization.models.RoleEligibilityScheduleRequestPropertiesScheduleInfo;
import com.azure.resourcemanager.authorization.models.RoleEligibilityScheduleRequestPropertiesTicketInfo;
import com.azure.resourcemanager.authorization.models.Status;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

public final class RoleEligibilityScheduleRequestProperties {
    @JsonProperty(value="scope", access=JsonProperty.Access.WRITE_ONLY)
    private String scope;
    @JsonProperty(value="roleDefinitionId", required=true)
    private String roleDefinitionId;
    @JsonProperty(value="principalId", required=true)
    private String principalId;
    @JsonProperty(value="principalType", access=JsonProperty.Access.WRITE_ONLY)
    private PrincipalType principalType;
    @JsonProperty(value="requestType", required=true)
    private RequestType requestType;
    @JsonProperty(value="status", access=JsonProperty.Access.WRITE_ONLY)
    private Status status;
    @JsonProperty(value="approvalId", access=JsonProperty.Access.WRITE_ONLY)
    private String approvalId;
    @JsonProperty(value="scheduleInfo")
    private RoleEligibilityScheduleRequestPropertiesScheduleInfo scheduleInfo;
    @JsonProperty(value="targetRoleEligibilityScheduleId")
    private String targetRoleEligibilityScheduleId;
    @JsonProperty(value="targetRoleEligibilityScheduleInstanceId")
    private String targetRoleEligibilityScheduleInstanceId;
    @JsonProperty(value="justification")
    private String justification;
    @JsonProperty(value="ticketInfo")
    private RoleEligibilityScheduleRequestPropertiesTicketInfo ticketInfo;
    @JsonProperty(value="condition")
    private String condition;
    @JsonProperty(value="conditionVersion")
    private String conditionVersion;
    @JsonProperty(value="createdOn", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime createdOn;
    @JsonProperty(value="requestorId", access=JsonProperty.Access.WRITE_ONLY)
    private String requestorId;
    @JsonProperty(value="expandedProperties", access=JsonProperty.Access.WRITE_ONLY)
    private ExpandedProperties expandedProperties;
    private static final ClientLogger LOGGER = new ClientLogger(RoleEligibilityScheduleRequestProperties.class);

    public String scope() {
        return this.scope;
    }

    public String roleDefinitionId() {
        return this.roleDefinitionId;
    }

    public RoleEligibilityScheduleRequestProperties withRoleDefinitionId(String roleDefinitionId) {
        this.roleDefinitionId = roleDefinitionId;
        return this;
    }

    public String principalId() {
        return this.principalId;
    }

    public RoleEligibilityScheduleRequestProperties withPrincipalId(String principalId) {
        this.principalId = principalId;
        return this;
    }

    public PrincipalType principalType() {
        return this.principalType;
    }

    public RequestType requestType() {
        return this.requestType;
    }

    public RoleEligibilityScheduleRequestProperties withRequestType(RequestType requestType) {
        this.requestType = requestType;
        return this;
    }

    public Status status() {
        return this.status;
    }

    public String approvalId() {
        return this.approvalId;
    }

    public RoleEligibilityScheduleRequestPropertiesScheduleInfo scheduleInfo() {
        return this.scheduleInfo;
    }

    public RoleEligibilityScheduleRequestProperties withScheduleInfo(RoleEligibilityScheduleRequestPropertiesScheduleInfo scheduleInfo) {
        this.scheduleInfo = scheduleInfo;
        return this;
    }

    public String targetRoleEligibilityScheduleId() {
        return this.targetRoleEligibilityScheduleId;
    }

    public RoleEligibilityScheduleRequestProperties withTargetRoleEligibilityScheduleId(String targetRoleEligibilityScheduleId) {
        this.targetRoleEligibilityScheduleId = targetRoleEligibilityScheduleId;
        return this;
    }

    public String targetRoleEligibilityScheduleInstanceId() {
        return this.targetRoleEligibilityScheduleInstanceId;
    }

    public RoleEligibilityScheduleRequestProperties withTargetRoleEligibilityScheduleInstanceId(String targetRoleEligibilityScheduleInstanceId) {
        this.targetRoleEligibilityScheduleInstanceId = targetRoleEligibilityScheduleInstanceId;
        return this;
    }

    public String justification() {
        return this.justification;
    }

    public RoleEligibilityScheduleRequestProperties withJustification(String justification) {
        this.justification = justification;
        return this;
    }

    public RoleEligibilityScheduleRequestPropertiesTicketInfo ticketInfo() {
        return this.ticketInfo;
    }

    public RoleEligibilityScheduleRequestProperties withTicketInfo(RoleEligibilityScheduleRequestPropertiesTicketInfo ticketInfo) {
        this.ticketInfo = ticketInfo;
        return this;
    }

    public String condition() {
        return this.condition;
    }

    public RoleEligibilityScheduleRequestProperties withCondition(String condition) {
        this.condition = condition;
        return this;
    }

    public String conditionVersion() {
        return this.conditionVersion;
    }

    public RoleEligibilityScheduleRequestProperties withConditionVersion(String conditionVersion) {
        this.conditionVersion = conditionVersion;
        return this;
    }

    public OffsetDateTime createdOn() {
        return this.createdOn;
    }

    public String requestorId() {
        return this.requestorId;
    }

    public ExpandedProperties expandedProperties() {
        return this.expandedProperties;
    }

    public void validate() {
        if (this.roleDefinitionId() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property roleDefinitionId in model RoleEligibilityScheduleRequestProperties"));
        }
        if (this.principalId() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property principalId in model RoleEligibilityScheduleRequestProperties"));
        }
        if (this.requestType() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property requestType in model RoleEligibilityScheduleRequestProperties"));
        }
        if (this.scheduleInfo() != null) {
            this.scheduleInfo().validate();
        }
        if (this.ticketInfo() != null) {
            this.ticketInfo().validate();
        }
        if (this.expandedProperties() != null) {
            this.expandedProperties().validate();
        }
    }
}

