/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.util.function.Supplier;
import lombok.Generated;

public final class MasterServerMetrics {
    private static final Counter masterOverloadCounter = Counter.builder((String)"ds.master.overload.count").description("Master server overload count").register((MeterRegistry)Metrics.globalRegistry);
    private static final Counter masterConsumeCommandCounter = Counter.builder((String)"ds.master.consume.command.count").description("Master server consume command count").register((MeterRegistry)Metrics.globalRegistry);
    private static final Counter masterHeartBeatCounter = Counter.builder((String)"ds.master.heartbeat.count").description("master heartbeat count").register((MeterRegistry)Metrics.globalRegistry);

    public static void registerMasterMemoryAvailableGauge(Supplier<Number> supplier) {
        Gauge.builder((String)"ds.master.memory.available", supplier).description("Master memory available").register((MeterRegistry)Metrics.globalRegistry);
    }

    public static void registerMasterCpuUsageGauge(Supplier<Number> supplier) {
        Gauge.builder((String)"ds.master.cpu.usage", supplier).description("master cpu usage").register((MeterRegistry)Metrics.globalRegistry);
    }

    public static void registerMasterMemoryUsageGauge(Supplier<Number> supplier) {
        Gauge.builder((String)"ds.master.memory.usage", supplier).description("Master memory usage").register((MeterRegistry)Metrics.globalRegistry);
    }

    public static void registerUncachedException(Supplier<Number> supplier) {
        Gauge.builder((String)"ds.master.uncached.exception", supplier).description("number of uncached exception").register((MeterRegistry)Metrics.globalRegistry);
    }

    public static void incMasterOverload() {
        masterOverloadCounter.increment();
    }

    public static void incMasterConsumeCommand(int commandCount) {
        masterConsumeCommandCounter.increment((double)commandCount);
    }

    public static void incMasterHeartbeatCount() {
        masterHeartBeatCounter.increment();
    }

    @Generated
    private MasterServerMetrics() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

