/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.utils;

import com.google.common.base.Preconditions;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.plugin.task.api.ILogicTaskChannel;
import org.apache.dolphinscheduler.plugin.task.api.TaskPluginManager;

public final class TaskTypeUtils {
    public static boolean isSwitchTask(String taskType) {
        return "SWITCH".equals(taskType);
    }

    public static boolean isConditionTask(String taskType) {
        return "CONDITIONS".equals(taskType);
    }

    public static boolean isSubWorkflowTask(String taskType) {
        return "SUB_WORKFLOW".equals(taskType);
    }

    public static boolean isDependentTask(String taskType) {
        return "DEPENDENT".equals(taskType);
    }

    public static boolean isLogicTask(String taskType) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)taskType), (Object)"taskType cannot be empty");
        return TaskPluginManager.getTaskChannel(taskType) instanceof ILogicTaskChannel;
    }

    @Generated
    private TaskTypeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

