/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ListMeta describes metadata that synthetic resources must have, including lists and various status objects. A resource may have only one of {ObjectMeta, ListMeta}.")
public class V1ListMeta {
    public static final String SERIALIZED_NAME_CONTINUE = "continue";
    @SerializedName(value="continue")
    private String _continue;
    public static final String SERIALIZED_NAME_REMAINING_ITEM_COUNT = "remainingItemCount";
    @SerializedName(value="remainingItemCount")
    private Long remainingItemCount;
    public static final String SERIALIZED_NAME_RESOURCE_VERSION = "resourceVersion";
    @SerializedName(value="resourceVersion")
    private String resourceVersion;
    public static final String SERIALIZED_NAME_SELF_LINK = "selfLink";
    @SerializedName(value="selfLink")
    private String selfLink;

    public V1ListMeta _continue(String _continue) {
        this._continue = _continue;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.")
    public String getContinue() {
        return this._continue;
    }

    public void setContinue(String _continue) {
        this._continue = _continue;
    }

    public V1ListMeta remainingItemCount(Long remainingItemCount) {
        this.remainingItemCount = remainingItemCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="remainingItemCount is the number of subsequent items in the list which are not included in this list response. If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.")
    public Long getRemainingItemCount() {
        return this.remainingItemCount;
    }

    public void setRemainingItemCount(Long remainingItemCount) {
        this.remainingItemCount = remainingItemCount;
    }

    public V1ListMeta resourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency")
    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public void setResourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
    }

    public V1ListMeta selfLink(String selfLink) {
        this.selfLink = selfLink;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="selfLink is a URL representing this object. Populated by the system. Read-only.  DEPRECATED Kubernetes will stop propagating this field in 1.20 release and the field is planned to be removed in 1.21 release.")
    public String getSelfLink() {
        return this.selfLink;
    }

    public void setSelfLink(String selfLink) {
        this.selfLink = selfLink;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ListMeta v1ListMeta = (V1ListMeta)o;
        return Objects.equals(this._continue, v1ListMeta._continue) && Objects.equals(this.remainingItemCount, v1ListMeta.remainingItemCount) && Objects.equals(this.resourceVersion, v1ListMeta.resourceVersion) && Objects.equals(this.selfLink, v1ListMeta.selfLink);
    }

    public int hashCode() {
        return Objects.hash(this._continue, this.remainingItemCount, this.resourceVersion, this.selfLink);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ListMeta {\n");
        sb.append("    _continue: ").append(this.toIndentedString(this._continue)).append("\n");
        sb.append("    remainingItemCount: ").append(this.toIndentedString(this.remainingItemCount)).append("\n");
        sb.append("    resourceVersion: ").append(this.toIndentedString(this.resourceVersion)).append("\n");
        sb.append("    selfLink: ").append(this.toIndentedString(this.selfLink)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

