/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.compute.fluent.VirtualMachineImagesClient;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineImageInner;
import com.azure.resourcemanager.compute.implementation.VirtualMachineImageImpl;
import com.azure.resourcemanager.compute.models.VirtualMachineImage;
import com.azure.resourcemanager.compute.models.VirtualMachineImagesInSku;
import com.azure.resourcemanager.compute.models.VirtualMachineSku;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;

class VirtualMachineImagesInSkuImpl
implements VirtualMachineImagesInSku {
    private final VirtualMachineImagesClient innerCollection;
    private final VirtualMachineSku sku;

    VirtualMachineImagesInSkuImpl(VirtualMachineSku sku, VirtualMachineImagesClient innerCollection) {
        this.sku = sku;
        this.innerCollection = innerCollection;
    }

    public PagedIterable<VirtualMachineImage> list() {
        return new PagedIterable(this.listAsync());
    }

    public PagedFlux<VirtualMachineImage> listAsync() {
        VirtualMachineImagesInSkuImpl self = this;
        PagedFlux virtualMachineImageResourcePagedFlux = PagedConverter.convertListToPagedFlux(this.innerCollection.listWithResponseAsync(this.sku.region().toString(), this.sku.publisher().name(), this.sku.offer().name(), this.sku.name(), null, null, null));
        return PagedConverter.flatMapPage((PagedFlux)virtualMachineImageResourcePagedFlux, resourceInner -> this.innerCollection.getAsync(self.sku.region().toString(), self.sku.publisher().name(), self.sku.offer().name(), self.sku.name(), resourceInner.name()).map(imageInner -> new VirtualMachineImageImpl(self.sku.region(), self.sku.publisher().name(), self.sku.offer().name(), self.sku.name(), resourceInner.name(), (VirtualMachineImageInner)((Object)((Object)imageInner)))));
    }
}

