/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.fluent.models.AseV3NetworkingConfigurationInner;
import com.azure.resourcemanager.appservice.fluent.models.CustomDnsSuffixConfigurationInner;
import com.azure.resourcemanager.appservice.models.HostingEnvironmentStatus;
import com.azure.resourcemanager.appservice.models.LoadBalancingMode;
import com.azure.resourcemanager.appservice.models.NameValuePair;
import com.azure.resourcemanager.appservice.models.ProvisioningState;
import com.azure.resourcemanager.appservice.models.UpgradeAvailability;
import com.azure.resourcemanager.appservice.models.UpgradePreference;
import com.azure.resourcemanager.appservice.models.VirtualNetworkProfile;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class AppServiceEnvironmentInner {
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="status", access=JsonProperty.Access.WRITE_ONLY)
    private HostingEnvironmentStatus status;
    @JsonProperty(value="virtualNetwork", required=true)
    private VirtualNetworkProfile virtualNetwork;
    @JsonProperty(value="internalLoadBalancingMode")
    private LoadBalancingMode internalLoadBalancingMode;
    @JsonProperty(value="multiSize")
    private String multiSize;
    @JsonProperty(value="multiRoleCount", access=JsonProperty.Access.WRITE_ONLY)
    private Integer multiRoleCount;
    @JsonProperty(value="ipsslAddressCount")
    private Integer ipsslAddressCount;
    @JsonProperty(value="dnsSuffix")
    private String dnsSuffix;
    @JsonProperty(value="maximumNumberOfMachines", access=JsonProperty.Access.WRITE_ONLY)
    private Integer maximumNumberOfMachines;
    @JsonProperty(value="frontEndScaleFactor")
    private Integer frontEndScaleFactor;
    @JsonProperty(value="suspended", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean suspended;
    @JsonProperty(value="clusterSettings")
    private List<NameValuePair> clusterSettings;
    @JsonProperty(value="userWhitelistedIpRanges")
    private List<String> userWhitelistedIpRanges;
    @JsonProperty(value="hasLinuxWorkers", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean hasLinuxWorkers;
    @JsonProperty(value="upgradePreference")
    private UpgradePreference upgradePreference;
    @JsonProperty(value="dedicatedHostCount")
    private Integer dedicatedHostCount;
    @JsonProperty(value="zoneRedundant")
    private Boolean zoneRedundant;
    @JsonProperty(value="customDnsSuffixConfiguration")
    private CustomDnsSuffixConfigurationInner customDnsSuffixConfiguration;
    @JsonProperty(value="networkingConfiguration")
    private AseV3NetworkingConfigurationInner networkingConfiguration;
    @JsonProperty(value="upgradeAvailability", access=JsonProperty.Access.WRITE_ONLY)
    private UpgradeAvailability upgradeAvailability;
    private static final ClientLogger LOGGER = new ClientLogger(AppServiceEnvironmentInner.class);

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public HostingEnvironmentStatus status() {
        return this.status;
    }

    public VirtualNetworkProfile virtualNetwork() {
        return this.virtualNetwork;
    }

    public AppServiceEnvironmentInner withVirtualNetwork(VirtualNetworkProfile virtualNetwork) {
        this.virtualNetwork = virtualNetwork;
        return this;
    }

    public LoadBalancingMode internalLoadBalancingMode() {
        return this.internalLoadBalancingMode;
    }

    public AppServiceEnvironmentInner withInternalLoadBalancingMode(LoadBalancingMode internalLoadBalancingMode) {
        this.internalLoadBalancingMode = internalLoadBalancingMode;
        return this;
    }

    public String multiSize() {
        return this.multiSize;
    }

    public AppServiceEnvironmentInner withMultiSize(String multiSize) {
        this.multiSize = multiSize;
        return this;
    }

    public Integer multiRoleCount() {
        return this.multiRoleCount;
    }

    public Integer ipsslAddressCount() {
        return this.ipsslAddressCount;
    }

    public AppServiceEnvironmentInner withIpsslAddressCount(Integer ipsslAddressCount) {
        this.ipsslAddressCount = ipsslAddressCount;
        return this;
    }

    public String dnsSuffix() {
        return this.dnsSuffix;
    }

    public AppServiceEnvironmentInner withDnsSuffix(String dnsSuffix) {
        this.dnsSuffix = dnsSuffix;
        return this;
    }

    public Integer maximumNumberOfMachines() {
        return this.maximumNumberOfMachines;
    }

    public Integer frontEndScaleFactor() {
        return this.frontEndScaleFactor;
    }

    public AppServiceEnvironmentInner withFrontEndScaleFactor(Integer frontEndScaleFactor) {
        this.frontEndScaleFactor = frontEndScaleFactor;
        return this;
    }

    public Boolean suspended() {
        return this.suspended;
    }

    public List<NameValuePair> clusterSettings() {
        return this.clusterSettings;
    }

    public AppServiceEnvironmentInner withClusterSettings(List<NameValuePair> clusterSettings) {
        this.clusterSettings = clusterSettings;
        return this;
    }

    public List<String> userWhitelistedIpRanges() {
        return this.userWhitelistedIpRanges;
    }

    public AppServiceEnvironmentInner withUserWhitelistedIpRanges(List<String> userWhitelistedIpRanges) {
        this.userWhitelistedIpRanges = userWhitelistedIpRanges;
        return this;
    }

    public Boolean hasLinuxWorkers() {
        return this.hasLinuxWorkers;
    }

    public UpgradePreference upgradePreference() {
        return this.upgradePreference;
    }

    public AppServiceEnvironmentInner withUpgradePreference(UpgradePreference upgradePreference) {
        this.upgradePreference = upgradePreference;
        return this;
    }

    public Integer dedicatedHostCount() {
        return this.dedicatedHostCount;
    }

    public AppServiceEnvironmentInner withDedicatedHostCount(Integer dedicatedHostCount) {
        this.dedicatedHostCount = dedicatedHostCount;
        return this;
    }

    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    public AppServiceEnvironmentInner withZoneRedundant(Boolean zoneRedundant) {
        this.zoneRedundant = zoneRedundant;
        return this;
    }

    public CustomDnsSuffixConfigurationInner customDnsSuffixConfiguration() {
        return this.customDnsSuffixConfiguration;
    }

    public AppServiceEnvironmentInner withCustomDnsSuffixConfiguration(CustomDnsSuffixConfigurationInner customDnsSuffixConfiguration) {
        this.customDnsSuffixConfiguration = customDnsSuffixConfiguration;
        return this;
    }

    public AseV3NetworkingConfigurationInner networkingConfiguration() {
        return this.networkingConfiguration;
    }

    public AppServiceEnvironmentInner withNetworkingConfiguration(AseV3NetworkingConfigurationInner networkingConfiguration) {
        this.networkingConfiguration = networkingConfiguration;
        return this;
    }

    public UpgradeAvailability upgradeAvailability() {
        return this.upgradeAvailability;
    }

    public void validate() {
        if (this.virtualNetwork() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property virtualNetwork in model AppServiceEnvironmentInner"));
        }
        this.virtualNetwork().validate();
        if (this.clusterSettings() != null) {
            this.clusterSettings().forEach(e -> e.validate());
        }
        if (this.customDnsSuffixConfiguration() != null) {
            this.customDnsSuffixConfiguration().validate();
        }
        if (this.networkingConfiguration() != null) {
            this.networkingConfiguration().validate();
        }
    }
}

