/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.ChainingTriggerTypeProperties;
import com.azure.resourcemanager.datafactory.models.PipelineReference;
import com.azure.resourcemanager.datafactory.models.Trigger;
import com.azure.resourcemanager.datafactory.models.TriggerPipelineReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="ChainingTrigger")
public final class ChainingTrigger
extends Trigger {
    @JsonProperty(value="pipeline", required=true)
    private TriggerPipelineReference pipeline;
    @JsonProperty(value="typeProperties", required=true)
    private ChainingTriggerTypeProperties innerTypeProperties = new ChainingTriggerTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(ChainingTrigger.class);

    public TriggerPipelineReference pipeline() {
        return this.pipeline;
    }

    public ChainingTrigger withPipeline(TriggerPipelineReference pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    private ChainingTriggerTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public ChainingTrigger withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public ChainingTrigger withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public List<PipelineReference> dependsOn() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().dependsOn();
    }

    public ChainingTrigger withDependsOn(List<PipelineReference> dependsOn) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ChainingTriggerTypeProperties();
        }
        this.innerTypeProperties().withDependsOn(dependsOn);
        return this;
    }

    public String runDimension() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().runDimension();
    }

    public ChainingTrigger withRunDimension(String runDimension) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ChainingTriggerTypeProperties();
        }
        this.innerTypeProperties().withRunDimension(runDimension);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.pipeline() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property pipeline in model ChainingTrigger"));
        }
        this.pipeline().validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model ChainingTrigger"));
        }
        this.innerTypeProperties().validate();
    }
}

