/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.DependencyCondition;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ActivityDependency {
    @JsonProperty(value="activity", required=true)
    private String activity;
    @JsonProperty(value="dependencyConditions", required=true)
    private List<DependencyCondition> dependencyConditions;
    @JsonIgnore
    private Map<String, Object> additionalProperties;
    private static final ClientLogger LOGGER = new ClientLogger(ActivityDependency.class);

    public String activity() {
        return this.activity;
    }

    public ActivityDependency withActivity(String activity) {
        this.activity = activity;
        return this;
    }

    public List<DependencyCondition> dependencyConditions() {
        return this.dependencyConditions;
    }

    public ActivityDependency withDependencyConditions(List<DependencyCondition> dependencyConditions) {
        this.dependencyConditions = dependencyConditions;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public ActivityDependency withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
    }

    public void validate() {
        if (this.activity() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property activity in model ActivityDependency"));
        }
        if (this.dependencyConditions() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property dependencyConditions in model ActivityDependency"));
        }
    }
}

