/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.network;

import io.kubernetes.client.extended.network.LoadBalanceStrategy;
import io.kubernetes.client.extended.network.LoadBalancer;
import io.kubernetes.client.extended.network.exception.NoAvailableAddressException;
import io.kubernetes.client.openapi.models.V1Endpoints;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class EndpointsLoadBalancer
implements LoadBalancer {
    protected final Supplier<V1Endpoints> endpointsSupplier;
    protected final LoadBalanceStrategy strategy;

    public EndpointsLoadBalancer(Supplier<V1Endpoints> endpointsSupplier, LoadBalanceStrategy strategy) {
        this.endpointsSupplier = endpointsSupplier;
        this.strategy = strategy;
    }

    @Override
    public List<String> getAllAvailableIPs() throws NoAvailableAddressException {
        V1Endpoints ep = this.endpointsSupplier.get();
        if (ep == null || ep.getSubsets() == null) {
            throw new NoAvailableAddressException();
        }
        return ep.getSubsets().stream().flatMap(subset -> subset.getAddresses().stream().map(addr -> addr.getIp())).collect(Collectors.toList());
    }

    @Override
    public List<String> getAllAvailableIPs(int port) throws NoAvailableAddressException {
        V1Endpoints ep = this.endpointsSupplier.get();
        if (ep == null || ep.getSubsets() == null) {
            throw new NoAvailableAddressException();
        }
        return ep.getSubsets().stream().filter(subset -> subset.getPorts().stream().anyMatch(epPort -> Integer.valueOf(port).equals(epPort.getPort()))).flatMap(subset -> subset.getAddresses().stream().map(addr -> addr.getIp())).collect(Collectors.toList());
    }

    @Override
    public String getTargetIP() throws NoAvailableAddressException {
        List<String> availableIPs = this.getAllAvailableIPs();
        if (availableIPs.size() == 0) {
            throw new NoAvailableAddressException();
        }
        return this.strategy.chooseIP(availableIPs);
    }

    @Override
    public String getTargetIP(int port) throws NoAvailableAddressException {
        V1Endpoints ep = this.endpointsSupplier.get();
        if (ep == null || ep.getSubsets() == null) {
            throw new NoAvailableAddressException();
        }
        List<String> availableIPs = this.getAllAvailableIPs(port);
        if (availableIPs.size() == 0) {
            throw new NoAvailableAddressException();
        }
        return this.strategy.chooseIP(availableIPs);
    }
}

