/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.common.auth.Credentials;
import com.aliyun.oss.common.auth.RequestSigner;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.common.comm.SignVersion;
import com.aliyun.oss.internal.SignUtils;
import com.aliyun.oss.internal.SignV2Utils;

public class OSSRequestSigner
implements RequestSigner {
    private String httpMethod;
    private String resourcePath;
    private Credentials creds;
    private SignVersion signatureVersion;

    public OSSRequestSigner(String httpMethod, String resourcePath, Credentials creds, SignVersion signatureVersion) {
        this.httpMethod = httpMethod;
        this.resourcePath = resourcePath;
        this.creds = creds;
        this.signatureVersion = signatureVersion;
    }

    @Override
    public void sign(RequestMessage request) throws ClientException {
        String accessKeyId = this.creds.getAccessKeyId();
        String secretAccessKey = this.creds.getSecretAccessKey();
        if (accessKeyId.length() > 0 && secretAccessKey.length() > 0) {
            if (this.signatureVersion == SignVersion.V2) {
                String signature = SignV2Utils.buildSignature(secretAccessKey, this.httpMethod, this.resourcePath, request);
                request.addHeader("Authorization", SignV2Utils.composeRequestAuthorization(accessKeyId, signature, request));
            } else {
                String signature = SignUtils.buildSignature(secretAccessKey, this.httpMethod, this.resourcePath, request);
                request.addHeader("Authorization", SignUtils.composeRequestAuthorization(accessKeyId, signature));
            }
        }
    }
}

