/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.extract.master;

import lombok.Generated;
import org.apache.dolphinscheduler.extract.base.client.Clients;
import org.apache.dolphinscheduler.extract.master.ITaskExecutorEventListener;
import org.apache.dolphinscheduler.task.executor.eventbus.ITaskExecutorEventRemoteReporterClient;
import org.apache.dolphinscheduler.task.executor.events.IReportableTaskExecutorLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorDispatchedLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorFailedLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorKilledLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorPausedLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorRuntimeContextChangedLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorStartedLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorSuccessLifecycleEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExecutorEventRemoteReporterClient
implements ITaskExecutorEventRemoteReporterClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskExecutorEventRemoteReporterClient.class);

    public void reportTaskExecutionEventToMaster(String masterAddress, IReportableTaskExecutorLifecycleEvent taskExecutorLifecycleEvent) {
        try {
            taskExecutorLifecycleEvent.setLatestReportTime(Long.valueOf(System.currentTimeMillis()));
            switch (taskExecutorLifecycleEvent.getType()) {
                case DISPATCHED: {
                    TaskExecutorEventRemoteReporterClient.reportTaskDispatchedEventToMaster(masterAddress, (TaskExecutorDispatchedLifecycleEvent)taskExecutorLifecycleEvent);
                    break;
                }
                case RUNNING: {
                    TaskExecutorEventRemoteReporterClient.reportTaskRunningEventToMaster(masterAddress, (TaskExecutorStartedLifecycleEvent)taskExecutorLifecycleEvent);
                    break;
                }
                case RUNTIME_CONTEXT_CHANGE: {
                    TaskExecutorEventRemoteReporterClient.reportTaskRuntimeContextChangeEventToMaster(masterAddress, (TaskExecutorRuntimeContextChangedLifecycleEvent)taskExecutorLifecycleEvent);
                    break;
                }
                case PAUSED: {
                    TaskExecutorEventRemoteReporterClient.reportTaskPausedEventToMaster(masterAddress, (TaskExecutorPausedLifecycleEvent)taskExecutorLifecycleEvent);
                    break;
                }
                case KILLED: {
                    TaskExecutorEventRemoteReporterClient.reportTaskKilledEventToMaster(masterAddress, (TaskExecutorKilledLifecycleEvent)taskExecutorLifecycleEvent);
                    break;
                }
                case FAILED: {
                    TaskExecutorEventRemoteReporterClient.reportTaskFailedEventToMaster(masterAddress, (TaskExecutorFailedLifecycleEvent)taskExecutorLifecycleEvent);
                    break;
                }
                case SUCCESS: {
                    TaskExecutorEventRemoteReporterClient.reportTaskSuccessEventToMaster(masterAddress, (TaskExecutorSuccessLifecycleEvent)taskExecutorLifecycleEvent);
                    break;
                }
                default: {
                    log.warn("Unsupported TaskExecutionEvent: {}", (Object)taskExecutorLifecycleEvent);
                }
            }
            log.info("Report: {} to master success", (Object)taskExecutorLifecycleEvent);
        }
        catch (Throwable throwable) {
            log.error("Report ITaskExecutorLifecycleEvent: {} to master failed", (Object)taskExecutorLifecycleEvent, (Object)throwable);
        }
    }

    private static void reportTaskDispatchedEventToMaster(String masterAddress, TaskExecutorDispatchedLifecycleEvent taskExecutionDispatchedEvent) {
        ((ITaskExecutorEventListener)Clients.withService(ITaskExecutorEventListener.class).withHost(masterAddress)).onTaskExecutorDispatched(taskExecutionDispatchedEvent);
    }

    private static void reportTaskRunningEventToMaster(String masterAddress, TaskExecutorStartedLifecycleEvent taskExecutionRunningEvent) {
        ((ITaskExecutorEventListener)Clients.withService(ITaskExecutorEventListener.class).withHost(masterAddress)).onTaskExecutorRunning(taskExecutionRunningEvent);
    }

    private static void reportTaskRuntimeContextChangeEventToMaster(String masterAddress, TaskExecutorRuntimeContextChangedLifecycleEvent taskExecutorLifecycleEvent) {
        ((ITaskExecutorEventListener)Clients.withService(ITaskExecutorEventListener.class).withHost(masterAddress)).onTaskExecutorRuntimeContextChanged(taskExecutorLifecycleEvent);
    }

    private static void reportTaskPausedEventToMaster(String masterAddress, TaskExecutorPausedLifecycleEvent taskExecutionPausedEvent) {
        ((ITaskExecutorEventListener)Clients.withService(ITaskExecutorEventListener.class).withHost(masterAddress)).onTaskExecutorPaused(taskExecutionPausedEvent);
    }

    private static void reportTaskKilledEventToMaster(String masterAddress, TaskExecutorKilledLifecycleEvent taskExecutionKilledEvent) {
        ((ITaskExecutorEventListener)Clients.withService(ITaskExecutorEventListener.class).withHost(masterAddress)).onTaskExecutorKilled(taskExecutionKilledEvent);
    }

    private static void reportTaskFailedEventToMaster(String masterAddress, TaskExecutorFailedLifecycleEvent taskExecutionFailedEvent) {
        ((ITaskExecutorEventListener)Clients.withService(ITaskExecutorEventListener.class).withHost(masterAddress)).onTaskExecutorFailed(taskExecutionFailedEvent);
    }

    private static void reportTaskSuccessEventToMaster(String masterAddress, TaskExecutorSuccessLifecycleEvent taskExecutionSuccessEvent) {
        ((ITaskExecutorEventListener)Clients.withService(ITaskExecutorEventListener.class).withHost(masterAddress)).onTaskExecutorSuccess(taskExecutionSuccessEvent);
    }
}

