/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpPipeline;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.appplatform.fluent.AppPlatformManagementClient;
import com.azure.resourcemanager.appplatform.implementation.AppPlatformManagementClientBuilder;
import com.azure.resourcemanager.appplatform.implementation.SpringServicesImpl;
import com.azure.resourcemanager.appplatform.models.SpringServices;
import com.azure.resourcemanager.resources.fluentcore.arm.AzureConfigurable;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.HttpPipelineProvider;
import java.util.Objects;

public final class AppPlatformManager
extends Manager<AppPlatformManagementClient> {
    private SpringServices springServices;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static AppPlatformManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return AppPlatformManager.authenticate(HttpPipelineProvider.buildHttpPipeline((TokenCredential)credential, (AzureProfile)profile), profile);
    }

    public static AppPlatformManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new AppPlatformManager(httpPipeline, profile);
    }

    private AppPlatformManager(HttpPipeline httpPipeline, AzureProfile profile) {
        super(httpPipeline, profile, (Object)new AppPlatformManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).buildClient());
    }

    public SpringServices springServices() {
        if (this.springServices == null) {
            this.springServices = new SpringServicesImpl(this);
        }
        return this.springServices;
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public AppPlatformManager authenticate(TokenCredential credential, AzureProfile profile) {
            return AppPlatformManager.authenticate(this.buildHttpPipeline(credential, profile), profile);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public AppPlatformManager authenticate(TokenCredential var1, AzureProfile var2);
    }
}

