/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.ApiextensionsV1beta1WebhookClientConfig;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="CustomResourceConversion describes how to convert different versions of a CR.")
public class V1beta1CustomResourceConversion {
    public static final String SERIALIZED_NAME_CONVERSION_REVIEW_VERSIONS = "conversionReviewVersions";
    @SerializedName(value="conversionReviewVersions")
    private List<String> conversionReviewVersions = null;
    public static final String SERIALIZED_NAME_STRATEGY = "strategy";
    @SerializedName(value="strategy")
    private String strategy;
    public static final String SERIALIZED_NAME_WEBHOOK_CLIENT_CONFIG = "webhookClientConfig";
    @SerializedName(value="webhookClientConfig")
    private ApiextensionsV1beta1WebhookClientConfig webhookClientConfig;

    public V1beta1CustomResourceConversion conversionReviewVersions(List<String> conversionReviewVersions) {
        this.conversionReviewVersions = conversionReviewVersions;
        return this;
    }

    public V1beta1CustomResourceConversion addConversionReviewVersionsItem(String conversionReviewVersionsItem) {
        if (this.conversionReviewVersions == null) {
            this.conversionReviewVersions = new ArrayList<String>();
        }
        this.conversionReviewVersions.add(conversionReviewVersionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="conversionReviewVersions is an ordered list of preferred `ConversionReview` versions the Webhook expects. The API server will use the first version in the list which it supports. If none of the versions specified in this list are supported by API server, conversion will fail for the custom resource. If a persisted Webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail. Defaults to `[\"v1beta1\"]`.")
    public List<String> getConversionReviewVersions() {
        return this.conversionReviewVersions;
    }

    public void setConversionReviewVersions(List<String> conversionReviewVersions) {
        this.conversionReviewVersions = conversionReviewVersions;
    }

    public V1beta1CustomResourceConversion strategy(String strategy) {
        this.strategy = strategy;
        return this;
    }

    @ApiModelProperty(required=true, value="strategy specifies how custom resources are converted between versions. Allowed values are: - `None`: The converter only change the apiVersion and would not touch any other field in the custom resource. - `Webhook`: API Server will call to an external webhook to do the conversion. Additional information   is needed for this option. This requires spec.preserveUnknownFields to be false, and spec.conversion.webhookClientConfig to be set.")
    public String getStrategy() {
        return this.strategy;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public V1beta1CustomResourceConversion webhookClientConfig(ApiextensionsV1beta1WebhookClientConfig webhookClientConfig) {
        this.webhookClientConfig = webhookClientConfig;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ApiextensionsV1beta1WebhookClientConfig getWebhookClientConfig() {
        return this.webhookClientConfig;
    }

    public void setWebhookClientConfig(ApiextensionsV1beta1WebhookClientConfig webhookClientConfig) {
        this.webhookClientConfig = webhookClientConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1CustomResourceConversion v1beta1CustomResourceConversion = (V1beta1CustomResourceConversion)o;
        return Objects.equals(this.conversionReviewVersions, v1beta1CustomResourceConversion.conversionReviewVersions) && Objects.equals(this.strategy, v1beta1CustomResourceConversion.strategy) && Objects.equals(this.webhookClientConfig, v1beta1CustomResourceConversion.webhookClientConfig);
    }

    public int hashCode() {
        return Objects.hash(this.conversionReviewVersions, this.strategy, this.webhookClientConfig);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1CustomResourceConversion {\n");
        sb.append("    conversionReviewVersions: ").append(this.toIndentedString(this.conversionReviewVersions)).append("\n");
        sb.append("    strategy: ").append(this.toIndentedString(this.strategy)).append("\n");
        sb.append("    webhookClientConfig: ").append(this.toIndentedString(this.webhookClientConfig)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

