/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.registry.api.utils;

import com.google.common.base.Preconditions;
import org.apache.dolphinscheduler.common.model.BaseHeartBeat;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;

public class RegistryUtils {
    public static String getMasterFailoverLockPath(String masterAddress) {
        Preconditions.checkNotNull((Object)masterAddress, (Object)"master address cannot be null");
        return RegistryNodeType.MASTER_FAILOVER_LOCK.getRegistryPath() + "/" + masterAddress;
    }

    public static String getGlobalMasterFailoverNodePath(String serverAddress) {
        return RegistryNodeType.FAILOVER_FINISH_NODES.getRegistryPath() + "/" + serverAddress + "-unknown-unknown";
    }

    public static String getFailoveredNodePath(BaseHeartBeat baseHeartBeat) {
        return RegistryUtils.getFailoveredNodePath(baseHeartBeat.getHost() + ":" + baseHeartBeat.getPort(), baseHeartBeat.getStartupTime(), baseHeartBeat.getProcessId());
    }

    public static String getFailoveredNodePath(String serverAddress, long serverStartupTime, int processId) {
        return RegistryNodeType.FAILOVER_FINISH_NODES.getRegistryPath() + "/" + serverAddress + "-" + serverStartupTime + "-" + processId;
    }
}

