/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLPartitionRef;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLAnalyzeTableStatement
extends SQLStatementImpl {
    protected final List<SQLExprTableSource> tableSources = new ArrayList<SQLExprTableSource>();
    private SQLPartitionRef partition;
    private boolean forColums;
    private List<SQLName> columns = new ArrayList<SQLName>();
    private boolean cacheMetadata;
    private boolean noscan;
    private boolean computeStatistics;
    private SQLIdentifierExpr adbSchema;
    private List<SQLIdentifierExpr> adbColumns = new ArrayList<SQLIdentifierExpr>();
    private List<SQLIdentifierExpr> adbColumnsGroup = new ArrayList<SQLIdentifierExpr>();
    private SQLExpr adbWhere;

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.tableSources);
            this.acceptChild(visitor, this.partition);
            this.acceptChild(visitor, this.columns);
            this.acceptChild(visitor, this.adbSchema);
            this.acceptChild(visitor, this.adbColumns);
            this.acceptChild(visitor, this.adbColumnsGroup);
            this.acceptChild(visitor, this.adbWhere);
        }
        visitor.endVisit(this);
    }

    public List<SQLExprTableSource> getTables() {
        return this.tableSources;
    }

    public SQLExprTableSource getTable() {
        if (this.tableSources.isEmpty()) {
            return null;
        }
        if (this.tableSources.size() == 1) {
            return this.tableSources.get(0);
        }
        throw new UnsupportedOperationException();
    }

    public List<SQLName> getColumns() {
        return this.columns;
    }

    public void setTable(SQLExprTableSource table) {
        if (table != null) {
            table.setParent(this);
        }
        if (this.tableSources.isEmpty()) {
            if (table == null) {
                return;
            }
            this.tableSources.add(table);
            return;
        }
        if (this.tableSources.size() == 1) {
            if (table == null) {
                this.tableSources.remove(0);
            } else {
                this.tableSources.set(0, table);
            }
            return;
        }
        throw new UnsupportedOperationException();
    }

    public SQLIdentifierExpr getAdbSchema() {
        return this.adbSchema;
    }

    public void setAdbSchema(SQLIdentifierExpr adbSchema) {
        this.adbSchema = adbSchema;
    }

    public List<SQLIdentifierExpr> getAdbColumns() {
        return this.adbColumns;
    }

    public void setAdbColumns(List<SQLIdentifierExpr> adbColumns) {
        this.adbColumns = adbColumns;
    }

    public List<SQLIdentifierExpr> getAdbColumnsGroup() {
        return this.adbColumnsGroup;
    }

    public void setAdbColumnsGroup(List<SQLIdentifierExpr> adbColumnsGroup) {
        this.adbColumnsGroup = adbColumnsGroup;
    }

    public SQLExpr getAdbWhere() {
        return this.adbWhere;
    }

    public void setAdbWhere(SQLExpr adbWhere) {
        this.adbWhere = adbWhere;
    }

    public void setTable(SQLName table) {
        this.setTable(new SQLExprTableSource(table));
    }

    public SQLPartitionRef getPartition() {
        return this.partition;
    }

    public void setPartition(SQLPartitionRef x) {
        if (x != null) {
            x.setParent(this);
        }
        this.partition = x;
    }

    public boolean isForColums() {
        return this.forColums;
    }

    public void setForColums(boolean forColums) {
        this.forColums = forColums;
    }

    public boolean isCacheMetadata() {
        return this.cacheMetadata;
    }

    public void setCacheMetadata(boolean cacheMetadata) {
        this.cacheMetadata = cacheMetadata;
    }

    public boolean isNoscan() {
        return this.noscan;
    }

    public void setNoscan(boolean noscan) {
        this.noscan = noscan;
    }

    public boolean isComputeStatistics() {
        return this.computeStatistics;
    }

    public void setComputeStatistics(boolean computeStatistics) {
        this.computeStatistics = computeStatistics;
    }
}

