/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.MetricAlertAction;
import com.azure.resourcemanager.monitor.models.MetricAlertCriteria;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.List;

public final class MetricAlertProperties {
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="severity", required=true)
    private int severity;
    @JsonProperty(value="enabled", required=true)
    private boolean enabled;
    @JsonProperty(value="scopes", required=true)
    private List<String> scopes;
    @JsonProperty(value="evaluationFrequency", required=true)
    private Duration evaluationFrequency;
    @JsonProperty(value="windowSize", required=true)
    private Duration windowSize;
    @JsonProperty(value="targetResourceType")
    private String targetResourceType;
    @JsonProperty(value="targetResourceRegion")
    private String targetResourceRegion;
    @JsonProperty(value="criteria", required=true)
    private MetricAlertCriteria criteria;
    @JsonProperty(value="autoMitigate")
    private Boolean autoMitigate;
    @JsonProperty(value="actions")
    private List<MetricAlertAction> actions;
    @JsonProperty(value="lastUpdatedTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastUpdatedTime;
    @JsonProperty(value="isMigrated", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean isMigrated;
    private static final ClientLogger LOGGER = new ClientLogger(MetricAlertProperties.class);

    public String description() {
        return this.description;
    }

    public MetricAlertProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public int severity() {
        return this.severity;
    }

    public MetricAlertProperties withSeverity(int severity) {
        this.severity = severity;
        return this;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public MetricAlertProperties withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public List<String> scopes() {
        return this.scopes;
    }

    public MetricAlertProperties withScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public Duration evaluationFrequency() {
        return this.evaluationFrequency;
    }

    public MetricAlertProperties withEvaluationFrequency(Duration evaluationFrequency) {
        this.evaluationFrequency = evaluationFrequency;
        return this;
    }

    public Duration windowSize() {
        return this.windowSize;
    }

    public MetricAlertProperties withWindowSize(Duration windowSize) {
        this.windowSize = windowSize;
        return this;
    }

    public String targetResourceType() {
        return this.targetResourceType;
    }

    public MetricAlertProperties withTargetResourceType(String targetResourceType) {
        this.targetResourceType = targetResourceType;
        return this;
    }

    public String targetResourceRegion() {
        return this.targetResourceRegion;
    }

    public MetricAlertProperties withTargetResourceRegion(String targetResourceRegion) {
        this.targetResourceRegion = targetResourceRegion;
        return this;
    }

    public MetricAlertCriteria criteria() {
        return this.criteria;
    }

    public MetricAlertProperties withCriteria(MetricAlertCriteria criteria) {
        this.criteria = criteria;
        return this;
    }

    public Boolean autoMitigate() {
        return this.autoMitigate;
    }

    public MetricAlertProperties withAutoMitigate(Boolean autoMitigate) {
        this.autoMitigate = autoMitigate;
        return this;
    }

    public List<MetricAlertAction> actions() {
        return this.actions;
    }

    public MetricAlertProperties withActions(List<MetricAlertAction> actions) {
        this.actions = actions;
        return this;
    }

    public OffsetDateTime lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Boolean isMigrated() {
        return this.isMigrated;
    }

    public void validate() {
        if (this.scopes() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property scopes in model MetricAlertProperties"));
        }
        if (this.evaluationFrequency() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property evaluationFrequency in model MetricAlertProperties"));
        }
        if (this.windowSize() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property windowSize in model MetricAlertProperties"));
        }
        if (this.criteria() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property criteria in model MetricAlertProperties"));
        }
        this.criteria().validate();
        if (this.actions() != null) {
            this.actions().forEach(e -> e.validate());
        }
    }
}

