/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors;

import com.typesafe.scalalogging.Logger;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.Logger$;
import org.apache.daffodil.runtime1.processors.Suspension;
import org.apache.daffodil.runtime1.processors.SuspensionDeadlockException;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class SuspensionTracker {
    private final int suspensionWaitYoung;
    private final int suspensionWaitOld;
    private final Queue<Suspension> suspensionsYoung;
    private final Queue<Suspension> suspensionsOld;
    private int count;
    private int suspensionStatTracked;
    private int suspensionStatRuns;

    public SuspensionTracker(int suspensionWaitYoung, int suspensionWaitOld) {
        this.suspensionWaitYoung = suspensionWaitYoung;
        this.suspensionWaitOld = suspensionWaitOld;
        this.suspensionsYoung = new Queue(Queue$.MODULE$.$lessinit$greater$default$1());
        this.suspensionsOld = new Queue(Queue$.MODULE$.$lessinit$greater$default$1());
        this.count = 0;
        this.suspensionStatTracked = 0;
        this.suspensionStatRuns = 0;
    }

    public Seq<Suspension> suspensions() {
        return (Seq)this.suspensionsYoung.toSeq().$plus$plus((IterableOnce)this.suspensionsOld.toSeq());
    }

    public void trackSuspension(Suspension s) {
        this.suspensionsYoung.enqueue((Object)s);
        ++this.suspensionStatTracked;
    }

    public void evalSuspensions() {
        if (this.count % this.suspensionWaitOld == 0) {
            this.evalSuspensionQueue(this.suspensionsOld);
        }
        if (this.count % this.suspensionWaitYoung == 0) {
            this.evalSuspensionQueue(this.suspensionsYoung);
            while (this.suspensionsYoung.nonEmpty()) {
                this.suspensionsOld.enqueue(this.suspensionsYoung.dequeue());
            }
        }
        if (this.count == this.suspensionWaitOld) {
            this.count = 0;
            return;
        }
        ++this.count;
    }

    public void requireFinal() {
        while (this.suspensionsYoung.nonEmpty()) {
            this.suspensionsOld.enqueue(this.suspensionsYoung.dequeue());
        }
        this.evalSuspensionQueue(this.suspensionsOld);
        if (this.suspensionsOld.length() == 1) {
            throw Assert$.MODULE$.abort("Invariant broken: " + ("Single suspended expression making no forward progress. " + this.suspensionsOld.apply(0)) + "(SuspensionTracker.this.suspensionsOld.length.!=(1))");
        }
        if (this.suspensionsOld.nonEmpty()) {
            throw new SuspensionDeadlockException((Seq<Suspension>)this.suspensionsOld.toSeq());
        }
        Logger LoggerImpl_this = Logger$.MODULE$.log();
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug(StringOps$.MODULE$.format$extension("Suspension runs/tracked: %d/%d (%.2f%%)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.suspensionStatRuns), BoxesRunTime.boxToInteger((int)this.suspensionStatTracked), BoxesRunTime.boxToFloat((float)((float)this.suspensionStatRuns / (float)this.suspensionStatTracked * (float)100))})));
            return;
        }
    }

    private void evalSuspensionQueue(Queue<Suspension> queue) {
        int countOfNotMakingProgress = 0;
        while (!queue.isEmpty() && countOfNotMakingProgress < queue.length()) {
            Suspension s = (Suspension)queue.dequeue();
            ++this.suspensionStatRuns;
            s.runSuspension();
            if (!s.isDone()) {
                queue.enqueue((Object)s);
            }
            if (s.isDone() || s.isMakingProgress()) {
                countOfNotMakingProgress = 0;
                continue;
            }
            ++countOfNotMakingProgress;
        }
    }
}

