/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class ReattachSessionResponseMessage
extends PacketImpl {
    private int lastConfirmedCommandID;
    private boolean reattached;

    public ReattachSessionResponseMessage(int lastConfirmedCommandID, boolean reattached) {
        super((byte)33);
        this.lastConfirmedCommandID = lastConfirmedCommandID;
        this.reattached = reattached;
    }

    public ReattachSessionResponseMessage() {
        super((byte)33);
    }

    public int getLastConfirmedCommandID() {
        return this.lastConfirmedCommandID;
    }

    public boolean isReattached() {
        return this.reattached;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeInt(this.lastConfirmedCommandID);
        buffer.writeBoolean(this.reattached);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.lastConfirmedCommandID = buffer.readInt();
        this.reattached = buffer.readBoolean();
    }

    @Override
    public boolean isResponse() {
        return true;
    }

    @Override
    public final boolean isRequiresConfirmations() {
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.lastConfirmedCommandID, this.reattached);
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", lastConfirmedCommandID=" + this.lastConfirmedCommandID);
        sb.append(", reattached=" + this.reattached);
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ReattachSessionResponseMessage)) {
            return false;
        }
        ReattachSessionResponseMessage other = (ReattachSessionResponseMessage)obj;
        return this.lastConfirmedCommandID == other.lastConfirmedCommandID && this.reattached == other.reattached;
    }
}

