/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.metrics.micrometer.provider;

import io.micrometer.core.instrument.Tag;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;

public class StandardTags {
    private static final String UNKNOWN = "UNKNOWN";
    private static final String OUTCOME = "outcome";
    private static final Tag URI_UNKNOWN = Tag.of((String)"uri", (String)"UNKNOWN");
    private static final Tag EXCEPTION_NONE = Tag.of((String)"exception", (String)"None");
    private static final Tag STATUS_UNKNOWN = Tag.of((String)"status", (String)"UNKNOWN");
    private static final Tag OUTCOME_UNKNOWN = Tag.of((String)"outcome", (String)"UNKNOWN");
    private static final Tag OUTCOME_INFORMATIONAL = Tag.of((String)"outcome", (String)"INFORMATIONAL");
    private static final Tag OUTCOME_SUCCESS = Tag.of((String)"outcome", (String)"SUCCESS");
    private static final Tag OUTCOME_REDIRECTION = Tag.of((String)"outcome", (String)"REDIRECTION");
    private static final Tag OUTCOME_CLIENT_ERROR = Tag.of((String)"outcome", (String)"CLIENT_ERROR");
    private static final Tag OUTCOME_SERVER_ERROR = Tag.of((String)"outcome", (String)"SERVER_ERROR");
    private static final Tag METHOD_UNKNOWN = Tag.of((String)"method", (String)"UNKNOWN");

    public Tag method(Message request) {
        return Optional.ofNullable(request).map(e -> e.get((Object)"org.apache.cxf.request.method")).filter(e -> e instanceof String).map(e -> (String)e).map(method -> Tag.of((String)"method", (String)method)).orElse(METHOD_UNKNOWN);
    }

    public Tag status(Message response) {
        return Optional.ofNullable(response).map(e -> MessageUtils.getReponseCodeFromMessage((Message)response)).map(code -> Integer.toString(code)).map(status -> Tag.of((String)"status", (String)status)).orElse(STATUS_UNKNOWN);
    }

    public Tag uri(Message request) {
        return this.template(request).orElse(this.requestUri(request));
    }

    public Tag exception(Class<?> exceptionClass) {
        return Optional.ofNullable(exceptionClass).map(Class::getSimpleName).map(e -> Tag.of((String)"exception", (String)(StringUtils.isEmpty((String)e) ? exceptionClass.getName() : e))).orElse(EXCEPTION_NONE);
    }

    public Tag outcome(Message response) {
        Optional<Integer> statusCode = Optional.ofNullable(response).map(e -> MessageUtils.getReponseCodeFromMessage((Message)response));
        if (!statusCode.isPresent()) {
            return OUTCOME_UNKNOWN;
        }
        int status = statusCode.orElseThrow(() -> new NoSuchElementException("Should not throw"));
        if (status < 200) {
            return OUTCOME_INFORMATIONAL;
        }
        if (status < 300) {
            return OUTCOME_SUCCESS;
        }
        if (status < 400) {
            return OUTCOME_REDIRECTION;
        }
        if (status < 500) {
            return OUTCOME_CLIENT_ERROR;
        }
        return OUTCOME_SERVER_ERROR;
    }

    private Tag requestUri(Message request) {
        return Optional.ofNullable(request).map(e -> e.get((Object)"org.apache.cxf.request.uri")).filter(e -> e instanceof String).map(e -> this.stripQueryString((String)e)).map(e -> Tag.of((String)"uri", (String)e)).orElse(this.endpoint(request));
    }

    private Tag endpoint(Message request) {
        return Optional.ofNullable(request).map(e -> e.get((Object)Message.ENDPOINT_ADDRESS)).filter(e -> e instanceof String).map(e -> this.stripQueryString((String)e)).map(e -> Tag.of((String)"uri", (String)e)).orElse(URI_UNKNOWN);
    }

    private Optional<Tag> template(Message request) {
        return Optional.ofNullable(request).map(e -> e.get((Object)"jaxrs.template.uri")).filter(e -> e instanceof String).map(e -> this.stripQueryString((String)e)).map(e -> Tag.of((String)"uri", (String)e));
    }

    private String stripQueryString(String uri) {
        int index = uri.indexOf(63);
        if (index != -1) {
            return uri.substring(0, index);
        }
        return uri;
    }
}

