/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.apache.cassandra.spark.bulkwriter.BulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.CommitCoordinator;
import org.apache.cassandra.spark.bulkwriter.CommitResult;
import org.apache.cassandra.spark.bulkwriter.DirectDataTransferApi;
import org.apache.cassandra.spark.bulkwriter.DirectStreamResult;
import org.apache.cassandra.spark.bulkwriter.MockBulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.bulkwriter.StreamError;
import org.apache.cassandra.spark.bulkwriter.TokenRangeMappingUtils;
import org.apache.cassandra.spark.bulkwriter.TransportContext;
import org.apache.cassandra.spark.bulkwriter.token.TokenRangeMapping;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class CommitCoordinatorTest {
    TokenRangeMapping<RingInstance> topology;
    MockBulkWriterContext context;
    TransportContext.DirectDataBulkWriterContext transportContext;

    CommitCoordinatorTest() {
    }

    @BeforeEach
    public void setup() {
        this.topology = TokenRangeMappingUtils.buildTokenRangeMapping(0, (ImmutableMap<String, Integer>)ImmutableMap.of((Object)"DC1", (Object)3), 3);
        this.context = new MockBulkWriterContext(this.topology);
        this.transportContext = (TransportContext.DirectDataBulkWriterContext)this.context.transportContext();
    }

    @Test
    void commitsForEachSuccessfulUpload() throws ExecutionException, InterruptedException {
        int successfulUploads = 3;
        DirectStreamResult uploadResult = DirectStreamResultBuilder.withTopology(this.topology).withSuccessfulUploads(successfulUploads).build();
        try (CommitCoordinator coordinator = CommitCoordinator.commit((BulkWriterContext)this.context, (TransportContext.DirectDataBulkWriterContext)this.transportContext, (DirectStreamResult[])new DirectStreamResult[]{uploadResult});){
            List commitResults = (List)coordinator.get();
            Assertions.assertThat((List)commitResults).hasSize(successfulUploads);
            commitResults.forEach(cr -> {
                Assertions.assertThat((Map)cr.failures).isEmpty();
                Assertions.assertThat((Map)cr.passed).hasSize(1);
            });
        }
    }

    @Test
    void commitWillNotCommitWhenUploadFailed() throws ExecutionException, InterruptedException {
        int successfulUploads = 1;
        int failedUploads = 2;
        DirectStreamResult uploadResult = DirectStreamResultBuilder.withTopology(this.topology).withSuccessfulUploads(successfulUploads).withFailedUploads(failedUploads).build();
        try (CommitCoordinator coordinator = CommitCoordinator.commit((BulkWriterContext)this.context, (TransportContext.DirectDataBulkWriterContext)this.transportContext, (DirectStreamResult[])new DirectStreamResult[]{uploadResult});){
            List commitResults = (List)coordinator.get();
            Assertions.assertThat((List)commitResults).hasSize(successfulUploads);
            CommitResult cr = (CommitResult)commitResults.get(0);
            Assertions.assertThat((Map)cr.failures).isEmpty();
            Assertions.assertThat((Map)cr.passed).hasSize(successfulUploads);
        }
    }

    @Test
    void commitWillNotCommitWhenAlreadyCommitted() throws ExecutionException, InterruptedException {
        this.context.setCommitResultSupplier((uuids, dc) -> {
            throw new RuntimeException("Should not have called commit");
        });
        int successfulUploads = 3;
        int successfulCommits = 3;
        DirectStreamResult uploadResults = DirectStreamResultBuilder.withTopology(this.topology).withSuccessfulUploads(successfulUploads).withSuccessfulCommits(successfulCommits).build();
        try (CommitCoordinator coordinator = CommitCoordinator.commit((BulkWriterContext)this.context, (TransportContext.DirectDataBulkWriterContext)this.transportContext, (DirectStreamResult[])new DirectStreamResult[]{uploadResults});){
            List commitResults = (List)coordinator.get();
            Assertions.assertThat((List)commitResults).hasSize(successfulUploads);
            commitResults.forEach(cr -> {
                Assertions.assertThat((Map)cr.failures).isEmpty();
                Assertions.assertThat((Map)cr.passed).hasSize(1);
            });
        }
    }

    @Test
    void commitWillReturnFailuresWhenCommitRequestFails() throws ExecutionException, InterruptedException {
        this.context.setCommitResultSupplier((uuids, dc) -> {
            throw new RuntimeException("Intentionally Failing Commit for uuids: " + Arrays.toString(uuids.toArray()));
        });
        int successfulUploads = 3;
        DirectStreamResult uploadResults = DirectStreamResultBuilder.withTopology(this.topology).withSuccessfulUploads(successfulUploads).build();
        try (CommitCoordinator coordinator = CommitCoordinator.commit((BulkWriterContext)this.context, (TransportContext.DirectDataBulkWriterContext)this.transportContext, (DirectStreamResult[])new DirectStreamResult[]{uploadResults});){
            List commitResults = (List)coordinator.get();
            Assertions.assertThat((List)commitResults).hasSize(successfulUploads);
            commitResults.forEach(cr -> {
                Assertions.assertThat((Map)cr.failures).hasSize(1);
                Assertions.assertThat((Map)cr.passed).isEmpty();
            });
        }
    }

    @Test
    void commitWillReturnFailuresWhenCommitFailsOnServerWithSpecificUuids() throws ExecutionException, InterruptedException {
        this.context.setCommitResultSupplier((uuids, dc) -> new DirectDataTransferApi.RemoteCommitResult(false, uuids, Collections.emptyList(), "Failed nodetool import"));
        int successfulUploads = 3;
        DirectStreamResult uploadResults = DirectStreamResultBuilder.withTopology(this.topology).withSuccessfulUploads(successfulUploads).build();
        try (CommitCoordinator coordinator = CommitCoordinator.commit((BulkWriterContext)this.context, (TransportContext.DirectDataBulkWriterContext)this.transportContext, (DirectStreamResult[])new DirectStreamResult[]{uploadResults});){
            List commitResults = (List)coordinator.get();
            Assertions.assertThat((List)commitResults).hasSize(successfulUploads);
            commitResults.forEach(cr -> {
                Assertions.assertThat((Map)cr.failures).hasSize(1);
                Assertions.assertThat((Map)cr.passed).isEmpty();
            });
        }
    }

    @Test
    void commitWillReturnFailuresWhenCommitFailsOnServerWithNoUuids() throws ExecutionException, InterruptedException {
        this.context.setCommitResultSupplier((uuids, dc) -> new DirectDataTransferApi.RemoteCommitResult(false, Collections.emptyList(), Collections.emptyList(), "Failed nodetool import"));
        int successfulUploads = 3;
        DirectStreamResult uploadResults = DirectStreamResultBuilder.withTopology(this.topology).withSuccessfulUploads(successfulUploads).build();
        try (CommitCoordinator coordinator = CommitCoordinator.commit((BulkWriterContext)this.context, (TransportContext.DirectDataBulkWriterContext)this.transportContext, (DirectStreamResult[])new DirectStreamResult[]{uploadResults});){
            List commitResults = (List)coordinator.get();
            Assertions.assertThat((List)commitResults).hasSize(successfulUploads);
            commitResults.forEach(cr -> {
                Assertions.assertThat((Map)cr.failures).hasSize(1);
                Assertions.assertThat((Map)cr.passed).isEmpty();
            });
        }
    }

    static class DirectStreamResultBuilder {
        private static final Range<BigInteger> TEST_RANGE = Range.openClosed((Comparable)BigInteger.valueOf(0L), (Comparable)BigInteger.valueOf(200L));
        private final TokenRangeMapping<RingInstance> topology;
        private int successfulUploads;
        private int failedUploads;
        private int successfulCommits;
        private int failedCommits;
        private RingInstance[] allInstances;

        DirectStreamResultBuilder(TokenRangeMapping<RingInstance> topology) {
            this.topology = topology;
        }

        static DirectStreamResultBuilder withTopology(TokenRangeMapping<RingInstance> topology) {
            return new DirectStreamResultBuilder(topology);
        }

        public DirectStreamResultBuilder withSuccessfulUploads(int successfulUploads) {
            this.successfulUploads = successfulUploads;
            return this;
        }

        public DirectStreamResultBuilder withFailedUploads(int failedUploads) {
            this.failedUploads = failedUploads;
            return this;
        }

        public DirectStreamResultBuilder withSuccessfulCommits(int successfulCommits) {
            this.successfulCommits = successfulCommits;
            return this;
        }

        public DirectStreamResultBuilder withFailedCommits(int failedCommits) {
            this.failedCommits = failedCommits;
            return this;
        }

        DirectStreamResult build() {
            this.allInstances = this.topology.getTokenRanges().keySet().toArray(new RingInstance[0]);
            DirectStreamResult sr = new DirectStreamResult(UUID.randomUUID().toString(), TEST_RANGE, this.buildFailures(), this.buildPassed(), 0L, 0L);
            if (this.successfulCommits > 0 || this.failedCommits > 0) {
                ArrayList<CommitResult> commitResults = new ArrayList<CommitResult>();
                for (RingInstance inst : this.topology.getTokenRanges().keySet()) {
                    CommitResult cr = new CommitResult(sr.sessionID, inst, (Map)ImmutableMap.of((Object)sr.sessionID, (Object)((Range)this.topology.getTokenRanges().get((Object)inst).stream().findFirst().get())));
                    commitResults.add(cr);
                }
                sr.setCommitResults(commitResults);
            }
            return sr;
        }

        private List<RingInstance> buildPassed() {
            return new ArrayList<RingInstance>(Arrays.asList(this.allInstances).subList(0, this.successfulUploads));
        }

        private ArrayList<StreamError> buildFailures() {
            ArrayList<StreamError> failedInstances = new ArrayList<StreamError>();
            for (int i = this.failedUploads - 1; i >= 0; --i) {
                failedInstances.add(new StreamError(TEST_RANGE, this.allInstances[i], "failed"));
            }
            return failedInstances;
        }
    }
}

